#ifndef __FROGGER_H__
#define __FROGGER_H__

#include "game.h"
#include "procz80.h"
#include "psg.h"

BYTE FroggerTest(WORD A);
BYTE FroggerReadPlayer0(WORD A);
BYTE FroggerReadPlayer1(WORD A);
BYTE FroggerReadDipSwitch(WORD A);
BYTE FroggerReadScores(WORD A);
int FroggerOut(WORD A,  BYTE B);
int FroggerIntEnable(WORD A,  BYTE B);
int FroggerSoundCommand(WORD A,  BYTE B);

BYTE FroggerInProc(WORD port);
void FroggerOutProc(BYTE data, BYTE port);
BYTE FroggerAudioInProc(WORD port);
void FroggerAudioOutProc(BYTE data, BYTE port);

class Frogger : public Game
{
private:
protected:
   BYTE BackBuffer[0x400];
   BYTE CharBuffer[0x100];
   ProcZ80 * pProcZ80;
   void * pRWTable[0x20000];
   void * pAudioRWTable[0x20000];
   AYPSG * pAYPSG;
   virtual void Video();
   virtual void Audio();
   virtual void DrawCharacter(int c, int col, int row, BYTE color);
   virtual void DrawSprite (WORD off);
public:
   Frogger();
   virtual ~Frogger();
   virtual void Reset();
   virtual void Execute();
   virtual int  Interrupt();
   virtual void Load();
   virtual void Save();
   virtual void LoadScore();
   virtual void SaveScore();
   BYTE * Background() { return BackBuffer; };
   BYTE * Characters() { return CharBuffer; };
   IOPort * Player0;
   DipSwitch * Player1;
   DipSwitch * Dipswitch;
   friend int FroggerOut(WORD A,  BYTE B);
   friend int FroggerIntEnable(WORD A,  BYTE B);
};

extern Frogger * pFrogger;

#endif

