/*
 *  MAZE (M)ulti (A)sm (Z)80 (E)ngine done by Ishmair (ishmair@vnet.es).
 */

#ifndef __MAZE_H__
#define __MAZE_H__

#include "rockdefs.h"

/* These functions are exported by MAZE */
#ifdef __cplusplus
extern "C" 
{
#endif

   void MAZE();			/* Main routine */
   void StdGetMem();		/* convenience function for a standard Read action */
   void StdWriteMem();	/* convenience function for a standard Write action */
   void StdDoNotWrite();	/* convenience function to protect ROM areas */
   void StdForceNMI();	/* function to force an NMI */

/* The value returned by MAZE upon return */
extern int ErrorReport;

/* Two functions that can be used to specify reads and writes to remapped */
/* rom areas. (Don't know how to use them, see MAZE024.ASM for details.   */
   void FixedGetMem();
   void FixedWriteMem();

/* Structures for the variables maze expects the user to supply */
typedef struct {
   void *ROMoffset;		/* Pointer to the CPU's rom base */
   void *GetMemoffset;		/* Pointer to the CPU's Memory Read and Write Table */
   int  Instructioncount;	/* Number of instructions to execute */
   int  DebugMode;		/* Debug Mode, not implemented, so keep 0 */
   BYTE (*InProc)(WORD port);
   void (*OutProc)(BYTE data, BYTE port);
} CPUtable;

typedef struct {
	WORD PC;
	WORD SP;
	WORD AF;
	WORD BC;
	WORD DE;
	WORD HL;
	WORD IX;
	WORD IY;
	WORD AFS;
	WORD BCS;
	WORD DES;
	WORD HLS;
	BYTE I;
	BYTE R;
	WORD ints;
	BYTE mode;
} CPUregisterset;

/*
 *  NOTE : The following functions will have to be done is assembly.
 *  The Z80 engine calls these whenever an IN or OUT instruction is
 *  encountered. It does NOT save the CPU registers when calling these
 *  functions !
 */

void INPROCEDURE();
void OUTPROCEDURE();

/*
 *  The following procedure could be a hook for debugging purposes, the
 *  Z80 engine calls this one whenever it encounters a debug adress.
 *  CPU registers are NOT saved when it enters this routine !
 */
void Debug();

#ifdef __cplusplus
}
#endif

#endif
