#include <stdio.h>
#include "nibbler.h"

BYTE nibblerColors[] =
{
   0x00, 0x3F, 0xFF, 0xC0, 0x00, 0xC7, 0x38, 0x05,
   0x00, 0x07, 0xC0, 0x3F, 0x00, 0x3F, 0xE0, 0x05,
   0x00, 0x07, 0xAC, 0xC0, 0x00, 0xFF, 0xC5, 0x2F,
   0x00, 0xC0, 0x05, 0x2F, 0x00, 0x3F, 0x05, 0xC7,
   0x00, 0x07, 0xFF, 0xC5, 0x00, 0x38, 0xAD, 0xA8,
   0x00, 0xAD, 0x3F, 0xC0, 0x00, 0xFF, 0x07, 0xFF,
   0x00, 0x3F, 0xC0, 0xAD, 0x00, 0xFF, 0xC5, 0x3F,
   0x00, 0xFF, 0x3F, 0x07, 0x00, 0x07, 0xC5, 0x3F
};

ROMS nibblerRoms[] = 
{
   { 0x3000, "ic12",	   4096, "code" },
   { 0x4000, "ic07", 	4096, "code" },
   { 0x5000, "ic08", 	4096, "code" },
   { 0x6000, "ic09", 	4096, "code" },
   { 0x7000, "ic10",  	4096, "code / graphics" },
   { 0x8000, "ic14",  	4096, "graphics" },
   { 0x9000, "ic15",  	4096, "data" },
   { 0xa000, "ic16",  	4096, "code - graphics" },
   { 0xb000, "ic17",  	4096, "graphics - code" },
   { 0xC000, "ic50",    4096, "graphics" },
   { 0xD000, "ic51",    4096, "graphics" },
   { 0xF000, "ic14",  	4096, "vectors" },
   { 0xE000, "ic52",    2048, "sound" },
   { 0xE800, "ic53",    2048, "sound" },
   { 0, NULL, 0, NULL }	
};

MemoryWrite NibblerWrite[] = 
{
   { 0x2100, 0x2103, NibblerOut }, 
   { 0x2400, 0x2400, RockOlaSpeechOut }, 
   { 0xFFFF, 0xFFFF, NULL }
};

MemoryRead NibblerRead[] = 
{
   { 0x2104, 0x2107, RockOlaReadPlayer },
   { 0x0290, 0x02B7, NibblerReadScores },
   { 0xFFFF, 0xFFFF, NULL }
};

Nibbler * pNibbler; 

Nibbler::Nibbler() : RockOla(nibblerRoms, "nibbler")
{
   pNibbler = this;
   pProc6502->SetMemoryRW(NibblerWrite, NibblerRead, 12000, pRAM);
   Dipswitch->SetMen(0, 1, "3 Nibblers", "4 Nibblers", "5 Nibblers", "6 Nibblers");

   strcpy(Name, "nibbler");
   strcpy(Descript, "Nibbler");

   Sound[0] = SoundBase[0] = oSoundBase[0] = 0xE000;
   Sound[1] = SoundBase[1] = oSoundBase[1] = 0xE000;
   ROM1 = 0xC800;
   ROM2 = 0xD800;
   VScroll = 0x2200;
   HScroll = 0x2300;
}

Nibbler::~Nibbler()
{
}

void Nibbler::Reset()
{
   // setup display
   pDisplay = new Display(224, 256, 224, 256, 32, 0, 0, 0, scr224x256, 200);
   pColors = nibblerColors;
   BuildText (0x8000, 0x8050, 0x8130, 0x8180);

   RockOla::Reset();
}

void Nibbler::LoadScore()
{
   if (!ScoreLoaded && memcmp (pRAM + 0x290, "\x00\x50\x00\x00", 4) == 0 && 
      memcmp (pRAM + 0x2B4, "\x00\x05\x00\x00", 4) == 0)
      {
      ReadScore(0x290, 0x60);
      ScoreLoaded = 1;
      }
}

void Nibbler::SaveScore()
{
   WriteScore(0x290, 0x70);
}

int NibblerOut(WORD A, BYTE B)
{
   switch (A & 0x03)
      {
      // port 0
      case 0:
         if (pGame->Sound())                                                
            {
            pNibbler->SoundBase[0] = ((B & 0x07) << 8) + 0xE000;
            pNibbler->CheckSoundReset(0);
            pNibbler->CheckWave(B, 0x80, 0, pNibbler->ExplosionWave, 64, FALSE);

            if (B & 0x08)
               pNibbler->NoSound[0] = FALSE;
            else
               pNibbler->NoSound[0] = TRUE;
            }

         pNibbler->LastPort[0] = B;
         break;

      // port 1
      case 1:
         if (pGame->Sound())                                                
            {
            pNibbler->SoundBase[1] = ((B & 0x07) << 8) + 0xE000;
            pNibbler->CheckSoundReset(1);

            if (B & 0x08)
               pNibbler->NoSound[1] = FALSE;
            else
               pNibbler->NoSound[1] = TRUE;
            }

         pNibbler->LastPort[1] = B;
         break;

      // port 2
      case 2:
         pNibbler->LastPort[2] = B;
         break;

      // port 3
      case 3:
         pNibbler->LastPort[3] = 0;
         break;
      }

   pGame->RAM()[A] = B;
   return 0;
}

BYTE NibblerReadScores(WORD A)
{
   pNibbler->LoadScore();
   return pGame->RAM()[A];
}


