#include <stdio.h>
#include "pepper2.h"

BYTE pepper2Colors[] = 
{
   0x00, 0x38, 0xC0, 0xFF, 0x00, 0x38, 0xC0, 0xFF, // ???
   0x00, 0xA8, 0xC0, 0xFF, 0x00, 0x3F, 0xC0, 0xFF, // maze path
   0x00, 0x38, 0xC0, 0xF8, 0x00, 0x38, 0xC0, 0xF8, // maze fills
   0x00, 0x38, 0xC0, 0xF8, 0x00, 0x38, 0xC0, 0xF8, // signs
   0x00, 0x07, 0xF8, 0x3F, 0xC7, 0xF8, 0x07, 0x3F  // sprites
};

ROMS pepper2Roms[] = 
{
   { 0x9000,  "main_12a", 4096, "" },
   { 0xA000,  "main_11a", 4096, "" },
   { 0xB000,  "main_10a", 4096, "" },
   { 0xC000,  "main_9a",  4096, "" },
   { 0xD000,  "main_8a",  4096, "" },
   { 0xE000,  "main_7a",  4096, "" },
   { 0xF000,  "main_6a",  4096, "" },
   { 0x7000,  "main_11d", 2048, "graphics" },
   { 0, NULL, 0, NULL }	
};

ROMS pepper2SoundRoms[] = 
{
   { 0x6800, "audio_5a",   2048, "tables" },
   { 0x7000, "audio_6a",   2048, "tables" },
   { 0x7800, "audio_7a",   2048, "code" },
   { 0xF800, "audio_7a",   2048, "vectors" },
   { 0, NULL, 0, NULL }	
};

MemoryWrite Pepper2Write[] = 
{
   { 0x4000, 0x43FF, Pepper2Out },
   { 0x6000, 0x67FF, Pepper2Out },
   { 0xFFFF, 0xFFFF, NULL }
};

MemoryRead Pepper2Read[] = 
{
	{ 0x5100, 0x5101, ExidyReadPlayer },
	{ 0x5103, 0x5103, ExidyReadPlayer },
	{ 0x5200, 0x5203, ExidyReadPlayer },
	{ 0x5213, 0x5213, ExidyReadPlayer },
   { 0xFFFF, 0xFFFF, NULL }
};

MemoryWrite Pepper2SoundWrite[] = 
{
   { 0xFFFF, 0xFFFF, NULL }
};

MemoryRead Pepper2SoundRead[] = 
{
   { 0xFFFF, 0xFFFF, NULL }
};

Pepper2 * pPepper2;

Pepper2::Pepper2() : Exidy(pepper2Roms, pepper2SoundRoms, "pepper2")
{
   pPepper2 = this;
   pProc6502->SetMemoryRW(Pepper2Write, Pepper2Read, 10000, pRAM, 1);
   pProc6502->SetMemoryRW(Pepper2SoundWrite, Pepper2SoundRead, 10000, pAudioRAM, 2);

   strcpy(Name, "pepper2");
   strcpy(Descript, "Pepper II");

   Dipswitch->SetMen(5, 1, "5 Men", "4 Men", "3 Men", "Not Used");
}

Pepper2::~Pepper2()
{
}

void Pepper2::Reset()
{
   pDisplay = new Display(256, 256, 256, 256, 0, 0, 0, 0, scr256x256, 200);
   pColors = pepper2Colors;
   BuildText(0xDF06, 0xDF56, 0xE026, 0xE026);

   Exidy::Reset();
}

void Pepper2::Audio()
{
}

void Pepper2::LoadScore()
{
}

void Pepper2::SaveScore()
{
}

void Pepper2::DrawCharacter (int c, int col, int row)
{
	int x, y;
   BYTE result;      
   BYTE b1, b2;
   BYTE mask;

   BYTE * ROM1 = pRAM + 0x6000 + 8 * c;
   BYTE * ROM2 = ROM1 + 0x800;

   for (y=0; y<8; y++)
      {
      b1 = *ROM1++;
      b2 = *ROM2++;
      for (x=0; x<8; x++)                    
         {
         mask = 0x80 >> x; 
         result = (b1 & mask) == mask ? pColors[(c>>6)+1] : pColors[0];
         result = (b1 & mask) == mask ? 2 : 0; 
         result |= (b2 & mask) == mask ? 1 : 0;
         result = (c>>6)*8 + ((pRAM[0x5101]>>5)&1)*4 + result;
         pDisplay->Background()->line[row+y][col+x] = pColors[result]; 
         }
      }
}

int Pepper2Out(WORD A,  BYTE B)
{
   if (A >= 0x4000 && A < 0x4400 && pGame->RAM()[A] != B)
      pExidy->Background()[A & 0x0FFF] = 1;
   else
      pExidy->Characters()[(A & 0x0FFF)>>3] = 1;

   pGame->RAM()[A] = B;
   return 0;
}

BYTE Pepper2ReadScores(WORD A)
{
   return 0;
}


