#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <memory.h>
#include <conio.h>
#include <allegro.h>  
#include <audio.h>
#include <dos.h>
#include <go32.h>
#include "gui.h"
#include "rockultr.h"
#include "logo.h"
#include "rockola.h"
#include "vanguard.h"
#include "fantasy.h"
#include "nibbler.h"
#include "exidy.h"
#include "pepper2.h"
#include "mtrap.h"
#include "venture.h"
#include "frogger.h"
#include "galax.h"
#include "mcresta.h"
#include "mcrestab.h"
#include "galaxian.h"
#include "supergal.h"
#include "pisces.h"
#include "qix.h"
#include "scramble.h"

unsigned short core_select;
int mode;

char * credits = "Rockulator++ v0.97 - copyright 1997 by BJ Software.  "
   "Original concept and design by Brian Levine.  "
   "Allegro game library by Shawn Hargreaves.  "
   "S.E.A.L. audio library by Carlos Hasen.  "
   "Multi-6502 engine by Neil Bradley.  "
   "M.A.Z.E. Z80 engine by Ishmair.  "
   "Multi-6809 engine by Pat Lawrence.  ";
char * vanguardDesc = "Vanguard - Class developed by Brian Levine and Martin Scragg.";
char * fantasyDesc = "Fantasy - Class developed by Brian Levine and Martin Scragg.";
char * nibblerDesc = "Nibbler - Class developed by Brian Levine and Martin Scragg.";
char * ventureDesc = "Venture - Class developed by Marc LaFontaine, Nicola Salmoria, "
   "Mike Balfour and Brian Levine.";
char * mtrapDesc = "Mouse Trap - Class developed by Marc LaFontaine, "
   "Mike Balfour and Brian Levine.";
char * pepper2Desc = "Pepper II - Class developed by Marc LaFontaine, "
   "Mike Balfour and Brian Levine.";
char * mcrestaDesc = "Moon Cresta - Class developed by Robert Anshuetz, "
   "Nicola Salmoria, Gary Walton and Brian Levine.";
char * mcrestabDesc = "Moon Cresta (bootleg) - Class developed by Robert Anshuetz, "
   "Nicola Salmoria, Gary Walton and Brian Levine.";
char * galaxianDesc = "Galaxian - Class developed by Robert Anshuetz, "
   "Nicola Salmoria and Brian Levine.";
char * supergalDesc = "Super Galaxian - Class developed by Robert Anshuetz, "
   "Nicola Salmoria and Brian Levine.";
char * piscesDesc = "Pisces - Class developed by Robert Anshuetz, "
   "Nicola Salmoria and Brian Levine.";
char * froggerDesc = "Frogger - Class developed by Robert Anshuetz, "
   "Nicola Salmoria, Mirko Buffoni and Brian Levine.";
char * scrambleDesc = "Scramble - Class developed by Nicola Salmoria, "
   "Mike Balfour and Brian Levine.";
char * scobraDesc = "Super Cobra - Class developed by Nicola Salmoria "
   "Brian Levine.";
char * theendDesc = "The End - Class developed by Nicola Salmoria, "
   "Ville Laitinen, Mike Balfour and Brian Levine.";

Desktop * desktop;
MainWindow * win;
Marquee * marquee;
Bitmap * logoBmp;

VanguardButton::VanguardButton(int id, int x, int y, int w, int h, int color, int hcolor,
   int lcolor, GUIObject *parent) 
   : Button (id, x, y, w, h, color, hcolor, lcolor, parent)
{
   SetText("Vanguard");
}

void VanguardButton::ClickHandler()
{
   pGame = (Game *) new Vanguard;
   desktop->SetOptions(vanguardDesc);
}

FantasyButton::FantasyButton(int id, int x, int y, int w, int h, int color, int hcolor,
   int lcolor, GUIObject *parent) 
   : Button (id, x, y, w, h, color, hcolor, lcolor, parent)
{
   SetText("Fantasy");
}

void FantasyButton::ClickHandler()
{
   pGame = (Game *) new Fantasy;
   desktop->SetOptions(fantasyDesc);
}

NibblerButton::NibblerButton(int id, int x, int y, int w, int h, int color, int hcolor,
   int lcolor, GUIObject *parent) 
   : Button (id, x, y, w, h, color, hcolor, lcolor, parent)
{
   SetText("Nibbler");
}

void NibblerButton::ClickHandler()
{
   pGame = (Game *) new Nibbler;
   desktop->SetOptions(nibblerDesc);
}

FroggerButton::FroggerButton(int id, int x, int y, int w, int h, int color, int hcolor,
   int lcolor, GUIObject *parent) 
   : Button (id, x, y, w, h, color, hcolor, lcolor, parent)
{
   SetText("Frogger");
}

void FroggerButton::ClickHandler()
{
   pGame = (Game *) new Frogger;
   desktop->SetOptions(froggerDesc);
}

VentureButton::VentureButton(int id, int x, int y, int w, int h, int color, int hcolor,
   int lcolor, GUIObject *parent) 
   : Button (id, x, y, w, h, color, hcolor, lcolor, parent)
{
   SetText("Venture");
}

void VentureButton::ClickHandler()
{
   pGame = (Game *) new Venture;
   desktop->SetOptions(ventureDesc);
}

Pepper2Button::Pepper2Button(int id, int x, int y, int w, int h, int color, int hcolor,
   int lcolor, GUIObject *parent) 
   : Button (id, x, y, w, h, color, hcolor, lcolor, parent)
{
   SetText("Pepper 2");
}

void Pepper2Button::ClickHandler()
{
   pGame = (Game *) new Pepper2;
   desktop->SetOptions(pepper2Desc);
}

MTrapButton::MTrapButton(int id, int x, int y, int w, int h, int color, int hcolor,
   int lcolor, GUIObject *parent) 
   : Button (id, x, y, w, h, color, hcolor, lcolor, parent)
{
   SetText("Mouse Trap");
}

void MTrapButton::ClickHandler()
{
   pGame = (Game *) new MTrap;
   desktop->SetOptions(mtrapDesc);
}

GalaxianButton::GalaxianButton(int id, int x, int y, int w, int h, int color, int hcolor,
   int lcolor, GUIObject *parent) 
   : Button (id, x, y, w, h, color, hcolor, lcolor, parent)
{
   SetText("Galaxian");
}

void GalaxianButton::ClickHandler()
{
   pGame = (Game *) new Galaxian;
   desktop->SetOptions(galaxianDesc);
}

SuperGalButton::SuperGalButton(int id, int x, int y, int w, int h, int color, int hcolor,
   int lcolor, GUIObject *parent) 
   : Button (id, x, y, w, h, color, hcolor, lcolor, parent)
{
   SetText("Super Galaxian");
}

void SuperGalButton::ClickHandler()
{
   pGame = (Game *) new SuperGalaxian;
   desktop->SetOptions(supergalDesc);
}

MCrestaButton::MCrestaButton(int id, int x, int y, int w, int h, int color, int hcolor,
   int lcolor, GUIObject *parent) 
   : Button (id, x, y, w, h, color, hcolor, lcolor, parent)
{
   SetText("Moon Cresta");
}

void MCrestaButton::ClickHandler()
{
   pGame = (Game *) new MCresta;
   desktop->SetOptions(mcrestaDesc);
}

MCrestaBButton::MCrestaBButton(int id, int x, int y, int w, int h, int color, int hcolor,
   int lcolor, GUIObject *parent) 
   : Button (id, x, y, w, h, color, hcolor, lcolor, parent)
{
   SetText("Moon Cresta B");
}

void MCrestaBButton::ClickHandler()
{
   pGame = (Game *) new MCrestaBoot;
   desktop->SetOptions(mcrestabDesc);
}

PiscesButton::PiscesButton(int id, int x, int y, int w, int h, int color, int hcolor,
   int lcolor, GUIObject *parent) 
   : Button (id, x, y, w, h, color, hcolor, lcolor, parent)
{
   SetText("Pisces");
}

void PiscesButton::ClickHandler()
{
   pGame = (Game *) new Pisces;
   desktop->SetOptions(piscesDesc);
}

ScrambleButton::ScrambleButton(int id, int x, int y, int w, int h, int color, int hcolor,
   int lcolor, GUIObject *parent) 
   : Button (id, x, y, w, h, color, hcolor, lcolor, parent)
{
   SetText("Scramble");
}

void ScrambleButton::ClickHandler()
{
   pGame = (Game *) new Scramble;
   desktop->SetOptions(scrambleDesc);
}

SCobraButton::SCobraButton(int id, int x, int y, int w, int h, int color, int hcolor,
   int lcolor, GUIObject *parent) 
   : Button (id, x, y, w, h, color, hcolor, lcolor, parent)
{
   SetText("Super Cobra");
}

void SCobraButton::ClickHandler()
{
   pGame = (Game *) new SCobra;
   desktop->SetOptions(scobraDesc);
}

TheEndButton::TheEndButton(int id, int x, int y, int w, int h, int color, int hcolor,
   int lcolor, GUIObject *parent) 
   : Button (id, x, y, w, h, color, hcolor, lcolor, parent)
{
   SetText("The End");
}

void TheEndButton::ClickHandler()
{
   pGame = (Game *) new TheEnd;
   desktop->SetOptions(theendDesc);
}

CancelButton::CancelButton(int id, int x, int y, int w, int h, int color, int hcolor,
   int lcolor, GUIObject *parent) 
   : Button (id, x, y, w, h, color, hcolor, lcolor, parent)
{
   SetText("Cancel");
}

void CancelButton::ClickHandler()
{
   win->ExitFlag = 1;   
}

StartButton::StartButton(int id, int x, int y, int w, int h, int color, int hcolor,
   int lcolor, GUIObject *parent) 
   : Button (id, x, y, w, h, color, hcolor, lcolor, parent)
{
   SetText("Start");
}

void StartButton::ClickHandler()
{
   if (pGame)
      {
      mouse->Sleep();
      win->SelectOptions();
      pGame->Reset();
      pGame->Execute();   
      if (mode)
         set_gfx_mode(GFX_VESA2L, 640, 480, 0, 0);
      else
         set_gfx_mode(GFX_MODEX, 400, 300, 0, 0);
      desktop->Show();
      logoBmp->Draw((mode?230:110), 2);
      win->Show();
      win->Update();
      marquee->Show();
      mouse->Set();
      mouse->Wake();
      }
}

Desktop::Desktop(int id, int x, int y, int w, int h, int color) 
   : Box(id, x, y, w, h, color),
     btnVanguard(110, (mode?132:8), 24, 120, 20, 7, 15, 8, this),
     btnFantasy(111, (mode?260:136), 24, 120, 20, 7, 15, 8, this),
     btnNibbler(112, (mode?388:264), 24, 120, 20, 7, 15, 8, this),

     btnVenture(114, (mode?132:8), 48, 120, 20, 7, 15, 8, this),
     btnPepper2(115, (mode?260:136), 48, 120, 20, 7, 15, 8, this),
     btnMTrap(116, (mode?388:264), 48, 120, 20, 7, 15, 8, this),

     btnGalaxian(120, (mode?132:8), 72, 120, 20, 7, 15, 8, this),
     btnSuperGal(121, (mode?260:136), 72, 120, 20, 7, 15, 8, this),
     btnFrogger(118, (mode?388:264), 72, 120, 20, 7, 15, 8, this),

     btnMCresta(124, (mode?132:8), 96, 120, 20, 7, 15, 8, this),
     btnMCrestaB(115, (mode?260:136), 96, 120, 20, 7, 15, 8, this),
     btnPisces(116, (mode?388:264), 96, 120, 20, 7, 15, 8, this),

     btnScramble(125, (mode?132:8), 120, 120, 20, 7, 15, 8, this),
     btnSCobra(126, (mode?260:136), 120, 120, 20, 7, 15, 8, this),
     btnTheEnd(126, (mode?388:264), 120, 120, 20, 7, 15, 8, this)
{      
}

void Desktop::SetOptions(char *desc)
{
   if (pGame->errorCode())
      {
      // display a window with the missing rom images
      return;
      }

   win = new MainWindow(130, (mode?160:40), (mode?120:30), 320, 240);
   win->title()->SetText("Set Game Options");
   win->SetOptions();
   mouse->SetWindow(win);
   win->Show();
   win->Update();
   mouse->Show();
   if (desc) marquee->SetText(desc);
   while(!win->ExitFlag)
      {
      marquee->Update();
      mouse->Update();
      }

   win->Hide();
   delete win;
   if(pGame)
      {
      delete pGame;
      pGame = (Game*)NULL;
      }

   marquee->SetText(credits);
   mouse->SetWindow(desktop);
}

MainWindow::MainWindow(int id, int x, int y, int w, int h) 
   : Window(id, x, y, w, h),
   soundGrp(140, 4, 4, 150, 60, 7, 15, 8, this),
   btnAutoSound(141, 5, 4, 15, 8, &soundGrp),
   btnSB(142, 5, 16, 15, 8, &soundGrp),
   btnNoSound(143, 5, 28, 15, 8, &soundGrp),
   menGrp(170, 157, 4, 150, 60, 7, 15, 8, this),
   btnMen1(171, 5, 4, 15, 8, &menGrp),
   btnMen2(172, 5, 16, 15, 8, &menGrp),
   btnMen3(173, 5, 28, 15, 8, &menGrp),
   btnMen4(174, 5, 40, 15, 8, &menGrp),
   bonusGrp(175, 4, 68, 150, 60, 7, 15, 8, this),
   btnBonus1(176, 5, 4, 15, 8, &bonusGrp),
   btnBonus2(177, 5, 16, 15, 8, &bonusGrp),
   btnBonus3(178, 5, 28, 15, 8, &bonusGrp),
   btnBonus4(179, 5, 40, 15, 8, &bonusGrp),
   coinsGrp(190, 157, 68, 150, 60, 7, 15, 8, this),
   btnCoins1(191, 5, 4, 15, 8, &coinsGrp),
   btnCoins2(192, 5, 16, 15, 8, &coinsGrp),
   btnCoins3(193, 5, 28, 15, 8, &coinsGrp),
   btnCoins4(194, 5, 40, 15, 8, &coinsGrp),
   levelGrp(185, 4, 132, 150, 60, 7, 15, 8, this),
   btnLevel1(186, 5, 4, 15, 8, &levelGrp),
   btnLevel2(187, 5, 16, 15, 8, &levelGrp),
   btnLevel3(188, 5, 28, 15, 8, &levelGrp),
   btnLevel4(189, 5, 40, 15, 8, &levelGrp),
   extraGrp(180, 157, 132, 150, 60, 7, 15, 8, this),
   btnExtra1(181, 5, 4, 15, 8, &extraGrp),
   btnExtra2(182, 5, 16, 15, 8, &extraGrp),
   btnExtra3(183, 5, 28, 15, 8, &extraGrp),
   btnExtra4(184, 5, 40, 15, 8, &extraGrp),
   btnJoy(150, 4, 196, 7, 15, 8, this),
   btnThrottle(151, 4, 208, 7, 15, 8, this),
   btnStart(160, 236, 196, 72, 20, 3, 15, 8, this),
   btnCancel(162, 160, 196, 72, 20, 3, 15, 8, this)
{      
   btnAutoSound.SetText("Auto Sound");
   btnSB.SetText("SoundBlaster");
   btnNoSound.SetText("No Sound");
   btnJoy.SetText("Disable Joystick");
   btnThrottle.SetText("Enable Throttling");

   ExitFlag = 0;
}

void MainWindow::Update()
{
   if (!pGame->menDSW())
      menGrp.Hide();
   else if (pGame->menDSW()->menSize() == 0)
      menGrp.Hide();
   else if (pGame->menDSW()->menSize() < 2)
      {
      btnMen3.Hide();
      btnMen4.Hide();
      }

   if (!pGame->bonusDSW())
      bonusGrp.Hide();
   else if (pGame->bonusDSW()->bonusSize() == 0)
      bonusGrp.Hide();
   else if (pGame->bonusDSW()->bonusSize() < 2)
      {
      btnBonus3.Hide();
      btnBonus4.Hide();
      }

   if (!pGame->coinsDSW())
      coinsGrp.Hide();
   else if (pGame->coinsDSW()->coinsSize() == 0)
      coinsGrp.Hide();
   else if (pGame->coinsDSW()->coinsSize() < 2)
      {
      btnCoins3.Hide();
      btnCoins4.Hide();
      }

   if (!pGame->levelDSW())
      levelGrp.Hide();
   else if (pGame->levelDSW()->levelSize() == 0)
      levelGrp.Hide();
   else if (pGame->levelDSW()->levelSize() < 2)
      {
      btnLevel3.Hide();
      btnLevel4.Hide();
      }

   if (!pGame->extraDSW())
      extraGrp.Hide();
   else if (pGame->extraDSW()->extraSize() == 0)
      extraGrp.Hide();
   else if (pGame->extraDSW()->extraSize() < 2)
      {
      btnExtra3.Hide();
      btnExtra4.Hide();
      }
}

void MainWindow::SetOptions()
{
   btnAutoSound.SetState(RadioButton::Down);
   
   if (pGame->menDSW() != (DipSwitch*)NULL)
      {
      if (pGame->menDSW()->menSize())
         {
         btnMen1.SetText(pGame->menDSW()->men(0).Description);
         if (pGame->menDSW()->menDefault() == 0)
            btnMen1.SetState(RadioButton::Down);
         btnMen2.SetText(pGame->menDSW()->men(1).Description);
         if (pGame->menDSW()->menDefault() == 1)
            btnMen2.SetState(RadioButton::Down);
         }
      if (pGame->menDSW()->menSize() > 2)
         {
         btnMen3.SetText(pGame->menDSW()->men(2).Description);
         if (pGame->menDSW()->menDefault() == 2)
            btnMen3.SetState(RadioButton::Down);
         btnMen4.SetText(pGame->menDSW()->men(3).Description);
         if (pGame->menDSW()->menDefault() == 3)
            btnMen4.SetState(RadioButton::Down);
         }
      }

   if (pGame->bonusDSW() != (DipSwitch*)NULL)
      {
      if (pGame->bonusDSW()->bonusSize())
         {
         btnBonus1.SetText(pGame->bonusDSW()->bonus(0).Description);
         if (pGame->bonusDSW()->bonusDefault() == 0)
            btnBonus1.SetState(RadioButton::Down);
         btnBonus2.SetText(pGame->bonusDSW()->bonus(1).Description);
         if (pGame->bonusDSW()->bonusDefault() == 1)
            btnBonus2.SetState(RadioButton::Down);
         }
      if (pGame->bonusDSW()->bonusSize() > 2)
         {
         btnBonus3.SetText(pGame->bonusDSW()->bonus(2).Description);
         if (pGame->bonusDSW()->bonusDefault() == 2)
            btnBonus3.SetState(RadioButton::Down);
         btnBonus4.SetText(pGame->bonusDSW()->bonus(3).Description);
         if (pGame->bonusDSW()->bonusDefault() == 3)
            btnBonus4.SetState(RadioButton::Down);
         }
      }

   if (pGame->coinsDSW() != (DipSwitch*)NULL)
      {
      if (pGame->coinsDSW()->coinsSize())
         {
         btnCoins1.SetText(pGame->coinsDSW()->coins(0).Description);
         if (pGame->coinsDSW()->coinsDefault() == 0)
            btnCoins1.SetState(RadioButton::Down);
         btnCoins2.SetText(pGame->coinsDSW()->coins(1).Description);
         if (pGame->coinsDSW()->coinsDefault() == 1)
            btnCoins2.SetState(RadioButton::Down);
         }
      if (pGame->coinsDSW()->coinsSize() > 2)
         {
         btnCoins3.SetText(pGame->coinsDSW()->coins(2).Description);
         if (pGame->coinsDSW()->coinsDefault() == 2)
            btnCoins3.SetState(RadioButton::Down);
         btnCoins4.SetText(pGame->coinsDSW()->coins(3).Description);
         if (pGame->coinsDSW()->coinsDefault() == 3)
            btnCoins4.SetState(RadioButton::Down);
         }
      }

   if (pGame->levelDSW() != (DipSwitch*)NULL)
      {
      if (pGame->levelDSW()->levelSize())
         {
         btnLevel1.SetText(pGame->levelDSW()->level(0).Description);
         if (pGame->levelDSW()->levelDefault() == 0)
            btnLevel1.SetState(RadioButton::Down);
         btnLevel2.SetText(pGame->levelDSW()->level(1).Description);
         if (pGame->levelDSW()->levelDefault() == 1)
            btnLevel2.SetState(RadioButton::Down);
         }
      if (pGame->levelDSW()->levelSize() > 2)
         {
         btnLevel3.SetText(pGame->levelDSW()->level(2).Description);
         if (pGame->levelDSW()->levelDefault() == 2)
            btnLevel3.SetState(RadioButton::Down);
         btnLevel4.SetText(pGame->levelDSW()->level(3).Description);
         if (pGame->levelDSW()->levelDefault() == 3)
            btnLevel4.SetState(RadioButton::Down);
         }
      }

   if (pGame->extraDSW() != (DipSwitch*)NULL)
      {
      if (pGame->extraDSW()->extraSize())
         {
         btnExtra1.SetText(pGame->extraDSW()->extra(0).Description);
         if (pGame->extraDSW()->extraDefault() == 0)
            btnExtra1.SetState(RadioButton::Down);
         btnExtra2.SetText(pGame->extraDSW()->extra(1).Description);
         if (pGame->extraDSW()->extraDefault() == 1)
            btnExtra2.SetState(RadioButton::Down);
         }
      if (pGame->extraDSW()->extraSize() > 2)
         {
         btnExtra3.SetText(pGame->extraDSW()->extra(2).Description);
         if (pGame->extraDSW()->extraDefault() == 2)
            btnExtra3.SetState(RadioButton::Down);
         btnExtra4.SetText(pGame->extraDSW()->extra(3).Description);
         if (pGame->extraDSW()->extraDefault() == 3)
            btnExtra4.SetState(RadioButton::Down);
         }
      }
}

void MainWindow::SelectOptions()
{
   if(pGame->menDSW() != (DipSwitch*)NULL && 
      pGame->menDSW()->menSize() && 
      btnMen1.GetState() == RadioButton::Down) 
      pGame->menDSW()->SelectMen(0);
   if(pGame->menDSW() != (DipSwitch*)NULL && 
      pGame->menDSW()->menSize() && 
      btnMen2.GetState() == RadioButton::Down) 
      pGame->menDSW()->SelectMen(1);
   if(pGame->menDSW() != (DipSwitch*)NULL && 
      pGame->menDSW()->menSize() > 2 && 
      btnMen3.GetState() == RadioButton::Down) 
      pGame->menDSW()->SelectMen(2);
   if(pGame->menDSW() != (DipSwitch*)NULL && 
      pGame->menDSW()->menSize() > 2 && 
      btnMen4.GetState() == RadioButton::Down) 
      pGame->menDSW()->SelectMen(3);

   if(pGame->bonusDSW() != (DipSwitch*)NULL && 
      pGame->bonusDSW()->bonusSize() && 
      btnBonus1.GetState() == RadioButton::Down) 
      pGame->bonusDSW()->SelectBonus(0);
   if(pGame->bonusDSW() != (DipSwitch*)NULL && 
      pGame->bonusDSW()->bonusSize() && 
      btnBonus2.GetState() == RadioButton::Down) 
      pGame->bonusDSW()->SelectBonus(1);
   if(pGame->bonusDSW() != (DipSwitch*)NULL && 
      pGame->bonusDSW()->bonusSize() > 2  && 
      btnBonus3.GetState() == RadioButton::Down) 
      pGame->bonusDSW()->SelectBonus(2);
   if(pGame->bonusDSW() != (DipSwitch*)NULL && 
      pGame->bonusDSW()->bonusSize() > 2&& 
      btnBonus4.GetState() == RadioButton::Down) 
      pGame->bonusDSW()->SelectBonus(3);

   if(pGame->coinsDSW() != (DipSwitch*)NULL && 
      pGame->coinsDSW()->coinsSize() && 
      btnCoins1.GetState() == RadioButton::Down) 
      pGame->coinsDSW()->SelectCoins(0);
   if(pGame->coinsDSW() != (DipSwitch*)NULL && 
      pGame->coinsDSW()->coinsSize() && 
      btnCoins2.GetState() == RadioButton::Down) 
      pGame->coinsDSW()->SelectCoins(1);
   if(pGame->coinsDSW() != (DipSwitch*)NULL && 
      pGame->coinsDSW()->coinsSize() > 2  && 
      btnCoins3.GetState() == RadioButton::Down) 
      pGame->coinsDSW()->SelectCoins(2);
   if(pGame->coinsDSW() != (DipSwitch*)NULL && 
      pGame->coinsDSW()->coinsSize() > 2  && 
      btnCoins4.GetState() == RadioButton::Down) 
      pGame->coinsDSW()->SelectCoins(3);

   if(pGame->levelDSW() != (DipSwitch*)NULL && 
      pGame->levelDSW()->levelSize() && 
      btnLevel1.GetState() == RadioButton::Down) 
      pGame->levelDSW()->SelectLevel(0);
   if(pGame->levelDSW() != (DipSwitch*)NULL && 
      pGame->levelDSW()->levelSize() && 
      btnLevel2.GetState() == RadioButton::Down) 
      pGame->levelDSW()->SelectLevel(1);
   if(pGame->levelDSW() != (DipSwitch*)NULL && 
      pGame->levelDSW()->levelSize() > 2 && 
      btnLevel3.GetState() == RadioButton::Down) 
      pGame->levelDSW()->SelectLevel(2);
   if(pGame->levelDSW() != (DipSwitch*)NULL && 
      pGame->levelDSW()->levelSize() > 2  && 
      btnLevel4.GetState() == RadioButton::Down) 
      pGame->levelDSW()->SelectLevel(3);

   if(pGame->extraDSW() != (DipSwitch*)NULL && 
      pGame->extraDSW()->extraSize() && 
      btnExtra1.GetState() == RadioButton::Down) 
      pGame->extraDSW()->SelectExtra(0);
   if(pGame->extraDSW() != (DipSwitch*)NULL && 
      pGame->extraDSW()->extraSize() && 
      btnExtra2.GetState() == RadioButton::Down) 
      pGame->extraDSW()->SelectExtra(1);
   if(pGame->extraDSW() != (DipSwitch*)NULL && 
      pGame->extraDSW()->extraSize() > 2  && 
      btnExtra3.GetState() == RadioButton::Down) 
      pGame->extraDSW()->SelectExtra(2);
   if(pGame->extraDSW() != (DipSwitch*)NULL && 
      pGame->extraDSW()->extraSize() > 2  && 
      btnExtra4.GetState() == RadioButton::Down) 
      pGame->extraDSW()->SelectExtra(3);

   if(btnNoSound.GetState() == RadioButton::Down) 
      pGame->SetSound(OFF);
   else
      pGame->SetSound(ON);
   if(btnJoy.GetState() == CheckBox::Down) 
      pGame->SetJoy(OFF);
   else
      pGame->SetJoy(ON);
   if(btnThrottle.GetState() == CheckBox::Down) 
      pGame->SetThrottle(ON);
   else
      pGame->SetThrottle(OFF);
}

int main(int argc, char **argv)
{
   core_select = (unsigned short)_dos_ds;
   pGame = (Game*)NULL;

   if (argc < 2)
      {
/*      // temp bypass of gui
      printf ("Note: the GUI ain't workin' yet...\n\n");
      printf ("Rockulator++ Options\n");
      printf ("type 'rockultr <game> -info' for game options\n\n");
      printf ("-nojoy     Disable Joystick\n");
      printf ("-nosound   Disable Sound\n");
      allegro_exit();
      exit(0);*/

      // setup
      mode = 1;
//      if (set_gfx_mode(GFX_VESA2L, 640, 480, 0, 0) < 0)
         {
         set_gfx_mode(GFX_MODEX, 400, 300, 0, 0);
         mode = 0;
         }
      text_mode(-1);
      install_keyboard();

      mouse = new Mouse((mode?640:400), (mode?480:300));
      desktop = new Desktop(100, 0, 0, (mode?640:400), (mode?480:300), 3);
      logoBmp = new Bitmap(180, 16);
      *logoBmp = logo;

      marquee = new Marquee(200, 0, (mode?462:282), (mode?640:400), 18);
      marquee->SetText(credits);

      mouse->SetWindow(desktop);
      desktop->Show();
      logoBmp->Draw((mode?230:110), 2);
      marquee->Show();
      mouse->Show();

      while(!mouse->B2())
         {
         marquee->Update();
         mouse->Update();
         }

      delete desktop;
      delete marquee;
      delete mouse;
      allegro_exit();
      return 0;
      }

   else if (!strcmp(strlwr(argv[1]), "vanguard"))
      pGame = (Game *) new Vanguard;
   else if (!strcmp(strlwr(argv[1]), "fantasy"))
      pGame = (Game *) new Fantasy;
   else if (!strcmp(strlwr(argv[1]), "nibbler"))
      pGame = (Game *) new Nibbler;
   else if (!strcmp(strlwr(argv[1]), "pepper2"))
      pGame = (Game *) new Pepper2;
   else if (!strcmp(strlwr(argv[1]), "venture"))
      pGame = (Game *) new Venture;
   else if (!strcmp(strlwr(argv[1]), "mtrap"))
      pGame = (Game *) new MTrap;
   else if (!strcmp(strlwr(argv[1]), "frogger"))
      pGame = (Game *) new Frogger;
   else if (!strcmp(strlwr(argv[1]), "mcresta"))
      pGame = (Game *) new MCresta;
   else if (!strcmp(strlwr(argv[1]), "mcrestab"))
      pGame = (Game *) new MCrestaBoot;
   else if (!strcmp(strlwr(argv[1]), "galaxian"))
      pGame = (Game *) new Galaxian;
   else if (!strcmp(strlwr(argv[1]), "supergal"))
      pGame = (Game *) new SuperGalaxian;
   else if (!strcmp(strlwr(argv[1]), "pisces"))
      pGame = (Game *) new Pisces;
   else if (!strcmp(strlwr(argv[1]), "scramble"))
      pGame = (Game *) new Scramble;
   else if (!strcmp(strlwr(argv[1]), "atlantis"))
      pGame = (Game *) new Atlantis;
   else if (!strcmp(strlwr(argv[1]), "theend"))
      pGame = (Game *) new TheEnd;
   else if (!strcmp(strlwr(argv[1]), "scobra"))
      pGame = (Game *) new SCobra;
   else if (!strcmp(strlwr(argv[1]), "qix"))
      pGame = (Game *) new Qix;
   else if (!strcmp(strlwr(argv[1]), "-info") ||
      !strcmp(strlwr(argv[1]), "-help"))
      {
      printf ("Rockulator++ Options\n");
      printf ("type 'rockultr <game> -info' for game options\n\n");
      printf ("-nojoy     Disable Joystick\n");
      printf ("-nosound   Disable Sound\n");
      allegro_exit();
      exit(0);
      }
   else
      pGame = (Game *) new Vanguard;


   for (int i=2; i<argc; i++)
      {
      if (!memcmp(strlwr(argv[i]), "-m", 2))
         {
         int x = argv[i][2] - '1';
         if (pGame->extraDSW() && x < pGame->menDSW()->menSize())
            pGame->menDSW()->SelectMen(x);
         }
      if (!memcmp(strlwr(argv[i]), "-b", 2))
         {
         int x = argv[i][2] - '1';
         if (pGame->bonusDSW() && x < pGame->bonusDSW()->bonusSize())
            pGame->bonusDSW()->SelectBonus(x);
         }
      if (!memcmp(strlwr(argv[i]), "-c", 2))
         {
         int x = argv[i][2] - '1';
         if (pGame->coinsDSW() && x < pGame->coinsDSW()->coinsSize())
            pGame->coinsDSW()->SelectCoins(x);
         }
      if (!memcmp(strlwr(argv[i]), "-l", 2))
         {
         int x = argv[i][2] - '1';
         if (pGame->levelDSW() && x < pGame->levelDSW()->levelSize())
            pGame->levelDSW()->SelectLevel(x);
         }
      if (!strcmp(strlwr(argv[i]), "-nojoy"))
         {
         pGame->SetJoy(OFF);
         }
      if (!strcmp(strlwr(argv[i]), "-nosound"))
         {
         pGame->SetSound(OFF);
         }
      if (!strcmp(strlwr(argv[i]), "-throttle"))
         {
         pGame->SetThrottle(ON);
         }
      if (!strcmp(strlwr(argv[i]), "-info"))
         {
         int j;
         printf ("Game Option Switches\n");
         if (pGame->bonusDSW() && pGame->bonusDSW()->bonusSize())
            {
            for (j=0; j<pGame->bonusDSW()->bonusSize(); j++)
               printf("-b%1d - %s\n", j+1, pGame->bonusDSW()->bonus(j).Description);
            printf ("\n");
            }
         if (pGame->coinsDSW() && pGame->coinsDSW()->coinsSize())
            {
            for (j=0; j<pGame->coinsDSW()->coinsSize(); j++)
               printf("-c%1d - %s\n", j+1, pGame->coinsDSW()->coins(j).Description);
            printf ("\n");
            }
         if (pGame->levelDSW() && pGame->levelDSW()->levelSize())
            {
            for (j=0; j<pGame->levelDSW()->levelSize(); j++)
               printf("-c%1d - %s\n", j+1, pGame->levelDSW()->level(j).Description);
            printf ("\n");
            }
         if (pGame->menDSW() && pGame->menDSW()->menSize())
            {
            for (j=0; j<pGame->menDSW()->menSize(); j++)
               printf("-m%1d - %s\n", j+1, pGame->menDSW()->men(j).Description);
            printf ("\n");
            }
         delete pGame;
         allegro_exit();
         exit(0);
         }
      }

   if (!pGame->errorCode())
      {
      pGame->Reset();
      pGame->Execute();
      }

//   int fc = pGame->Frames();
//   int vc = pGame->Vsyncs();
   delete pGame;
   allegro_exit();
//   printf ("frames: %d, vsyncs: %d\n", fc, vc);
   return 0;
}


