#include <stdio.h>
#include "venture.h"

BYTE ventureColors[] = 
{
   0x00, 0xC0, 0x38, 0xF8, 0x07, 0xC7, 0x3F, 0xFF,   
   0x00, 0xC0, 0x38, 0xF8, 0x07, 0xC7, 0x3F, 0xFF,   
   0x00, 0xC0, 0x38, 0xF8, 0x07, 0xC7, 0x3F, 0xFF,   
   0x00, 0xC0, 0x38, 0xF8, 0x07, 0xC7, 0x3F, 0xFF,   
   0x00, 0xC0, 0x38, 0xF8, 0x07, 0xC7, 0x3F, 0xFF   
};

ROMS ventureRoms[] = 
{
   { 0x8000,  "13a-cpu", 4096, "tables-code" },
   { 0x9000,  "12a-cpu", 4096, "code" },
   { 0xA000,  "11a-cpu", 4096, "code-charset" },
   { 0xB000,  "10a-cpu", 4096, "code" },
   { 0xC000,  "9a-cpu",  4096, "code" },
   { 0xD000,  "8a-cpu",  4096, "code-tables-graphics" },
   { 0xE000,  "7a-cpu",  4096, "graphics-tables" },
   { 0xF000,  "6a-cpu",  4096, "tables-graphics-vectors" },
   { 0x7000,  "11d-cpu", 2048, "graphics" },
   { 0, NULL, 0, NULL }	
};

ROMS ventureSoundRoms[] = 
{
   { 0x5800, "3a-ac",   2048, "code" },
   { 0x6000, "4a-ac",   2048, "code-tables" },
   { 0x6800, "5a-ac",   2048, "tables" },
   { 0x7000, "6a-ac",   2048, "tables" },
   { 0x7800, "7a-ac",   2048, "code" },
   { 0xF800, "7a-ac",   2048, "vectors" },
   { 0, NULL, 0, NULL }	
};

MemoryWrite VentureWrite[] = 
{
   { 0x4000, 0x43FF, VentureOut },
   { 0x4800, 0x4FFF, VentureOut },
   { 0xFFFF, 0xFFFF, NULL }
};

MemoryRead VentureRead[] = 
{
   { 0x0380, 0x0380, VentureReadScores },
	{ 0x5100, 0x5101, ExidyReadPlayer },
	{ 0x5103, 0x5103, VentureReadPlayer },
	{ 0x5200, 0x5203, ExidyReadPlayer },
	{ 0x5213, 0x5213, ExidyReadPlayer },
   { 0xFFFF, 0xFFFF, NULL }
};

MemoryWrite VentureSoundWrite[] = 
{
   { 0xFFFF, 0xFFFF, NULL }
};

MemoryRead VentureSoundRead[] = 
{
   { 0xFFFF, 0xFFFF, NULL }
};

Venture * pVenture;

Venture::Venture() : Exidy(ventureRoms, ventureSoundRoms, "venture")
{
   pVenture = this;
   pProc6502->SetMemoryRW(VentureWrite, VentureRead, 10000, pRAM, 1);
   pProc6502->SetMemoryRW(VentureSoundWrite, VentureSoundRead, 10000, pAudioRAM, 2);

   strcpy(Name, "venture");
   strcpy(Descript, "Venture");

   Dipswitch->SetMen(5, 0, "5 Bows", "4 Bows", "3 Bows", "2 Bows");
   Dipswitch->SetCoins(3, 1, "1 Coin 2 Plays", "1 Coin 1 Play", "2 Coins 1 Play",
      "Not Used");
}

Venture::~Venture()
{
}

void Venture::Reset()
{
   pDisplay = new Display(256, 256, 256, 256, 0, 0, 0, 0, scr256x256, 200);
   pColors = ventureColors;
   BuildText (0xA21E, 0xA2A6, 0xA20E, 0xA19E);

   Exidy::Reset();
}

void Venture::Audio()
{
}

void Venture::LoadScore()
{
}

void Venture::SaveScore()
{
   WriteScore(0x380, 0x23);
}

void Venture::DetectCollision()
{
   static BYTE LastCollide = 0;
   if (!(pRAM[0x5103]&0x80) && !pRAM[0x5101])
      {
      // check to see if any of the sprite is collided with a character object
      int x, y, z;
      x = (236-pRAM[0x5000])>>3;
      y = (244-pRAM[0x5040])>>3;
      z = pRAM[0x4000 + (y<<5) + x];

      // collisions with walls don't count (A0-B0)
      if (((z && z < 0xA0 && z != LastCollide) || 
         (z && z > 0xB0 && z != LastCollide))) 
         {
         if (z < 0xC0)
            LastCollide = z;
         pRAM[0x5103] = 0x94;
         Collision = 2;
         }
      }
   else
      pRAM[0x5103] &= 0xFB;
}

int VentureOut(WORD A,  BYTE B)
{
   if (A >= 0x4000 && A < 0x4400 && pGame->RAM()[A] != B)
      pExidy->Background()[A - 0x4000] = 1;
   else
      pExidy->Characters()[(A - 0x4800)>>3] = 1;

   pGame->RAM()[A] = B;
   return 0;
}

BYTE VentureReadScores(WORD A)
{
   pVenture->LoadScore();
   return pGame->RAM()[A];
}


BYTE VentureReadPlayer(WORD A)
{
   BYTE valP1 = 0;

   valP1 = pGame->RAM()[0x5103];
   if (pExidy->Collision)
      {
      valP1 = (pGame->RAM()[0x5103] &= 0x94) | pExidy->Player1->Get();
      pExidy->Collision--;
      }
   else
      valP1 = (pGame->RAM()[0x5103] &= 0x14) | pExidy->Player1->Get();

   return (WORD)valP1;
}









