#ifndef __AUDIODEV_H__
#define __AUDIODEV_H__

#include <audio.h>
#include "game.h"

extern BYTE SineWaveSample[];

class AudioDev
{
private:
protected:
   HAC *hVoice;
   LPAUDIOWAVE *lpWave;
   int Voices;
   int NextSample;
   int SampleRate;
   int SampleLength;
public:
   AudioDev(int voices, int waves, int rate=44100, int len=50000, int dev=0);
   virtual ~AudioDev();
   void PlaySample (int channel, BYTE *data, int len, int freq, int vol, int loop);
   void AdjustSample (int channel, int freq, int vol);
   int LoadWaveFile(char *fname)
      { ALoadWaveFile(fname, &(lpWave[NextSample]), 0L); return NextSample++; };
   void PrimeVoice(int voice) 
      { APrimeVoice(hVoice[voice], lpWave[voice]); };
   void SetVoiceVolume(int voice, int vol)
      { ASetVoiceVolume(hVoice[voice], vol); };
   void PlayVoice(int voice)
      { APlayVoice(hVoice[voice], lpWave[voice]); };
   void StartVoice(int voice)
      { AStartVoice(hVoice[voice]); };           
   void StopVoice(int voice)
      { AStopVoice(hVoice[voice]); };
   void Update() { AUpdateAudio(); };
   int Status() { return Voices; };
}; 

// helper function to ensure proper destruction
inline void deleteAudioDev(AudioDev**p)
{ 
   if (*p) { delete *p; *p = 0; }
}

#endif

