#ifndef __DISPLAY_H__
#define __DISPLAY_H__

#include <allegro.h>
#include "rockdefs.h"
#include "twkuser.h"

extern "C" 
{
void xblast(BITMAP *source, int width, int x);
void xblit(BITMAP *source, BITMAP *dest, int source_x, int source_y, 
	   int dest_x, int dest_y, int width, int height, int topline); 
}

extern unsigned char intensity4[];
extern unsigned char intensity8[];
extern Register scr256x256[];
extern Register scr224x256[];

class Display                                           
{
public:
   enum EDisplayMode { MODEQ=0, MODEX };
private:   
   BITMAP *pPicture;
   BITMAP *pBackground;
   BITMAP *pText;
   PALETTE pPalette;
   int DisplayWidth, DisplayHeight;    // display width and height
   int GameWidth, GameHeight;          // game width and height
   int GameXOffset, GameYOffset;       // game offsets
   int DisplayXOffset, DisplayYOffset; // offsets of game from display
   Register *Screen;
   int ActivePage;
protected:
   EDisplayMode DisplayMode;
public:
   Display(int dw, int dh, int gw, int gh, int gx, int gy, int dx, int dy, 
      Register *scr, int len);
   Display(int dw, int dh, int gw, int gh, int gx, int gy, int dx, int dy);
   ~Display();
   int displayWidth() { return DisplayWidth; };
   int displayHeight() { return DisplayHeight; };
   int gameWidth() { return GameWidth; };
   int gameHeight() { return GameHeight; };
   int gameXOffset() { return GameXOffset; };
   int gameYOffset() { return GameYOffset; };
   int displayXOffset() { return DisplayXOffset; };
   int displayYOffset() { return DisplayYOffset; };
   BITMAP * Picture() { return pPicture; };
   BITMAP * Background() { return pBackground; };
   BITMAP * Text() { return pText; };
   PALETTE & Palette() { return pPalette; };
   void Draw();
   void Blit(BITMAP *src, BITMAP *dest, int sx, int sy, int dx, int dy, int w, int h)
      { blit (src, dest, sx, sy, dx, dy, w, h); };
   BYTE GetPixel(int row, int col, BITMAP *pBmp)
      { 
      // the custom blit expects to find data packed by plane per line
      if (DisplayMode == MODEX)
         return pBmp->line[row][(col>>2)+((col%4)<<6)];
      return pBmp->line[row][col];
      };
   void SetPixel(int row, int col, BYTE data, BITMAP *pBmp)
      { 
      // the custom blit expects to find data packed by plane per line
      if (DisplayMode == MODEX)
         pBmp->line[row][(col>>2)+((col%4)<<6)] = data;
      else
         pBmp->line[row][col] = data;
      };
   void SetClip(int x1, int y1, int x2, int y2)
      { set_clip(pPicture, x1, y1, x2, y2); };
   void PrintHex(int num, int row, int col);
   void PrintNum(int num, int row, int col);
   void PrintStr(char *str, int row, int col);
};

// helper function to ensure proper destruction
inline void deleteDisplay(Display**p)
{ 
   if (*p) { delete *p; *p = 0; }
}


#endif

