#include <stdio.h>
#include <string.h>
#include "dkong.h"

DKong * pDKong;

BYTE dkongColors[0x400] = 
{
   0x00, 0xC0, 0x38, 0xF8, 0x07, 0xC7, 0x3F, 0xFF,   
   0x00, 0xC0, 0x38, 0xF8, 0x07, 0xC7, 0x3F, 0xFF,   
   0x00, 0xC0, 0x38, 0xF8, 0x07, 0xC7, 0x3F, 0xFF,   
   0x00, 0xC0, 0x38, 0xF8, 0x07, 0xC7, 0x3F, 0xFF,   
   0x00, 0xC0, 0x38, 0xF8, 0x07, 0xC7, 0x3F, 0xFF,   
};

ROMS dkongRoms[] = 
{
   { 0x0000,  "dk.5e", 4096, "code" },
   { 0x1000,  "dk.5c", 4096, "code" },
   { 0x2000,  "dk.5b", 4096, "code" },
   { 0x3000,  "dk.5a", 4096, "code" },
   { 0x8000,  "dk.3n", 2048, "graphics" },
   { 0x8800,  "dk.3p", 2048, "graphics" },
   { 0x9000,  "dk.7c", 2048, "graphics" },
   { 0x9800,  "dk.7d", 2048, "graphics" },
   { 0xA000,  "dk.7e", 2048, "graphics" },
   { 0xA800,  "dk.7f", 2048, "graphics" },
   { 0xB000,  "dk.3h", 2048, "data" },
   { 0xB800,  "dk.3f", 2048, "data" },
   { 0, NULL, 0, NULL }	
};

MemoryWrite DKongWrite[] = 
{
   { 0x7400, 0x77FF, DKongOut },
   { 0xFFFF, 0xFFFF, NULL }
};

MemoryRead DKongRead[] = 
{
   { 0x7C00, 0x7C00, DKongReadPlayer0 },
   { 0x7C80, 0x7C80, DKongReadPlayer1 },
   { 0x7D00, 0x7D00, DKongReadPlayer2 },
   { 0x7D80, 0x7D80, DKongReadDipSwitch },
   { 0xFFFF, 0xFFFF, NULL }
};

DKong::DKong() : Game (dkongRoms, 0x10000, "dkong")
{
   pDKong = this;
   pProcZ80 = new ProcZ80;
   pProcessor = (Processor *) pProcZ80;

   pProcZ80->SetMemoryRW(DKongWrite, DKongRead, pRWTable, DKongInProc,
      DKongOutProc, 30000, pRAM, 1);

   // input ports
   Player0 = new IOPort(0x7C00, 0x00);
   Player0->SetKey(0, 0, 0, KEY_CONTROL, KEY_DOWN, KEY_UP, KEY_LEFT, KEY_RIGHT);
   Player0->SetJoy(0, 0, 0, JOY_BUTTON1, JOY_DOWN, JOY_UP, JOY_LEFT, JOY_RIGHT);
   Player1 = new IOPort(0x7C80, 0x00);
   Player1->SetKey(0, 0, 0, KEY_CONTROL, KEY_DOWN, KEY_UP, KEY_LEFT, KEY_RIGHT);
   Player1->SetJoy(0, 0, 0, JOY_BUTTON1, JOY_DOWN, JOY_UP, JOY_LEFT, JOY_RIGHT);
   Player2 = new IOPort(0x7D00, 0x00);
   Player2->SetKey(KEY_3, 0, 0, 0, KEY_2, KEY_1, 0, 0);
   Dipswitch = new DipSwitch(0x7D80, 0x80);
   Dipswitch->SetMen(0, 0, "3 Lives", "4 Lives", "5 Lives", "6 Lives");
   Dipswitch->SetBonus(2, 0, "7000 Points", "10000 Points", "15000 Points", "20000 Points");
   Dipswitch->SetCoins(4, 0, "1 Coin 1 Play", "2 Coins 1 Play", "1 Coin 2 Plays", 
      "3 Coins 1 Play", "1 Coin 3 Plays", "4 Coins 1 Play", "1 Coins 4 Plays",
      "5 Coins 1 Play");

   pMenDSW = Dipswitch;
   pCoinsDSW = Dipswitch;
   pBonusDSW = Dipswitch;
   pDisplay = 0;
}

DKong::~DKong()
{
   deleteDisplay(&pDisplay);
   delete pProcZ80;   
}

void DKong::Reset()
{
   Game::Reset();

   pDisplay = new Display(256, 256, 256, 256, 0, 0, 0, 0, scr256x256, 200);
   pColors = dkongColors;
   BuildText(0x8000, 0x8058, 0x814E, 0x8050);
   memset(BackBuffer, 1, 0x400);
}

void DKong::Execute()
{
   int rtn = INT_IRQ;

   while (rtn != INT_QUIT)
      {
      pProcZ80->Exec();
      rtn = Interrupt();
      if (pRAM[0x7D84])
         pProcZ80->NMI();
      }

   deleteDisplay(&pDisplay);
}

int DKong::Interrupt()
{
   int rtn = INT_NMI;

   Video();
   if (bSound)
      Audio();

   if (Game::Interrupt() == INT_QUIT)
      rtn = INT_QUIT;

   pDisplay->Draw(); 

   return rtn;
}

void DKong::Video()
{
   unsigned char *start, *ptr;
   int soff, scur;
   unsigned char c;
   int i, j; 

   // display characters, accounting for rotation
   start = pRAM + 0x7400 + 31 * 32;
   soff = 31 * 32;
   for (i=0; i<32; i++)
      {
   	ptr = start;
   	scur = soff;
      for (j=0; j<32; j++)
         {
         c = *ptr;
         if (BackBuffer[scur])
            {
            DrawCharacter (c, j<<3, i<<3);
            BackBuffer[scur] = 0;
            }
         ptr -= 32;
         scur -= 32;
  	      }
  	   start++;
      soff++;
     	}

   blit (pDisplay->Background(), pDisplay->Picture(), 
      0, 0, 0, 0, 256, 256);

	for (i=0; i<384; i+=4)
   	{
	   if (pRAM[0x6900+i])
   		{
         DrawSprite(pRAM[0x6900+i+1]&0x7F, pRAM[0x6900+i]-7, pRAM[0x6900+i+3]-8,
            pRAM[0x6900+i+2]&0x7F);
	   	}
   	}
}

void DKong::Audio()                     
{
}

void DKong::Load()                     
{
   char file[80];
   FILE *fp;
   sprintf (file, "%s\\savegame", Path);
   fp = fopen (file, "rb");
   fread(pRAM+0x6000, 0x1800, 1, fp);
   pProcZ80->Load(fp);
   fclose(fp);
   memset(BackBuffer, 1, 0x400);
}

void DKong::Save()                     
{
   char file[80];
   FILE *fp;
   sprintf (file, "%s\\savegame", Path);
   fp = fopen (file, "wb");
   fwrite(pRAM+0x6000, 0x1800, 1, fp);
   pProcZ80->Save(fp);
   fclose(fp);
}

void DKong::LoadScore()
{
}

void DKong::SaveScore()
{
}

void DKong::DrawCharacter (int c, int col, int row)
{
	int x, y;
   int sr, sc;
   int sb1 = 0;
   int sb2 = 0;
   BYTE result = 0;
   BYTE res1, res2;
   BYTE mask;
   int ROM1 = 0x8000;
   int ROM2 = 0x8800;
   int hpos;
   int vpos;

   // get the offset to the correct bit for each bitplane
   sb1 = c * 64;

   // for each bit in character
	sc  = 7;
   for (y = 0; y < 8; y ++)
      {
      // get a BYTE at a time
	   sr = 0;
      res1 = pRAM[(sb1>>3)+ROM1];
      res2 = pRAM[(sb1>>3)+ROM2];

      //-- adjust horizontal scrolling
      hpos = sc+col;

      // for each bit in BYTE
      for (x=0; x<8; x++)
         {
         //-- adjust vertical scrolling
         vpos = sr+row;

         // find the color by adding the bitplane values
         mask = 0x80 >> x; 
         if ((res1 & mask) == mask) result = 1;
         if ((res2 & mask) == mask) result ^= 2;
         pDisplay->Background()->line[vpos][hpos] = pColors[result];
         sr++;
         sb1++;
         sb2++;
         result = 0;
         }

	   sc--;
      }
}
                         
void DKong::DrawSprite (int c, int col, int row, BYTE color)
{
	int x, y;
   int sr, sc;
   int sb1 = 0;
   int sb2 = 0;
   BYTE result = 0;
   BYTE res1, res2, res3, res4, res5, res6, res7, res8;
   BYTE mask;
   int ROM1 = 0x9000;
   int ROM2 = 0xA000;
   int hpos;
   int vpos;

   // get the offset to the correct bit for each bitplane
   sb1 = c * 128;

   // for each bit in character
	sc  = 7;
   for (y = 0; y < 8; y ++)
      {
      //-- adjust horizontal scrolling
      hpos = sc+col;

      // get a BYTE at a time
	   sr = 0;

	   res1 = pRAM[(sb1>>3)+ROM1+8];
      res2 = pRAM[(sb1>>3)+ROM2+8];
      res3 = pRAM[(sb1>>3)+ROM1];
      res4 = pRAM[(sb1>>3)+ROM2];
	   res5 = pRAM[(sb1>>3)+ROM1+0x800+8];
      res6 = pRAM[(sb1>>3)+ROM2+0x800+8];
      res7 = pRAM[(sb1>>3)+ROM1+0x800];
      res8 = pRAM[(sb1>>3)+ROM2+0x800];

      // for each bit in BYTE
      for (x=0; x<8; x++)
         {
         //-- adjust vertical scrolling
         vpos = sr+row;

         // find the color by adding the bitplane values
         mask = 0x80 >> x; 
         result = 0;
         if ((res1 & mask) == mask) result = 1;
         if ((res2 & mask) == mask) result ^= 2;
         if (result)
            pDisplay->Picture()->line[vpos][hpos] = pColors[(color<<2)+result];
         result = 0;
         if ((res3 & mask) == mask) result = 1;
         if ((res4 & mask) == mask) result ^= 2;
         if (result)
            pDisplay->Picture()->line[vpos][hpos+8] = pColors[(color<<2)+result];
         result = 0;
         if ((res5 & mask) == mask) result = 1;
         if ((res6 & mask) == mask) result ^= 2;
         if (result)
            pDisplay->Picture()->line[vpos+8][hpos] = pColors[(color<<2)+result];
         result = 0;
         if ((res7 & mask) == mask) result = 1;
         if ((res8 & mask) == mask) result ^= 2;
         if (result)
            pDisplay->Picture()->line[vpos+8][hpos+8] = pColors[(color<<2)+result];
         sr++;
         sb1++;
         sb2++;
         }

	   sc--;
      }
}
                         
BYTE DKongReadPlayer0(WORD A)
{
   return pDKong->Player0->Get();
}

BYTE DKongReadPlayer1(WORD A)
{
   return pDKong->Player1->Get();
}

BYTE DKongReadPlayer2(WORD A)
{
   return pDKong->Player2->Get();
}

BYTE DKongReadDipSwitch(WORD A)
{
   return pDKong->Dipswitch->Get();
}

int DKongOut(WORD A,  BYTE B)
{
   if (pGame->RAM()[A] != B)
      pDKong->Background()[A-0x7400] = 1;
   pGame->RAM()[A] = B;
   return 0;
}

BYTE DKongInProc(WORD port)
{
   return 0;
}

void DKongOutProc(BYTE data, BYTE port)
{
}
  

