#ifndef __DKONG_H__
#define __DKONG_H__

#include "game.h"
#include "procz80.h"

BYTE DKongReadPlayer0(WORD A);
BYTE DKongReadPlayer1(WORD A);
BYTE DKongReadPlayer2(WORD A);
BYTE DKongReadDipSwitch(WORD A);
int DKongOut(WORD A,  BYTE B);

BYTE DKongInProc(WORD port);
void DKongOutProc(BYTE data, BYTE port);

class DKong : public Game
{
private:
   BYTE BackBuffer[0x400];
   BYTE CharBuffer[0x100];
protected:
   ProcZ80 * pProcZ80;
   void * pRWTable[0x20000];
   virtual void Video();
   virtual void Audio();
   virtual void DrawCharacter (int c, int col, int row);
   virtual void DrawSprite (int c, int col, int row, BYTE color);
public:
   DKong();
   virtual ~DKong();
   virtual void Reset();
   virtual void Execute();
   virtual int  Interrupt();
   virtual void Load();
   virtual void Save();
   virtual void LoadScore();
   virtual void SaveScore();
   BYTE * Background() { return BackBuffer; };
   BYTE * Characters() { return CharBuffer; };
   IOPort *Player0, *Player1, *Player2;
   DipSwitch * Dipswitch;
};

extern DKong * pDKong;

#endif


