#include <stdio.h>
#include <string.>
#include <conio.h>
#include "twkuser.h"
#include "exidy.h"

Exidy * pExidy;

Exidy::Exidy(ROMS *pR, ROMS *pSR, char *path) : Game (pR, 0x10000, path)
{
   pExidy = this;
   pProc6502 = new Proc6502(2);
   pProcessor = (Processor *) pProc6502;

   // setup sound hardware
   LoadAudio(pSR, 0x10000);

   Player0 = new IOPort (0x5101, 0xFF);
   Player0->SetKey(KEY_3, KEY_DOWN, KEY_UP, KEY_CONTROL, KEY_LEFT, KEY_RIGHT, KEY_2, KEY_1);
   Player0->SetJoy(0, JOY_DOWN, JOY_UP, JOY_BUTTON1, JOY_LEFT, JOY_RIGHT, 0, 0);
   Player1 = new IOPort (0x5103, 0x00);
   Player1->SetKey(0, KEY_3, KEY_4, 0, 0, 0, 0, 0);
   Player2 = new IOPort (0x5213, 0xFF);
   Player2->SetKey(0, 0, 0, 0, KEY_C, 0, KEY_X, KEY_Z);
   Dipswitch = new DipSwitch (0x5100, 0xFE);
   Dipswitch->SetKey(0, KEY_4);
   pMenDSW = Dipswitch;
   pCoinsDSW = Dipswitch;
   Collision = 0;

   pDisplay = 0;
}

Exidy::~Exidy()
{
   delete Dipswitch;
   delete Player0;
   delete Player1;
   delete Player2;
   deleteDisplay(&pDisplay);
   delete pProc6502;   
}

void Exidy::Reset()
{
   Game::Reset();
   pProc6502->Reset(1);
   pProc6502->Reset(2);
   memset(BackBuffer, 1, 0x400);
}

void Exidy::Execute()
{
   int rtn = INT_IRQ;

   // Exidy games start with an NMI
   pProc6502->Exec(1);
   Interrupt();
   pProc6502->NMI();

   while (rtn != INT_QUIT)
      {
      pProc6502->Exec(1);
      rtn = Interrupt();
      if (rtn == INT_NMI)
         //-- force a non-masked interrupt
         pProc6502->NMI();
      else if (rtn == INT_IRQ)
         //-- force a masked interrupt
         pProc6502->IRQ();

      if (Sound() && rtn != INT_QUIT)
         {
         pProc6502->Exec(2);
         rtn = INT_IRQ;
         }                 
      }

   deleteDisplay(&pDisplay);
}

int Exidy::Interrupt()
{
   int rtn = INT_IRQ;

   Video();

   if (Game::Interrupt() == INT_QUIT)
      rtn = INT_QUIT;
   
   pDisplay->Draw(); 

   return rtn;
}

void Exidy::Video()
{
   BYTE *start;
   BYTE c;
   int i, j; 
   static BYTE PaletteFlag = 0;

   DetectCollision();
   if (PaletteFlag != (pRAM[0x5101]&0x20))
      {
      memset(BackBuffer, 1, 0x400);
      PaletteFlag = (pRAM[0x5101]&0x20);
      }

   // display characters, accounting for rotation
   start = pRAM + 0x4000;
   for (i=0; i<32; i++)
      {
      for (j=0; j<32; j++)
         {
         c = *(start+i*32+j);
         if (BackBuffer[i*32+j] || CharBuffer[c])
            {
            DrawCharacter (c, j<<3, i<<3);
            BackBuffer[i*32+j] = 0;
            }
  	      }
     	}

   memset(CharBuffer, 0, 256);
   blit(pDisplay->Background(), pDisplay->Picture(), 0,0, 0,0, 
      pDisplay->gameWidth(), pDisplay->gameHeight());

   if (!(pRAM[0x5101]&0x80) || pRAM[0x5101]&0x10)
      {
      j = 236-pRAM[0x5000]-4;
      i = 244-pRAM[0x5040]-4;
      if (PaletteFlag)
         DrawSprite((pRAM[0x5100]&0x0F) + 16, j, i, pColors[32+6]);
      else
         DrawSprite((pRAM[0x5100]&0x0F), j, i, pColors[32+5]);
      }
   if (!(pRAM[0x5101]&0x40))
      {
      j = 236-pRAM[0x5080]-4;
      i = 244-pRAM[0x50C0]-4;
      DrawSprite(((pRAM[0x5100]>>4)&0x0F)+32, j, i, pColors[32+7]);
      }
}

void Exidy::Audio()                     
{
}

void Exidy::Load()
{
   char file[80];
   FILE *fp;
   sprintf (file, "%s\\%s.sav", Path, Name);
   fp = fopen (file, "rb");
   if (fp)
      {
      fread(pRAM, 0x0400, 1, fp);
      fread(pRAM+0x4000, 0x1000, 1, fp);
      fread(pRAM+0x6000, 0x1000, 1, fp);
      fread(pAudioRAM, 0x0400, 1, fp);
      pProc6502->Load(fp);
      fclose(fp);
      memset(BackBuffer, 1, 0x400);
      }
}

void Exidy::Save()
{
   char file[80];
   FILE *fp;
   sprintf (file, "%s\\%s.sav", Path, Name);
   fp = fopen (file, "wb");
   if (fp)
      {
      fwrite(pRAM, 0x0400, 1, fp);
      fwrite(pRAM+0x4000, 0x1000, 1, fp);
      fwrite(pRAM+0x6000, 0x1000, 1, fp);
      fwrite(pAudioRAM, 0x0400, 1, fp);
      pProc6502->Save(fp);
      fclose(fp);
      }
}

//-- draw rotated character at specified position
void Exidy::DrawCharacter (int c, int col, int row)
{
	int x, y;
   BYTE result;      
   BYTE b1;
   BYTE mask;
   BYTE * ROM1 = pRAM + 0x4800 + 8 * c;

   for (y=0; y<8; y++)
      {
      b1 = *ROM1++;
      for (x=0; x<8; x++)
         {
         mask = 0x80 >> x; 
         result = (b1 & mask) == mask ? pColors[(c>>6)+1] : pColors[0];
         pDisplay->Background()->line[row+y][col+x] = result; 
         }
      }
}

//-- draw rotated sprite at specified position
void Exidy::DrawSprite (int c, int col, int row, BYTE color)
{
	int x, y;
   BYTE res1, res2;
   BYTE b1, b2;
   int ROM1, ROM2;
   BYTE mask;

   ROM1 = 0x7000 + (32 * c);
   ROM2 = ROM1 + 16;

   if (row < 0 || row > 240 || col < 0 || col > 240) return;

   for (y=0; y<16; y++)
      {
      b1 = pRAM[ROM1++];
      b2 = pRAM[ROM2++];
      for (x=0; x<8; x++)
         {
         res1 = res2 = 0;
         mask = 0x80 >> x; 
         if ((b1 & mask) == mask) res1 = 1;
         if (res1)
            pDisplay->Picture()->line[row+y][col+x] = color; 

         if ((b2 & mask) == mask) res2 = 1;
         if (res2)
            pDisplay->Picture()->line[row+y][col+x+8] = color; 
         }
      }
}

void Exidy::DetectCollision()
{
   pGame->RAM()[0x5103] &= 0xFB;
}

// capture and prerotate all the background characters to a bitmap
void Exidy::GetTextChar(WORD sAdd, WORD dOff)
{
   int x,y;
   int sr, sc;
   BYTE mask;
   BYTE result;
   BYTE res1;

   sr = 0;
   for (y = 0; y < 8; y ++)
      {
      sc = 0;
      res1 = pRAM[sAdd++];
      for (x = 0; x < 8; x ++)
         {
         mask = 0x80 >> x; 
         result = (res1 & mask) == mask ? 0xFF : 0x00;
         pDisplay->Text()->line[sr][sc+dOff] = result;
         sc++;
         }
      sr++;
      }
}

BYTE ExidyReadPlayer(WORD A)
{
   BYTE valP1 = 0;

   if (A == 0x5101)
      valP1 = pExidy->Player0->Get();

   else if (A == 0x5103)
      valP1 = (pGame->RAM()[0x5103] &= 0x14) | pExidy->Player1->Get();

   else if (A == 0x5100)
      valP1 = pExidy->Dipswitch->Get();

   else if (A == 0x5213)
      valP1 = pExidy->Player2->Get();

   return (WORD)valP1;
}

