#include <stdio.h>
#include "fantasy.h"

int swapsound[8] = { 0, 2, 3, 6, 1, 4, 5, 7 };

BYTE fantasyColors[] = 
{
   0x00, 0x06, 0x27, 0x05, 0x7F, 0x2F, 0x38, 0x05, 
   0x00, 0x38, 0x05, 0x28, 0x00, 0x07, 0xFF, 0xF4, 
   0x00, 0x07, 0x38, 0x2F, 0x00, 0xF8, 0xFF, 0xC5, 
   0x00, 0xC0, 0x38, 0xF4, 0x00, 0x27, 0xFF, 0x2F, 
   0x00, 0x07, 0x38, 0xF8, 0x00, 0x05, 0x2F, 0xF8, 
   0x00, 0xC0, 0x2F, 0xF8, 0x00, 0xF8, 0x07, 0xFF, 
   0x00, 0x07, 0xF4, 0xC0, 0x00, 0x38, 0xC5, 0x07, 
   0x00, 0xFF, 0x2F, 0x3F, 0x00, 0xC5, 0xC5, 0xC0
};

ROMS fantasyRoms[] = 
{
   { 0x3000, "ic12.cpu",	4096, "code" },
   { 0x4000, "ic07.cpu", 	4096, "code" },
   { 0x5000, "ic08.cpu", 	4096, "code" },
   { 0x6000, "ic09.cpu", 	4096, "code" },
   { 0x7000, "ic10.cpu",  	4096, "code / graphics" },
   { 0x8000, "ic14.cpu",  	4096, "graphics" },
   { 0x9000, "ic15.cpu",  	4096, "data" },
   { 0xA000, "ic16.cpu",  	4096, "code - graphics" },
   { 0xB000, "ic17.cpu",  	4096, "graphics - code" },
   { 0xC000, "ic50.vid",   4096, "graphics" },
   { 0xD000, "ic51.vid",   4096, "graphics" },
   { 0xF000, "ic14.cpu",  	4096, "vectors" },
   { 0xE000, "ic52.cpu",   2048, "sound" },
   { 0xE800, "ic51.cpu",   2048, "sound" },
   { 0xF000, "ic53.cpu",   2048, "sound" },
   { 0, NULL, 0, NULL }	
};

MemoryWrite FantasyWrite[] = 
{
   { 0x2100, 0x2103, FantasyOut }, 
   { 0x2400, 0x2400, RockOlaSpeechOut }, 
   { 0xFFFF, 0xFFFF, NULL }
};

MemoryRead FantasyRead[] = 
{
   { 0x2104, 0x2107, RockOlaReadPlayer },
   { 0x0220, 0x0220, FantasyReadScores },
   { 0xFFFF, 0xFFFF, NULL }
};

Fantasy * pFantasy;

Fantasy::Fantasy() : RockOla(fantasyRoms, "fantasy")
{
   pFantasy = this;
   pProc6502->SetMemoryRW(FantasyWrite, FantasyRead, 12000, pRAM);
   Dipswitch->SetMen(4, 0, "3 Men", "4 Men", "5 Men", "Not Used");

   strcpy(Name, "fantasy");
   strcpy(Descript, "Fantasy");

   Sound[0] = SoundBase[0] = oSoundBase[0] = 0xE000;
   Sound[1] = SoundBase[1] = oSoundBase[1] = 0xE800;
   Sound[2] = SoundBase[2] = oSoundBase[2] = 0xF000;
   VScroll = 0x2200;
   HScroll = 0x2300;
}

Fantasy::~Fantasy()
{
}

void Fantasy::Reset()
{
   // setup display
   pDisplay = new Display(224, 256, 224, 256, 32, 0, 0, 0, scr224x256, 200);
   pColors = fantasyColors;
   BuildText (0x8000, 0x8050, 0x8130, 0x8180);

   RockOla::Reset();
}

void Fantasy::LoadScore()
{
   if (!ScoreLoaded && memcmp (pRAM + 0x22B, "\x00\x20\x00", 3) == 0 &&
      memcmp (pRAM + 0x25, "\x00\x20\x00", 3) == 0)
      {
      ReadScore(0x220, 0x70);
      ScoreLoaded = 1;
      }
}

void Fantasy::SaveScore()
{
   WriteScore(0x220, 0x70);
}

//-- fantasy has 2 sets of bckground characters, selected by bit 3 at 0x4D
void Fantasy::DrawCharacter(int c, int col, int row, BYTE color)
{
   ROM1 = (pRAM[0x4D]&0x08 ? 0xC000 : 0xC800);
   ROM2 = (pRAM[0x4D]&0x08 ? 0xD000 : 0xD800);
   RockOla::DrawCharacter(c, col, row, color);
}

int FantasyOut(WORD A, BYTE B)
{
   switch (A & 0x03)
      {
      // port 0
      case 0:
         if (pGame->Sound())                                                
            {
            pFantasy->SoundBase[0] = ((B & 0x07) << 8) + 0xE000;
            pFantasy->CheckSoundReset(0);
            pFantasy->CheckWave(B, 0x20, 0, pFantasy->Fire1Wave, 64, TRUE);
            pFantasy->CheckWave(B, 0x40, 0, pFantasy->Fire2Wave, 64, TRUE);
            pFantasy->CheckWave(B, 0x80, 0, pFantasy->ExplosionWave, 64, FALSE);
      
            if (B & 0x08)
               pFantasy->NoSound[0] = FALSE;
            else
               {
               pFantasy->NoSound[0] = TRUE;
               pFantasy->Sound[0] = pFantasy->SoundBase[0];
               }

            if (B & 0x10)
               pFantasy->NoSound[2] = FALSE;
            else
               {
               pFantasy->NoSound[2] = TRUE;
               pFantasy->Sound[2] = pFantasy->SoundBase[2];
               }
            }

         pFantasy->LastPort[0] = B;
         break;

      // port 1
      case 1:
         if (pGame->Sound())                                                
            {
            pFantasy->SoundBase[1] = ((B & 0x07) << 8) + 0xE800;
            pFantasy->CheckSoundReset(1);
            
            if (B & 0x08)
               pFantasy->NoSound[1] = FALSE;
            else
               pFantasy->NoSound[1] = TRUE;
            }

         pFantasy->LastPort[1] = B;
         break;

      // port 2
      case 2:
         pFantasy->LastPort[2] = B;
         break;

      // port 3
      case 3:
         if (pGame->Sound())                                                
            {
            pFantasy->SoundBase[2] = (swapsound[(B & 0x70) >> 4] << 8) + 0xF000;
            pFantasy->CheckSoundReset(2);
            }

         pFantasy->LastPort[3] = 0;
         break;
      }

   pGame->RAM()[A] = B;
   return 0;
}

BYTE FantasyReadScores(WORD A)
{
   pFantasy->LoadScore();
   return pGame->RAM()[A];
}


