#ifndef __GALAX_H__
#define __GALAX_H__

#include "game.h"
#include "procz80.h"
#include "audiodev.h"

BYTE GalaxReadPlayer0(WORD A);
BYTE GalaxReadPlayer1(WORD A);
BYTE GalaxReadDipSwitch(WORD A);
BYTE GalaxReadScores(WORD A);
int GalaxOut(WORD A,  BYTE B);
int GalaxStarsEnable(WORD A,  BYTE B);
int GalaxInterruptEnable(WORD A,  BYTE B);
int GalaxSound(WORD A, BYTE B);
int GalaxExplode(WORD A, BYTE B);
int GalaxShoot(WORD A, BYTE B);
void GalaxAudioHandler(...);

BYTE GalaxInProc(WORD port);
void GalaxOutProc(BYTE data, BYTE port);

const int MAX_STARS = 250;

class Galax : public Game
{
private:
protected:
   int ROMSet;                   // used by Moon Cresta          
   int ROMSet2;                  // used by Pisces
   int bStars;
   int StarCount;
   int StarScroll;
   BYTE StarX[MAX_STARS];
   BYTE StarY[MAX_STARS];
   BYTE StarColor[MAX_STARS];
   WORD InterruptEnable;
   WORD VideoAddress;
   WORD AttributeAddress;
   WORD BulletAddress;
   WORD SpriteAddress;
   WORD AttributesAddress;
   WORD MemBase, MemSize;
   WORD ROM1, ROM2;
   int ExplosionWave, FireWave;
   BYTE BackBuffer[0x400];
   BYTE CharBuffer[0x100];
   ProcZ80 * pProcZ80;
   void * pRWTable[0x20000];
   AudioDev * pAudioDev;
   Timer aTimer;
   int SoundBase;
   virtual void Video();
   virtual void Audio();
   virtual void DrawCharacter(int c, int col, int row, BYTE color);
   virtual void DrawSprite (WORD off);
   virtual void SetupStars(void);
public:
   Galax(ROMS * roms, char *dir);
   virtual ~Galax();
   virtual void Reset();
   virtual void Execute();
   virtual int  Interrupt();
   virtual void Load();
   virtual void Save();
   virtual void LoadScore();
   virtual void SaveScore();
   BYTE * Background() { return BackBuffer; };
   BYTE * Characters() { return CharBuffer; };
   IOPort * Player0;
   DipSwitch * Player1;
   DipSwitch * Dipswitch;
   friend BYTE GalaxReadMem(WORD A);
   friend BYTE GalaxReadPlayer0(WORD A);
   friend BYTE GalaxReadPlayer1(WORD A);
   friend BYTE GalaxReadDipSwitch(WORD A);
   friend BYTE GalaxReadScores(WORD A);
   friend int GalaxOut(WORD A,  BYTE B);
   friend int GalaxStarsEnable(WORD A,  BYTE B);
   friend int GalaxSound(WORD A, BYTE B);
   friend int GalaxShoot(WORD A, BYTE B);
   friend int GalaxExplode(WORD A, BYTE B);
   friend void GalaxAudioHandler(...);
};

extern Galax * pGalax;

#endif

