#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <memory.h>
#include <conio.h>
#include <allegro.h>  
#include <audio.h>
#include <dos.h>
#include <go32.h>
#include <time.h>
#include <sys\movedata.h>
#include "audiodev.h"
#include "display.h"
#include "proc.h"
#include "game.h"

#define vsync ((inportb(0x3DA) & 8)?1:0)

Game * pGame;

Game::Game(ROMS *pRom, int ramSize, char *path)
{
   Debug = 0;
   ErrorCode = ERR_NONE;
   bSound = 1;
   bJoystick = 1;
   bThrottle = 0;
   RAMSize = ramSize;
   pROMs = pRom;
   strcpy (Path, path);
   pRAM = new BYTE[RAMSize];
   memset(pRAM, 0, RAMSize);
   pRAMSave = new BYTE[RAMSize];
   pAudioRAM = (BYTE *)NULL;
   ErrorCode = LoadRoms(pROMs, pRAM);
   memcpy(pRAMSave, pRAM, RAMSize);

   pJoystick = new Joystick;

   Name[0] = NULL;
   Descript[0] = NULL;
   pMenDSW = (DipSwitch*)NULL;
   pCoinsDSW = (DipSwitch*)NULL;
   pBonusDSW = (DipSwitch*)NULL;
   pLevelDSW = (DipSwitch*)NULL;
   pExtraDSW = (DipSwitch*)NULL;

   //debugging
   if (Debug)
      {
      pReadBuffer = new WORD[0x10000];
      pWriteBuffer = new WORD[0x10000];
      for (int i=0; i<0x10000; i++)
         {
         pReadBuffer[i] = 0;
         pWriteBuffer[i] = 0;
         } 
      }
}

Game::~Game()
{
   // debugging
   if (Debug)
      {
      FILE *fp = fopen ("read.txt", "w");
      for (int i=0; i<0x4000; i++)
         fprintf (fp, "%04X: %5u   %04X: %5u   %04X: %5u   %04X: %5u\n",
            i, pReadBuffer[i],
            i+0x4000, pReadBuffer[i+0x4000],
            i+0x8000, pReadBuffer[i+0x8000],
            i+0xC000, pReadBuffer[i+0xC000]);
      fclose (fp);
      fp = fopen ("write.txt", "w");
      for (int i=0; i<0x4000; i++)
         fprintf (fp, "%04X: %5u   %04X: %5u   %04X: %5u   %04X: %5u\n",
            i, pWriteBuffer[i],
            i+0x4000, pWriteBuffer[i+0x4000],
            i+0x8000, pWriteBuffer[i+0x8000],
            i+0xC000, pWriteBuffer[i+0xC000]);
      fclose (fp);
      delete []pReadBuffer;
      delete []pWriteBuffer; 
      }

   delete []pRAM;
   delete []pRAMSave;
   if (pAudioRAM)
      {
      delete []pAudioRAM;
      delete []pAudioRAMSave;
      }
   if (pJoystick) delete pJoystick;
}

void Game::Reset()
{
   memcpy(pRAM, pRAMSave, RAMSize);
   if (pAudioRAM) memcpy(pAudioRAM, pAudioRAMSave, AudioRAMSize);
   ScoreLoaded = 0;
   bPause = 0;

   while(!vsync) {};
   VsyncCount = 0;
   VsyncFlag = 1;
   FrameCount = 0;
}

int Game::Interrupt()
{
   int rtn = INT_NONE;

   // check for speed throttling
   FrameCount++;
   if(bThrottle)
      {
      while(!vsync)
         { 
         }
      VsyncCount++;
      }

   if (pJoystick) pJoystick->ReadJoystick();
   if (aKeyboard[KEY_ESC])
      rtn = INT_QUIT;
   else if (aKeyboard[KEY_P])
      {
      bPause = 1;
      pDisplay->PrintStr("GAME PAUSED", 0x80, 0x50);
      pDisplay->Draw();
      aKeyboard.Clear();
      aKeyboard.ReadKey();
      aKeyboard.Clear();
      bPause = 0;
      }
   else if (aKeyboard[KEY_F3])
      Load();
   else if (aKeyboard[KEY_F4])
      Save();
   
   return rtn;
}

void Game::ReadScore(int table, int length, int flag)
{
   char file[80];
   FILE *fp;
   sprintf (file, "%s\\%s.sco", Path, Name);
   fp = fopen (file, "rb");
   if (fp == NULL)
      return;
   fread ((flag?pAudioRAM:pRAM) + table, length, 1, fp);
   fclose (fp);
}

void Game::WriteScore(int table, int length, int flag)
{
   char file[80];
   FILE *fp;
   sprintf (file, "%s\\%s.sco", Path, Name);
   fp = fopen (file, "wb");
   fwrite ((flag?pAudioRAM:pRAM) + table, length, 1, fp);
   fclose (fp);
}

Game::GameError Game::LoadRoms(ROMS *roms, BYTE *ram) 
{
   FILE * fp;
   char file[80];
   int i = 0;

   while (roms[i].fileName)
      {
      sprintf (file, "%s\\%s", Path, roms[i].fileName);
      if ((fp = fopen(file, "rb")) == NULL)
         {
//         printf ("%s, %s\n", Path, roms[i].fileName);
         return ERR_NO_ROM;
         }
	int sz;
      if ((sz = fread(ram + roms[i].loadAddr, 1, roms[i].romSize, fp) != (unsigned int)roms[i].romSize))
         {
//         printf ("%s, %s, %X, %X, %X\n", Path, roms[i].fileName, 
//      		roms[i].loadAddr, roms[i].romSize,sz);
         fclose(fp);
         return ERR_NO_ROM;
         }
      fclose(fp);
      i++;
      }

   return ERR_NONE;
}

Game::GameError Game::LoadRom(int address, char * name, size_t size, BYTE *ram) 
{                                     
   FILE * fp;
   char file[80];
   sprintf (file, "%s\\%s", Path, name);
   
   if ((fp = fopen(file, "rb")) == NULL)
      {
      return ERR_NO_ROM;
      }

   size_t rsize;
   rsize = fread(ram + address, 1, size, fp);
   if (rsize != size)
      {
      fclose(fp);
      return ERR_NO_ROM;
      }

   fclose(fp);

   return ERR_NONE;
}

void Game::LoadAudio(ROMS *pROM, int ramSize)
{
   AudioRAMSize = ramSize;
   pAudioROMs = pROM;
   pAudioRAM = new BYTE[ramSize];
   memset(pAudioRAM, 0, RAMSize);
   pAudioRAMSave = new BYTE[AudioRAMSize];
   ErrorCode = LoadRoms(pAudioROMs, pAudioRAM);
   memcpy(pAudioRAMSave, pAudioRAM, AudioRAMSize);
}

void Game::BuildText(WORD numbers, WORD characters, WORD period, WORD space)
{
   int i;
   for (i=0; i<10; i++)
      GetTextChar(numbers+i*8, i*8);
   for (i=0; i<26; i++)
      GetTextChar(characters+i*8, (i+10)*8);
   GetTextChar(period, 36*8);
   GetTextChar(space, 37*8);
}

// capture and prerotate all the background characters to a bitmap
void Game::GetTextChar(WORD sAdd, WORD dOff)
{
   int x,y;
   int sr, sc;
   BYTE mask;
   BYTE result;
   BYTE res1;

   sc = 7;
   for (y = 0; y < 8; y ++)
      {
      sr = 0;
      res1 = pRAM[sAdd++];
      for (x = 0; x < 8; x ++)
         {
         mask = 0x80 >> x; 
         result = (res1 & mask) == mask ? 0xFF : 0x00;
         pDisplay->Text()->line[sr][sc+dOff] = result;
         sr++;
         }
      sc--;
      }
}

void Game::GetVsync()
{
   if(vsync)
      {
      if(!VsyncFlag)
         {
         VsyncFlag = 1;
         VsyncCount++;
         }
      }
   else
      {
      if(VsyncFlag)
         VsyncFlag = 0;
      }
}



