#include <dos.h>
#include <allegro.h>
#include "gui.h"

char radio[] = {
   0, 0, 8, 8, 8, 7, 0, 0,
   0, 8, 7, 7, 7, 7,15, 0,
   8, 7, 7, 7, 7, 7, 7,15,
   8, 7, 7, 7, 7, 7, 7,15,
   8, 7, 7, 7, 7, 7, 7,15,
   8, 7, 7, 7, 7, 7, 7,15,
   0, 8, 7, 7, 7, 7,15, 0,
   0, 0, 7,15,15,15, 0, 0,
};

char radio2[] = {
   0, 0, 8, 8, 8, 7, 0, 0,
   0, 8, 7, 7, 7, 7,15, 0,
   8, 7, 7, 1, 1, 7, 7,15,
   8, 7, 1, 1, 1, 1, 7,15,
   8, 7, 1, 1, 1, 1, 7,15,
   8, 7, 7, 1, 1, 7, 7,15,
   0, 8, 7, 7, 7, 7,15, 0,
   0, 0, 7,15,15,15, 0, 0,
};

char arrow[] = {
  15,15,15,15,15,15,15, 7, 0, 0, 0, 0,
  15, 7, 7, 7, 7, 7, 8, 0, 0, 0, 0, 0,
  15, 7, 7, 7, 7, 8, 0, 0, 0, 0, 0, 0,
  15, 7, 7, 7, 7, 7, 8, 0, 0, 0, 0, 0,
  15, 7, 7, 7, 7, 7, 7, 8, 0, 0, 0, 0,
  15, 7, 7, 7, 7, 7, 7, 7, 8, 0, 0, 0,
  15, 8, 0,15, 7, 7, 7, 7, 7, 8, 0, 0,
   7, 0, 0, 0,15, 7, 7, 7, 7, 7, 8, 0,
   0, 0, 0, 0, 0,15, 7, 7, 7, 8, 0, 0,
   0, 0, 0, 0, 0, 0,15, 7, 8, 0, 0, 0,
   0, 0, 0, 0, 0, 0, 0, 7, 0, 0, 0, 0,
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
};

char vanguard[] = {
  10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
   0,10,10,12, 0, 0, 0, 0, 0, 0, 0, 0, 
   0,10,13,10,12,12, 0, 0, 0, 0, 0, 0, 
   0,12,10,13,13,12,12,12, 0,10, 0, 0, 
   0, 0,12,13,13,13,13,12,12,12,12, 0, 
   0, 0,12,12,13,13,13,12,12, 0, 0, 0, 
   0, 0, 0,12,13,13,10,12, 0, 0, 0, 0, 
   0, 0, 0,12,12,12,12,10, 0, 0, 0, 0, 
   0, 0, 0, 0,12,12, 0, 0,10, 0, 0, 0, 
   0, 0, 0,10,12,12, 0, 0, 0, 0, 0, 0, 
   0, 0, 0, 0,12, 0, 0, 0, 0, 0, 0, 0, 
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
};

GUIObject::GUIObject(int id, int w, int h, GUIObject *parent)
   : Buffer(w, h)
{
   ID = id;
   Parent = parent;
   if (Parent)
      Parent->Add(this);
   Status = Closed;   
   X = Y = 0;
   W = w;
   H = h;
   for(int i=0; i<40; i++)
      Children[i] = (GUIObject*)NULL;
}

GUIObject::~GUIObject()
{
   for(int i=0; i<40; i++)
      if (Children[i])
         {
         if(Children[i]->Status == Shown)
            Children[i]->Hide();
//         delete Children[i];
         Children[i] = (GUIObject*)NULL;
         }

   if (Status == Shown)
      Hide();

   if (Parent)
      Parent->Remove(this);

   Status = Closed;
}

void GUIObject::Add(GUIObject *child)
{
   for(int i=0; i<40; i++)
      if (!Children[i])
         {
         Children[i] = child;
         return;
         }
}

void GUIObject::Remove(GUIObject *child)
{
   
   for(int i=0; i<40; i++)
      if (Children[i] == child)
         {
         Children[i] = (GUIObject*)NULL;
         return;
         }
}

void GUIObject::Show()
{
   // draw any children
   for (int i=0; i<40; i++)
      if(Children[i])
         Children[i]->Show();
}

void GUIObject::Hide()
{
   // display the background
   if (Status == Shown)
      blit (Buffer.bmp(), screen, 0, 0, X, Y, W, H);
}

void GUIObject::Handler(MouseEvent event, int x, int y)
{
   for (int i=0; i<40; i++)
      {
      if (Children[i] && x > Children[i]->x() 
         && x < Children[i]->x() + Children[i]->w()
         && y > Children[i]->y() 
         && y < Children[i]->y() + Children[i]->h())
         {
         switch(event)
            {
            case MouseUp:
               Children[i]->MouseUpHandler();
               break;
            case MouseDown:
               Children[i]->MouseDownHandler();
               break;
            case MouseClick:
               Children[i]->ClickHandler();
               break;
            }
         }
      }
}

Mouse::Mouse(int w, int h) 
{ 
   Bmap = new Bitmap(12, 12);
   Buffer = new Bitmap(12, 12);
   State[0] = State[1] = Up;
   *Bmap = vanguard;

   CurWindow = (GUIObject*)NULL;

   W = w;
   H = h;
   X = W/2;
   Y = H/2;

   Set();
   Btn1 = Btn2 = 0;
}

void Mouse::Set()
{
   __dpmi_regs r;
   r.x.ax = 0;
   __dpmi_int(0x33, &r);
   r.x.ax = 4;
   r.x.cx = X;
   if (H == 480)
      r.x.dx = Y;
   else
      r.x.dx = (Y * 150) / 100;
   __dpmi_int(0x33, &r); 
}

Mouse::~Mouse() 
{ 
   delete Bmap;
   delete Buffer;
}

void Mouse::Show() 
{
   blit(screen, Buffer->bmp(), X, Y, 0, 0, 12, 12);
   draw_sprite(screen, Bmap->bmp(), X, Y);
}

void Mouse::Hide()
{
   blit(Buffer->bmp(), screen, 0, 0, X, Y, 12, 12);         
}

void Mouse::Sleep()
{
   mouse->Hide();
}

void Mouse::Wake()
{
}

void Mouse::Update()
{
   int x = X;
   int y = Y;

   __dpmi_regs r;
   r.x.ax = 3;
   __dpmi_int(0x33, &r); 
   X = r.x.cx;
   if (H == 480)
      Y = r.x.dx;
   else
      Y = (r.x.dx * 150) / 100;
   Btn1 = r.x.bx & 1 ? 1 : 0;
   Btn2 = r.x.bx & 2 ? 1 : 0;

   if (x != X || y != Y)
      {
      blit(Buffer->bmp(), screen, 0, 0, x, y, 12, 12);         
      Show();
      }

   if (B1())
      {
      if (State[0] == Up)
         {
         State[0] = Down;
         Hide();
         Handler(MouseDown);
         Show();
         }
      }
   else
      {
      if (State[0] == Down)
         {
         State[0] = Up;
         Hide();
         Handler(MouseUp);
         Handler(MouseClick);
         Show();
         }
      }
}

int Mouse::B1() 
{ 
   return Btn1;
}

int Mouse::B2() 
{ 
   return Btn2;
}

void Mouse::operator =(Bitmap & bmp) 
{
   *Bmap = bmp.bmp();
}

void Mouse::Handler(MouseEvent event)
{
   CurWindow->Handler(event, X, Y);
}

Mouse *mouse;

Box::Box(int id, int x, int y, int w, int h, int color, GUIObject *parent)
   : GUIObject(id, w, h, parent)
{
   X = x;
   Y = y;
   if (Parent)
      {
      X += Parent->x();
      Y += Parent->y();
      }
   Color = color;
}

Box::~Box()
{
}

void Box::Show()
{
   // save the background
   if (Status != Shown)
      blit (screen, Buffer.bmp(), X, Y, 0, 0, W, H);

   // draw the box
   rectfill (screen, X, Y, X+W-1, Y+H-1, Color);

   GUIObject::Show();
   Status = Shown;
}

Title::Title(int id, int x, int y, int w, int h, int color,
   int hcolor, int lcolor, GUIObject *parent) 
   : Box (id, x, y, w, h, color, parent)
{
   HColor = hcolor;
   LColor = lcolor;
}

void Title::SetText(char *text)
{
   if(Text && strlen(text) > strlen(Text))
      delete []Text;
   Text = new char[strlen(text)+1];
   strcpy(Text, text);
}

void Title::Show()
{
   Box::Show();
   vline(screen, X, Y, Y+H-2, HColor);
   vline(screen, X+W-1, Y+1, Y+H-1, LColor);
   hline(screen, X, Y, X+W-2, HColor);
   hline(screen, X+1, Y+H-1, X+W-1, LColor);
   if (Text)
      {
      int x, y, w;
      w = strlen(Text)*8;
      x = (W - w)/2;
      y = (H - 8)/2;
      textout(screen, font, Text, X+x, Y+y, HColor);
      }
}

Window::Window(int id, int x, int y, int w, int h, int color, 
   int hcolor, int lcolor, int tcolor, GUIObject *parent) 
   : Box (id, x, y, w, h, color, parent)
{
   CX = X+4;
   CY = Y+4;
   WindowTitle = new Title(id+1, 0, 0, w-8, 12, tcolor, hcolor, 
      lcolor, this);
   CY += 12;
   HColor = hcolor;
   LColor = lcolor;
}

void Window::Show()
{
   Box::Show();
   vline(screen, X, Y, Y+H-2, HColor);
   vline(screen, X+3, Y+3, Y+H-5, LColor);
   vline(screen, X+W-1, Y+1, Y+H-1, LColor);
   vline(screen, X+W-4, Y+4, Y+H-4, HColor);
   hline(screen, X, Y, X+W-2, HColor);
   hline(screen, X+3, Y+3, X+W-5, LColor);
   hline(screen, X+1, Y+H-1, X+W-1, LColor);
   hline(screen, X+4, Y+H-4, X+W-4, HColor);
}

Button::Button(int id, int x, int y, int w, int h, int color, int hcolor,
   int lcolor, GUIObject *parent) 
   : Box (id, x, y, w, h, color, parent)
{
   HColor = hcolor;
   LColor = lcolor;
   State = Up;
   Text = NULL;
}

void Button::Show()
{
   Box::Show();
   vline(screen, X, Y, Y+H-2, State?LColor:HColor);
   vline(screen, X+1, Y+1, Y+H-3, State?LColor:HColor);
   vline(screen, X+W-1, Y+1, Y+H-1, State?HColor:LColor);
   vline(screen, X+W-2, Y+2, Y+H-2, State?HColor:LColor);
   hline(screen, X, Y, X+W-2, State?LColor:HColor);
   hline(screen, X+1, Y+1, X+W-3, State?LColor:HColor);
   hline(screen, X+1, Y+H-1, X+W-1, State?HColor:LColor);
   hline(screen, X+2, Y+H-2, X+W-2, State?HColor:LColor);
   if (Text)
      {
      int x, y, w;
      w = strlen(Text)*8;
      x = (W - w)/2;
      y = (H - 8)/2;
      textout(screen, font, Text, X+x-1, Y+y-1, LColor);
      textout(screen, font, Text, X+x, Y+y, HColor);
      }
}

void Button::SetText(char *text)
{
   if(Text && strlen(text) > strlen(Text))
      delete []Text;
   Text = new char[strlen(text)+1];
   strcpy(Text, text);
}

void Button::ClickHandler()
{
}

void Button::MouseDownHandler()
{
   if (State == Up)
      {
      State = Down;
      Show();
      }
}

void Button::MouseUpHandler()
{
   if (State == Down)
      {
      State = Up;
      Show();
      }
}

RadioButton::RadioButton(int id, int x, int y, int hcolor, int lcolor, GUIObject *parent) 
   : GUIObject (id, 8, 8, parent), BmapUp(8, 8), BmapDown(8, 8)
{
   State = Up;
   HColor = hcolor;
   LColor = lcolor;
   Text = NULL;
   BmapUp = radio;
   BmapDown = radio2;
   X = parent->x() + x;
   Y = parent->y() + y;
}

void RadioButton::Show()
{
   if (State == Up)
      BmapUp.Draw(X, Y);
   else
      BmapDown.Draw(X, Y);

   if (Text)
      {
      textout(screen, font, Text, X+W+4-1, Y, LColor);
      textout(screen, font, Text, X+W+4, Y+1, HColor);
      }
}

void RadioButton::SetText(char *text)
{
   if(Text && strlen(text) > strlen(Text))
      delete []Text;
   Text = new char[strlen(text)+1];
   strcpy(Text, text);
}

void RadioButton::ClickHandler()
{
   State = Down;
   Show();
   ((GroupBox*)Parent)->Update(this);
}

GroupBox::GroupBox(int id, int x, int y, int w, int h, int color, int hcolor,
   int lcolor, GUIObject *parent) 
   : Box (id, x, y, w, h, color, parent)
{
   HColor = hcolor;
   LColor = lcolor;
   CX = X + 1;
   CY = Y + 1;
}

void GroupBox::Show()
{
   Box::Show();
   vline(screen, X, Y, Y+H-2, LColor);
   vline(screen, X+W-1, Y+1, Y+H-1, HColor);
   hline(screen, X, Y, X+W-2, LColor);
   hline(screen, X+1, Y+H-1, X+W-1, HColor);
}

void GroupBox::ClickHandler()
{
   for (int i=0; i<40; i++)
      {
      if (Children[i] && mouse->x() > Children[i]->x() 
         && mouse->x() < Children[i]->x() + Children[i]->w()
         && mouse->y() > Children[i]->y() 
         && mouse->y() < Children[i]->y() + Children[i]->h())
            Children[i]->ClickHandler();
      }
}

void GroupBox::Update(RadioButton *button)
{
   for (int i=0; i<40; i++)
      if (Children[i] && Children[i] != (GUIObject*)button)
         {
         ((RadioButton*)Children[i])->SetState(RadioButton::Up);
         ((RadioButton*)Children[i])->Show();
         }
}

CheckBox::CheckBox(int id, int x, int y, int color, int hcolor,
   int lcolor, GUIObject *parent) 
   : Box (id, x, y, 8, 8, color, parent)
{
   HColor = hcolor;
   LColor = lcolor;
   Text = NULL;
   State = Up;
   X = parent->x() + x;
   Y = parent->y() + y;
}

void CheckBox::Show()
{
   Box::Show();
   vline(screen, X, Y, Y+H-2, LColor);
   vline(screen, X+W-1, Y+1, Y+H-1, HColor);
   hline(screen, X, Y, X+W-2, LColor);
   hline(screen, X+1, Y+H-1, X+W-1, HColor);

   if (State == Down)
      {
      line(screen, X+1, Y+1, X+W-2, Y+H-2, 1);
      line(screen, X+1, Y+H-2, X+W-2, Y+1, 1);
      }

   if (Text)
      {
      textout(screen, font, Text, X+W+4-1, Y, LColor);
      textout(screen, font, Text, X+W+4, Y+1, HColor);
      }
}

void CheckBox::SetText(char *text)
{
   if(Text && strlen(text) > strlen(Text))
      delete []Text;
   Text = new char[strlen(text)+1];
   strcpy(Text, text);
}

void CheckBox::ClickHandler()
{
   State = State == Down ? Up : Down;
   Show();
}

Marquee::Marquee(int id, int x, int y, int w, int h, int color, int hcolor,
   int lcolor, int tcolor, GUIObject *parent)
   : Box (id, x, y, w, h, color, parent)
{
   HColor = hcolor;
   LColor = lcolor;
   TColor = tcolor;
   Canvas = (Bitmap *)NULL;
   Text = NULL;
}

void Marquee::SetText(char *text)
{
   Text = text;
   TOffset = W-8;
   TSize = strlen(Text)*8 + W-8;
   Canvas = new Bitmap(TSize, H-8);
   clear_to_color(Canvas->bmp(), TColor);
   textout(Canvas->bmp(), font, Text, W-8, (H-16)/2, HColor);
}

void Marquee::Show()
{
   Box::Show();
   vline(screen, X, Y, Y+H-2, HColor);
   vline(screen, X+3, Y+3, Y+H-5, LColor);
   vline(screen, X+W-1, Y+1, Y+H-1, LColor);
   vline(screen, X+W-4, Y+4, Y+H-4, HColor);
   hline(screen, X, Y, X+W-2, HColor);
   hline(screen, X+3, Y+3, X+W-5, LColor);
   hline(screen, X+1, Y+H-1, X+W-1, LColor);
   hline(screen, X+4, Y+H-4, X+W-4, HColor);

   if (Text)
      blit(Canvas->bmp(), screen, TOffset, 0, X+4, Y+4, W-8, H-8);
}

void Marquee::Update()
{
   static Sync = 0;
   if (Text)
      {
      if (Vsync() && !Sync)
         {
         TOffset =  TOffset < TSize ? TOffset + 1 : 0;
         blit(Canvas->bmp(), screen, TOffset, 0, X+4, Y+4, W-8, H-8);
         Sync = 1;
         }
      else if (!Vsync() && Sync)
         Sync = 0;
      }
}

