#ifndef __GUI_H__
#define __GUI_H__

#include <dos.h>
#include <allegro.h>

enum MouseEvent { MouseUp=0, MouseDown, MouseClick };

class Bitmap
{
private:
   BITMAP *Bmap;
protected:
public:
   Bitmap(int w, int h) { Bmap = create_bitmap(w, h); };
   ~Bitmap() { destroy_bitmap(Bmap); };
   void operator =(BITMAP * bmp) { Bmap = bmp; };
   void operator =(char *def)
      {
      for (int i=0; i<Bmap->h; i++)
         for (int j=0; j<Bmap->w; j++)
            Bmap->line[i][j] = def[i*Bmap->w+j];
      }
   BITMAP * bmp() { return Bmap; };
   void Draw(int x, int y) { draw_sprite(screen, Bmap, x, y); };
};

class GUIObject
{
private:
protected:
   enum StatusCode { Closed=0, Hidden, Shown };
   int ID;
   int Status;
   int X, Y, W, H;
   int Color;
   GUIObject *Parent;
   GUIObject *Children[40];
   Bitmap Buffer;
public:
   GUIObject(int id, int w, int h, GUIObject *parent=NULL);
   virtual ~GUIObject();
   virtual void Add(GUIObject *child);
   virtual void Remove(GUIObject *child);
   virtual void Show();
   virtual void Hide();
   void Handler(MouseEvent event, int x, int y);
   virtual void ClickHandler() {};
   virtual void MouseDownHandler() {};
   virtual void MouseUpHandler() {};
   virtual int x() { return X; };
   virtual int y() { return Y; };
   virtual int w() { return W; };
   virtual int h() { return H; };
};

class Mouse
{
private:
   REGS		r;
   SREGS		s;
   int      X, Y;
   int      W, H;
   GUIObject * CurWindow;
   Bitmap * Bmap;
   Bitmap * Buffer;
   int      Btn1, Btn2;
   int      State[2];
   enum     MouseState { Up=0, Down };
protected:
public:
   Mouse(int w, int h);
   ~Mouse();
   void Set();
   void Handler(MouseEvent event);
   void Show();
   void Hide();
   void Sleep();
   void Wake();
   void Update();
   int B1();
   int B2();
   int x() { return X; };
   int y() { return Y; };
   void operator =(Bitmap & bmp);
   void SetWindow(GUIObject *win) { CurWindow = win; };
};

extern Mouse *mouse;

class Box : public GUIObject
{
private:
protected:
public:
   Box(int id, int x, int y, int w, int h, int color, GUIObject *parent=NULL);
   virtual ~Box();
   virtual void Show();
};

class Title : public Box
{
private:
   int TColor, HColor, LColor;
   char *Text;
protected:
public:
   Title(int id, int x, int y, int w, int h, int color=1,
      int hcolor=15, int lcolor=8, GUIObject *parent=NULL);
   virtual ~Title() {};
   void Show();
   void SetText(char *text);
};

class Window : public Box
{
private:
protected:
   int HColor, LColor;
   int CX, CY;
   Title *WindowTitle;
public:
   Window(int id, int x, int y, int w, int h, int color=7, int hcolor=15,
      int lcolor=8, int tcolor=1, GUIObject *parent=NULL);
   virtual ~Window() { delete WindowTitle; };
   void Show();
   virtual int x() { return CX; };
   virtual int y() { return CY; };
   virtual Title * title() { return WindowTitle; };
};

class Button : public Box
{
private:
protected:
   enum StateCode { Up=0, Down };
   int HColor, LColor;
   int State;
   char * Text;
public:
   Button(int id, int x, int y, int w, int h, int color=7, int hcolor=15,
      int lcolor=8, GUIObject *parent=NULL);
   virtual ~Button() { if (Text) delete []Text; };
   virtual void ClickHandler();
   virtual void MouseDownHandler();
   virtual void MouseUpHandler();
   void Show();
   void SetText(char* text);
};

class RadioButton : public GUIObject
{
public:
   enum StateCode { Up=0, Down };
private:
protected:
   StateCode State;
   int HColor, LColor;
   Bitmap BmapUp, BmapDown;
   char * Text;
public:
   RadioButton(int id, int x, int y, int hcolor=15, int lcolor=8, GUIObject *parent=NULL);
   virtual ~RadioButton() {};
   virtual void ClickHandler();
   void Show();
   void SetState(StateCode state) { State = state; };
   StateCode GetState() { return State; };
   void SetText(char* text);
};

class GroupBox : public Box
{
private:
protected:
   int HColor, LColor;
   int CX, CY;
public:
   GroupBox(int id, int x, int y, int w, int h, int color=7, int hcolor=15,
      int lcolor=8, GUIObject *parent=NULL);
   virtual ~GroupBox() {};
   void Show();
   void Update(RadioButton *button);
   virtual int x() { return CX; };
   virtual int y() { return CY; };
   virtual void ClickHandler();
};

class CheckBox : public Box
{
public:
   enum StateCode { Up=0, Down };
private:
protected:
   StateCode State;
   int HColor, LColor;
   char * Text;
public:
   CheckBox(int id, int x, int y, int color=7, int hcolor=15, int lcolor=8, 
      GUIObject *parent=NULL);
   virtual ~CheckBox() {};
   virtual void ClickHandler();
   void Show();
   void SetState(StateCode state) { State = state; Show(); };
   StateCode GetState() { return State; };
   void SetText(char *text);
};

class Marquee : public Box
{
private:
protected:
   int HColor, LColor, TColor;
   int TSize, TOffset;
   Bitmap *Canvas;
   char * Text;
   int Vsync() { return((inportb(0x3DA) & 8)?1:0); };

public:
   Marquee(int id, int x, int y, int w, int h, int color=7, int hcolor=15,
      int lcolor=8, int tcolor=1, GUIObject *parent=NULL);
   virtual ~Marquee() { delete Canvas; };
   void SetText(char *text);
   void Show();
   void Update();
};

#endif
