//#include <stdio.h>
#include "game.h"
#include "ioport.h"

IOPort::IOPort(WORD addr, BYTE mask=0x00)
{
   Address = addr;
   Base = StartBase = mask;
   int temp = 1;
   for (int i=0; i<8; i++)
      {
      Mask[i] = (mask&temp) >> i;
      temp = temp << 1;
      Keys[i] = Joy[i] = 0;
      }
}

void IOPort::SetKey(BYTE bit, BYTE akey)
{
   Keys[bit] = akey;
}

void IOPort::SetKey(BYTE key7, BYTE key6, BYTE key5, BYTE key4, 
   BYTE key3, BYTE key2, BYTE key1, BYTE key0)
{
   Keys[0] = key0;
   Keys[1] = key1;
   Keys[2] = key2;
   Keys[3] = key3;
   Keys[4] = key4;
   Keys[5] = key5;
   Keys[6] = key6;
   Keys[7] = key7;
}

void IOPort::SetJoy(BYTE bit, BYTE joy)
{
   Joy[bit] = joy;
}

void IOPort::SetJoy(BYTE joy7, BYTE joy6, BYTE joy5, BYTE joy4, 
   BYTE joy3, BYTE joy2, BYTE joy1, BYTE joy0)
{
   Joy[0] = joy0;
   Joy[1] = joy1;
   Joy[2] = joy2;
   Joy[3] = joy3;
   Joy[4] = joy4;
   Joy[5] = joy5;
   Joy[6] = joy6;
   Joy[7] = joy7;
}

BYTE IOPort::Get()
{
   BYTE rtn = Base;
   int temp = 1;
   for (int i=0; i<8; i++)
      {
      if (Keys[i])
         {
         if(pGame->KB()[Keys[i]])
            {
            if(Mask[i])
               rtn ^= temp;
            else
               rtn |= temp;
            }
         }
      if (Joy[i])
         {
         if (pGame->Joy())
            {
            switch (Joy[i])
               {
               case JOY_LEFT:
                  if(pGame->Joy()->Left())
                     {
                     if(Mask[i])
                        rtn ^= temp;
                     else
                        rtn |= temp;
                     }
                  break;
               case JOY_RIGHT:
                  if(pGame->Joy()->Right())
                     {
                     if(Mask[i])
                        rtn ^= temp;
                     else
                        rtn |= temp;
                     }
                  break;
               case JOY_UP:
                  if(pGame->Joy()->Up())
                     {
                     if(Mask[i])
                        rtn ^= temp;
                     else
                        rtn |= temp;
                     }
                  break;
               case JOY_DOWN:
                  if(pGame->Joy()->Down())
                     {
                     if(Mask[i])
                        rtn ^= temp;
                     else
                        rtn |= temp;
                     }
                  break;
               case JOY_BUTTON1:
                  if(pGame->Joy()->Button1())
                     {
                     if(Mask[i])
                        rtn ^= temp;
                     else
                        rtn |= temp;
                     }
                  break;
               case JOY_BUTTON2:
                  if(pGame->Joy()->Button2())
                     {
                     if(Mask[i])
                        rtn ^= temp;
                     else
                        rtn |= temp;
                     }
                  break;
               case JOY_BUTTON3:
                  if(pGame->Joy()->Button3())
                     {
                     if(Mask[i])
                        rtn ^= temp;
                     else
                        rtn |= temp;
                     }
                  break;
               case JOY_BUTTON4:
                  if(pGame->Joy()->Button4())
                     {
                     if(Mask[i])
                        rtn ^= temp;
                     else
                        rtn |= temp;
                     }
                  break;
               }
            }
         }

      temp = temp << 1;
      }

   return rtn;
}

DipSwitch::DipSwitch(WORD addr, BYTE mask)
   : IOPort(addr, mask)
{
   for (int i=0; i<8; i++)
      {
      Men[i].Description[i] = NULL;
      Men[i].Status = 0;
      Coins[i].Description[i] = NULL;
      Coins[i].Status = 0;
      Bonus[i].Description[i] = NULL;
      Bonus[i].Status = 0;
      Level[i].Description[i] = NULL;
      Level[i].Status = 0;
      Extra[i].Description[i] = NULL;
      Extra[i].Status = 0;
      }

   MenDefault = CoinsDefault = BonusDefault = LevelDefault = ExtraDefault = 0;
   MenSize = CoinsSize = BonusSize = LevelSize = ExtraSize = 0;
}

DipSwitch::~DipSwitch()
{
}

void DipSwitch::SetMen(BYTE start, BYTE def, char *desc0, char *desc1,
   char *desc2, char *desc3, char *desc4, char *desc5, char *desc6, char *desc7)
{
   Men[0].Status = 1;
   strcpy(Men[0].Description, desc0);
   Men[1].Status = 1;
   strcpy(Men[1].Description, desc1);
   MenSize = 2;

   // check for 2nd bit
   if (desc2)
      {
      Men[2].Status = 1;
      strcpy(Men[2].Description, desc2);
      }
   if (desc3)
      {
      Men[3].Status = 1;
      strcpy(Men[3].Description, desc3);
      MenSize = 4;
      }

   // check for 3rd bit
   if (desc4)
      {
      Men[4].Status = 1;
      strcpy(Men[4].Description, desc4);
      }
   if (desc5)
      {
      Men[5].Status = 1;
      strcpy(Men[5].Description, desc5);
      }
   if (desc6)
      {
      Men[6].Status = 1;
      strcpy(Men[6].Description, desc6);
      }
   if (desc7)
      {
      Men[7].Status = 1;
      strcpy(Men[7].Description, desc7);
      MenSize = 8;
      }

   MenDefault = def;
   MenStartBit = start;
   UpdateBase(MenDefault, MenStartBit, MenSize);
}

void DipSwitch::SelectMen(BYTE idx)
{
   if (Men[idx].Status)
      MenDefault = idx;

   UpdateBase(MenDefault, MenStartBit, MenSize);
}

void DipSwitch::SetCoins(BYTE start, BYTE def, char *desc0, char *desc1,
   char *desc2, char *desc3, char *desc4, char *desc5, char *desc6, char *desc7)
{
   Coins[0].Status = 1;
   strcpy(Coins[0].Description, desc0);
   Coins[1].Status = 1;
   strcpy(Coins[1].Description, desc1);
   CoinsSize = 2;

   // check for 2nd bit
   if (desc2)
      {
      Coins[2].Status = 1;
      strcpy(Coins[2].Description, desc2);
      }
   if (desc3)
      {
      Coins[3].Status = 1;
      strcpy(Coins[3].Description, desc3);
      CoinsSize = 4;
      }

   // check for 3rd bit
   if (desc4)
      {
      Coins[4].Status = 1;
      strcpy(Coins[4].Description, desc4);
      }
   if (desc5)
      {
      Coins[5].Status = 1;
      strcpy(Coins[5].Description, desc5);
      }
   if (desc6)
      {
      Coins[6].Status = 1;
      strcpy(Coins[6].Description, desc6);
      }
   if (desc7)
      {
      Coins[7].Status = 1;
      strcpy(Coins[7].Description, desc7);
      CoinsSize = 8;
      }

   CoinsDefault = def;
   CoinsStartBit = start;
   UpdateBase(CoinsDefault, CoinsStartBit, CoinsSize);
}

void DipSwitch::SelectCoins(BYTE idx)
{
   if (Coins[idx].Status)
      CoinsDefault = idx;

   UpdateBase(CoinsDefault, CoinsStartBit, CoinsSize);
}

void DipSwitch::SetBonus(BYTE start, BYTE def, char *desc0, char *desc1,
   char *desc2, char *desc3, char *desc4, char *desc5, char *desc6, char *desc7)
{
   Bonus[0].Status = 1;
   strcpy(Bonus[0].Description, desc0);
   Bonus[1].Status = 1;
   strcpy(Bonus[1].Description, desc1);
   BonusSize = 2;

   // check for 2nd bit
   if (desc2)
      {
      Bonus[2].Status = 1;
      strcpy(Bonus[2].Description, desc2);
      }
   if (desc3)
      {
      Bonus[3].Status = 1;
      strcpy(Bonus[3].Description, desc3);
      BonusSize = 4;
      }

   // check for 3rd bit
   if (desc4)
      {
      Bonus[4].Status = 1;
      strcpy(Bonus[4].Description, desc4);
      }
   if (desc5)
      {
      Bonus[5].Status = 1;
      strcpy(Bonus[5].Description, desc5);
      }
   if (desc6)
      {
      Bonus[6].Status = 1;
      strcpy(Bonus[6].Description, desc6);
      }
   if (desc7)
      {
      Bonus[7].Status = 1;
      strcpy(Bonus[7].Description, desc7);
      BonusSize = 8;
      }

   BonusDefault = def;
   BonusStartBit = start;
   UpdateBase(BonusDefault, BonusStartBit, BonusSize);
}

void DipSwitch::SelectBonus(BYTE idx)
{
   if (Bonus[idx].Status)
      BonusDefault = idx;

   UpdateBase(BonusDefault, BonusStartBit, BonusSize);
}

void DipSwitch::SetLevel(BYTE start, BYTE def, char *desc0, char *desc1,
   char *desc2, char *desc3, char *desc4, char *desc5, char *desc6, char *desc7)
{
   Level[0].Status = 1;
   strcpy(Level[0].Description, desc0);
   Level[1].Status = 1;
   strcpy(Level[1].Description, desc1);
   LevelSize = 2;

   // check for 2nd bit
   if (desc2)
      {
      Level[2].Status = 1;
      strcpy(Level[2].Description, desc2);
      }
   if (desc3)
      {
      Level[3].Status = 1;
      strcpy(Level[3].Description, desc3);
      LevelSize = 4;
      }

   // check for 3rd bit
   if (desc4)
      {
      Level[4].Status = 1;
      strcpy(Level[4].Description, desc4);
      }
   if (desc5)
      {
      Level[5].Status = 1;
      strcpy(Level[5].Description, desc5);
      }
   if (desc6)
      {
      Level[6].Status = 1;
      strcpy(Level[6].Description, desc6);
      }
   if (desc7)
      {
      Level[7].Status = 1;
      strcpy(Level[7].Description, desc7);
      LevelSize = 8;
      }

   LevelDefault = def;
   LevelStartBit = start;
   UpdateBase(LevelDefault, LevelStartBit, LevelSize);
}

void DipSwitch::SelectLevel(BYTE idx)
{
   if (Level[idx].Status)
      LevelDefault = idx;

   UpdateBase(LevelDefault, LevelStartBit, LevelSize);
}

void DipSwitch::SetExtra(BYTE start, BYTE def, char *desc0, char *desc1,
   char *desc2, char *desc3, char *desc4, char *desc5, char *desc6, char *desc7)
{
   Extra[0].Status = 1;
   strcpy(Extra[0].Description, desc0);
   Extra[1].Status = 1;
   strcpy(Extra[1].Description, desc1);
   ExtraSize = 2;

   // check for 2nd bit
   if (desc2)
      {
      Extra[2].Status = 1;
      strcpy(Extra[2].Description, desc2);
      }
   if (desc3)
      {
      Extra[3].Status = 1;
      strcpy(Extra[3].Description, desc3);
      ExtraSize = 4;
      }

   // check for 3rd bit
   if (desc4)
      {
      Extra[4].Status = 1;
      strcpy(Extra[4].Description, desc4);
      }
   if (desc5)
      {
      Extra[5].Status = 1;
      strcpy(Extra[5].Description, desc5);
      }
   if (desc6)
      {
      Extra[6].Status = 1;
      strcpy(Extra[6].Description, desc6);
      }
   if (desc7)
      {
      Extra[7].Status = 1;
      strcpy(Extra[7].Description, desc7);
      ExtraSize = 8;
      }

   ExtraDefault = def;
   ExtraStartBit = start;
   UpdateBase(ExtraDefault, ExtraStartBit, ExtraSize);
}

void DipSwitch::SelectExtra(BYTE idx)
{
   if (Extra[idx].Status)
      ExtraDefault = idx;

   UpdateBase(ExtraDefault, ExtraStartBit, ExtraSize);
}

void DipSwitch::UpdateBase(BYTE def, BYTE start, BYTE size)
{
   BYTE len = 0;
   BYTE mask;

   Base = StartBase;

   // get bits
   while(size > 1)
      {            
      size = size >> 1;
      len++;
      }

   for (int i=0; i<len; i++)
      {
      mask = (def & (1<<i)) << start;
      if (Mask[i+start]) 
         Base ^= mask;
      else
         Base |= mask;
      }
}













