#ifndef __IOPORT_H__
#define __IOPORT_H__

#include <allegro.h>

// ioport handler class 
class IOPort
{
private: 
   WORD Address;
   BYTE Keys[8];
   BYTE Joy[8];
protected:
   BYTE Base, StartBase;
   BYTE Mask[8];
public:
   IOPort(WORD addr, BYTE mask=0x00);
   virtual ~IOPort() {};
   void SetKey(BYTE bit, BYTE key);
   void SetKey(BYTE key7, BYTE key6, BYTE key5, BYTE key4, 
      BYTE key3, BYTE key2, BYTE key1, BYTE key0);
   void SetJoy(BYTE bit, BYTE joy);
   void SetJoy(BYTE joy7, BYTE joy6, BYTE joy5, BYTE joy4, 
      BYTE joy3, BYTE joy2, BYTE joy1, BYTE joy0);
   BYTE Get();
};

typedef struct
{
   BYTE Status;
   char Description[20];
} DSWSetting;

class DipSwitch : public IOPort
{
private:
   // dipswitch settings for men per game
   DSWSetting Men[8];
   BYTE MenDefault;
   BYTE MenStartBit;
   BYTE MenSize;

   // dipswitch settings for coins per game
   DSWSetting Coins[8];
   BYTE CoinsDefault;
   BYTE CoinsStartBit;
   BYTE CoinsSize;

   // dipswitch settings for game bonus
   DSWSetting Bonus[8];
   BYTE BonusDefault;
   BYTE BonusStartBit;
   BYTE BonusSize;

   // dipswitch settings for difficulty level
   DSWSetting Level[8];
   BYTE LevelDefault;
   BYTE LevelStartBit;
   BYTE LevelSize;

   // extra dipswitch settings (programmer definable)
   DSWSetting Extra[8];
   BYTE ExtraDefault;
   BYTE ExtraStartBit;
   BYTE ExtraSize;
protected:
   void UpdateBase(BYTE def, BYTE start, BYTE size);
public:
   DipSwitch(WORD addr, BYTE mask=0x00);
   virtual ~DipSwitch();
   void SetMen(BYTE start, BYTE def, char *desc0, char *desc1, char *desc2=NULL, 
      char *desc3=NULL, char *desc4=NULL, char *desc5=NULL, char *desc6=NULL,
      char *desc7=NULL);
   void SelectMen(BYTE idx);
   void SetCoins(BYTE start, BYTE def, char *desc0, char *desc1, char *desc2=NULL, 
      char *desc3=NULL, char *desc4=NULL, char *desc5=NULL, char *desc6=NULL,
      char *desc7=NULL);
   void SelectCoins(BYTE idx);
   void SetBonus(BYTE start, BYTE def, char *desc0, char *desc1, char *desc2=NULL, 
      char *desc3=NULL, char *desc4=NULL, char *desc5=NULL, char *desc6=NULL,
      char *desc7=NULL);
   void SelectBonus(BYTE idx);
   void SetLevel(BYTE start, BYTE def, char *desc0, char *desc1, char *desc2=NULL, 
      char *desc3=NULL, char *desc4=NULL, char *desc5=NULL, char *desc6=NULL,
      char *desc7=NULL);
   void SelectLevel(BYTE idx);
   void SetExtra(BYTE start, BYTE def, char *desc0, char *desc1, char *desc2=NULL, 
      char *desc3=NULL, char *desc4=NULL, char *desc5=NULL, char *desc6=NULL,
      char *desc7=NULL);
   void SelectExtra(BYTE idx);
   DSWSetting & men(int x) { return Men[x]; };
   BYTE menDefault() { return MenDefault; };
   BYTE menStartBit() { return MenStartBit; };
   BYTE menSize() { return MenSize; };
   DSWSetting & coins(int x) { return Coins[x]; };
   BYTE coinsDefault() { return CoinsDefault; };
   BYTE coinsStartBit() { return CoinsStartBit; };
   BYTE coinsSize() { return CoinsSize; };
   DSWSetting & bonus(int x) { return Bonus[x]; };
   BYTE bonusDefault() { return BonusDefault; };
   BYTE bonusStartBit() { return BonusStartBit; };
   BYTE bonusSize() { return BonusSize; };
   DSWSetting & level(int x) { return Level[x]; };
   BYTE levelDefault() { return LevelDefault; };
   BYTE levelStartBit() { return LevelStartBit; };
   BYTE levelSize() { return LevelSize; };
   DSWSetting & extra(int x) { return Extra[x]; };
   BYTE extraDefault() { return ExtraDefault; };
   BYTE extraStartBit() { return ExtraStartBit; };
   BYTE extraSize() { return ExtraSize; };
};

#endif






