#ifndef __JOYSTICK_H__
#define __JOYSTICK_H__

#include <allegro.h>

enum JOYCTLS { JOY_NONE=0, JOY_LEFT, JOY_RIGHT, JOY_UP, JOY_DOWN,
   JOY_BUTTON1, JOY_BUTTON2, JOY_BUTTON3, JOY_BUTTON4 };

// joystick handler class - currently just a wrapper class for allegro
class Joystick                                           
{
private:   
protected:
public:
   Joystick(int type=JOY_TYPE_STANDARD) 
      { joy_type = type; initialise_joystick(); };
   ~Joystick() {};
   void ReadJoystick() { poll_joystick(); };
   int Gravis() { return (joy_type == JOY_TYPE_4BUTTON ? 1 : 0); };
   int Left() { return joy_left; };
   int Right() { return joy_right; };
   int Up() { return joy_up; };
   int Down() { return joy_down; };
   int Button1() { return joy_b1; };
   int Button2() { return joy_b2; };
   int Button3() 
      { return (joy_type == JOY_TYPE_4BUTTON ? joy_b3 : -1); };
   int Button4()
      { return (joy_type == JOY_TYPE_4BUTTON ? joy_b4 : -1); };
};

#endif






