/* Multi-6809 32 Bit emulator */

/* Copyright 1997, Pat Lawrence, All rights reserved
 *
 * License agreement:
 *
 * The M6809 emulator may be distributed in unmodified form to any medium.
 *
 * M6809 May not be sold, or sold as a part of a commercial package without
 * the express written permission of Pat Lawrence (pjl@ns.net). This
 * includes shareware.
 *
 * Modified versions of M6809 may not be publicly redistributed without author
 * approval (pjl@ns.net). This includes distributing via a publicly
 * accessible LAN. You may make your own source modifications and distribute
 * M6809 in object only form.
 *
 * M6809 Licensing for commercial applications is available. Please email
 * pjl@ns.net for details.
 *
 * Synthcom Systems, Inc, and Pat Lawrence will not be held responsible for
 * any damage done by the use of M6809. It is purely "as-is".
 *
 * If you use M6809 in a freeware application, credit in the following text:
 *
 * "Multi-6809 CPU emulator by Pat Lawrence (pjl@ns.net)"
 *
 * must accompany the freeware application within the application itself or
 * in the documentation.
 *
 * Legal stuff aside:
 *
 * If you find problems with M6809, please email the author so they can get
 * resolved. If you find a bug and fix it, please also email the author so
 * that those bug fixes can be propogated to the installed base of M6809
 * users. If you find performance improvements or problems with M6809, please
 * email the author with your changes/suggestions and they will be rolled in
 * with subsequent releases of M6809.
 *
 * The whole idea of this emulator is to have the fastest available 32 bit
 * Multi-6809 emulator for the PC, giving maximum performance. 
 */ 

/* General 6809 related goodies */

#ifndef	__M6809_H__
#define	__M6809_H__

#ifdef __cplusplus
extern "C" 
{
#endif

#ifndef DWORD
#define	DWORD	unsigned long int
#endif

#ifndef WORD
#define	WORD	unsigned short int
#endif

#ifndef BYTE
#define	BYTE	unsigned char
#endif

/* Some bitwise defines for the m6809GetInfo call */

#define		MULTI_CPU		0x00010000	/* Set if multi CPU support */
#define		TIMING_INFO		0x00020000	/* Set if timing info present */
#define		SYNC			0x00040000	/* Set if SYNC support present */
#define		BOUNDS_CHECK		0x00080000	/* Set if bounds checking on */
#define		EXEC_METHOD		0x00100000	/* Set if we're counting cycles */

extern DWORD m6809nmi(void);
extern DWORD m6809int(void);
extern DWORD m6809firq(void);
extern DWORD m6809exec(DWORD);
extern void m6809reset(void);
extern DWORD m6809GetInfo(void);

struct m6809MemoryWrite
{
	WORD lowAddr;
	WORD highAddr;
	WORD (*memoryCall)(WORD, BYTE);
};	

struct m6809MemoryRead
{
	WORD lowAddr;
	WORD highAddr;
	WORD (*memoryCall)(WORD);
};	

extern struct	m6809MemoryRead *m6809MemoryRead;
extern struct	m6809MemoryWrite *m6809MemoryWrite;

/* WARNING: Do not use a sizeof() operator on this structure. The assembly
 * code will pack other context relevant data after this space. Use the
 * GetContextSize() call to obtain the specifics of the context.
 *
 * Creating a context is not necessary if you are only running a single CPU
 * emulation.
 */

struct m6809context
{
	BYTE	*m6809Base;				/* 32 Bit pointer to base memory address */

	/* 32 Bit pointers to user trap address structure array */

	struct	m6809MemoryRead *m6809MemoryRead;
	struct	m6809MemoryWrite *m6809MemoryWrite;

	/* Number of clockticks */

	DWORD	m6809clockticks;

	/* This context's register dump */

	WORD	m6809pc;		/* Program counter */
	WORD	m6809u;			/* U stack pointer */
	WORD	m6809s;			/* S stack pointer */
	WORD	m6809x;			/* X register */
	WORD	m6809y;			/* Y register */
	BYTE	m6809b;			/* B register */
	BYTE	m6809a;			/* A register */
	BYTE	m6809cc;		/* CC flags */
	BYTE	m6809dp;		/* Direct page register */
	BYTE	syncCycle;		/* Non-zero if this is a sync-cycle instruction */
	BYTE	inNmi;			/* Non-zero if we're in an NMI */
};
	
typedef struct m6809context CONTEXTM6809;

extern void	m6809SetContext(CONTEXTM6809 *);
extern void	m6809GetContext(CONTEXTM6809 *);
extern DWORD	m6809GetContextSize();
extern DWORD	m6809clockticks;
extern DWORD	m6809cyclesRemaining;
extern BYTE	*m6809Base;

#ifdef __cplusplus
}
#endif

#endif // __M6809_H__
