#include <stdio.h>
#include <string.h>
#include "mcresta.h"

MCresta * pMCresta;

BYTE mcrestaColors[] = 
{
	0x00,0x7a,0x36,0x07,0x00,0xf0,0x38,0x1f,
	0x00,0xc7,0xf0,0x3f,0x00,0xdb,0xc6,0x38,
	0x00,0x36,0x07,0xf0,0x00,0x33,0x3f,0xdb,
	0x00,0x3f,0x57,0xc6,0x00,0xc6,0x3f,0xff
};

ROMS mcrestaRoms[] = 
{
   { 0x0000,  "mc1", 2048, "code" },
   { 0x0800,  "mc2", 2048, "code" },
   { 0x1000,  "mc3", 2048, "code" },
   { 0x1800,  "mc4", 2048, "code" },
   { 0x2000,  "mc5", 2048, "code" },
   { 0x2800,  "mc6", 2048, "code" },
   { 0x3000,  "mc7", 2048, "code" },
   { 0x3800,  "mc8", 2048, "code" },
   { 0xE000,  "mcb", 2048, "graphics" },
   { 0xE800,  "mcd", 2048, "graphics" },
   { 0xF000,  "mca", 2048, "graphics" },
   { 0xF800,  "mcc", 2048, "graphics" },
   { 0, NULL, 0, NULL }	
};

static BYTE mcrestaEvenDecode[] = {
	0x00,0x01,0x06,0x07,0x40,0x41,0x46,0x47,0x08,0x09,0x0e,0x0f,0x48,0x49,0x4e,0x4f,
	0x10,0x11,0x16,0x17,0x50,0x51,0x56,0x57,0x18,0x19,0x1e,0x1f,0x58,0x59,0x5e,0x5f,
	0x60,0x61,0x66,0x67,0x20,0x21,0x26,0x27,0x68,0x69,0x6e,0x6f,0x28,0x29,0x2e,0x2f,
	0x70,0x71,0x76,0x77,0x30,0x31,0x36,0x37,0x78,0x79,0x7e,0x7f,0x38,0x39,0x3e,0x3f,
	0x04,0x05,0x02,0x03,0x44,0x45,0x42,0x43,0x0c,0x0d,0x0a,0x0b,0x4c,0x4d,0x4a,0x4b,
	0x14,0x15,0x12,0x13,0x54,0x55,0x52,0x53,0x1c,0x1d,0x1a,0x1b,0x5c,0x5d,0x5a,0x5b,
	0x64,0x65,0x62,0x63,0x24,0x25,0x22,0x23,0x6c,0x6d,0x6a,0x6b,0x2c,0x2d,0x2a,0x2b,
	0x74,0x75,0x72,0x73,0x34,0x35,0x32,0x33,0x7c,0x7d,0x7a,0x7b,0x3c,0x3d,0x3a,0x3b,
	0x80,0x81,0x86,0x87,0xc0,0xc1,0xc6,0xc7,0x88,0x89,0x8e,0x8f,0xc8,0xc9,0xce,0xcf,
	0x90,0x91,0x96,0x97,0xd0,0xd1,0xd6,0xd7,0x98,0x99,0x9e,0x9f,0xd8,0xd9,0xde,0xdf,
	0xe0,0xe1,0xe6,0xe7,0xa0,0xa1,0xa6,0xa7,0xe8,0xe9,0xee,0xef,0xa8,0xa9,0xae,0xaf,
	0xf0,0xf1,0xf6,0xf7,0xb0,0xb1,0xb6,0xb7,0xf8,0xf9,0xfe,0xff,0xb8,0xb9,0xbe,0xbf,
	0x84,0x85,0x82,0x83,0xc4,0xc5,0xc2,0xc3,0x8c,0x8d,0x8a,0x8b,0xcc,0xcd,0xca,0xcb,
	0x94,0x95,0x92,0x93,0xd4,0xd5,0xd2,0xd3,0x9c,0x9d,0x9a,0x9b,0xdc,0xdd,0xda,0xdb,
	0xe4,0xe5,0xe2,0xe3,0xa4,0xa5,0xa2,0xa3,0xec,0xed,0xea,0xeb,0xac,0xad,0xaa,0xab,
	0xf4,0xf5,0xf2,0xf3,0xb4,0xb5,0xb2,0xb3,0xfc,0xfd,0xfa,0xfb,0xbc,0xbd,0xba,0xbb
};
	
static unsigned char mcrestaOddDecode[] = {
	0x00,0x01,0x42,0x43,0x04,0x05,0x46,0x47,0x08,0x09,0x4a,0x4b,0x0c,0x0d,0x4e,0x4f,
	0x10,0x11,0x52,0x53,0x14,0x15,0x56,0x57,0x18,0x19,0x5a,0x5b,0x1c,0x1d,0x5e,0x5f,
	0x24,0x25,0x66,0x67,0x20,0x21,0x62,0x63,0x2c,0x2d,0x6e,0x6f,0x28,0x29,0x6a,0x6b,
	0x34,0x35,0x76,0x77,0x30,0x31,0x72,0x73,0x3c,0x3d,0x7e,0x7f,0x38,0x39,0x7a,0x7b,
	0x40,0x41,0x02,0x03,0x44,0x45,0x06,0x07,0x48,0x49,0x0a,0x0b,0x4c,0x4d,0x0e,0x0f,
	0x50,0x51,0x12,0x13,0x54,0x55,0x16,0x17,0x58,0x59,0x1a,0x1b,0x5c,0x5d,0x1e,0x1f,
	0x64,0x65,0x26,0x27,0x60,0x61,0x22,0x23,0x6c,0x6d,0x2e,0x2f,0x68,0x69,0x2a,0x2b,
	0x74,0x75,0x36,0x37,0x70,0x71,0x32,0x33,0x7c,0x7d,0x3e,0x3f,0x78,0x79,0x3a,0x3b,
	0x80,0x81,0xc2,0xc3,0x84,0x85,0xc6,0xc7,0x88,0x89,0xca,0xcb,0x8c,0x8d,0xce,0xcf,
	0x90,0x91,0xd2,0xd3,0x94,0x95,0xd6,0xd7,0x98,0x99,0xda,0xdb,0x9c,0x9d,0xde,0xdf,
	0xa4,0xa5,0xe6,0xe7,0xa0,0xa1,0xe2,0xe3,0xac,0xad,0xee,0xef,0xa8,0xa9,0xea,0xeb,
	0xb4,0xb5,0xf6,0xf7,0xb0,0xb1,0xf2,0xf3,0xbc,0xbd,0xfe,0xff,0xb8,0xb9,0xfa,0xfb,
	0xc0,0xc1,0x82,0x83,0xc4,0xc5,0x86,0x87,0xc8,0xc9,0x8a,0x8b,0xcc,0xcd,0x8e,0x8f,
	0xd0,0xd1,0x92,0x93,0xd4,0xd5,0x96,0x97,0xd8,0xd9,0x9a,0x9b,0xdc,0xdd,0x9e,0x9f,
	0xe4,0xe5,0xa6,0xa7,0xe0,0xe1,0xa2,0xa3,0xec,0xed,0xae,0xaf,0xe8,0xe9,0xaa,0xab,
	0xf4,0xf5,0xb6,0xb7,0xf0,0xf1,0xb2,0xb3,0xfc,0xfd,0xbe,0xbf,0xf8,0xf9,0xba,0xbb
};

MemoryWrite MCrestaWrite[] = 
{
   { 0x9000, 0x93FF, GalaxOut },
   { 0x9800, 0x9880, GalaxOut },
   { 0xA000, 0xA002, MCrestaROMSet },
   { 0xA803, 0xA803, GalaxExplode },
   { 0xA805, 0xA805, GalaxShoot },
   { 0xB004, 0xB004, GalaxStarsEnable },
   { 0xB800, 0xB800, GalaxSound },
   { 0xFFFF, 0xFFFF, NULL }
};

MemoryRead MCrestaRead[] = 
{
//   { 0x8042, 0x804E, MCrestaReadScores },
   { 0xA000, 0xA000, GalaxReadPlayer0 },
   { 0xA800, 0xA800, GalaxReadPlayer1 },
   { 0xB000, 0xB000, GalaxReadDipSwitch },
   { 0xFFFF, 0xFFFF, NULL }
};

MCresta::MCresta() : Galax (mcrestaRoms, "mcresta")
{
   pMCresta = this;

   Decode();
   pProcZ80->SetMemoryRW(MCrestaWrite, MCrestaRead, pRWTable, GalaxInProc,
      GalaxOutProc, 30000, pRAM, 1);

   // input ports
   Player0->SetKey(0, 0, 0, KEY_CONTROL, KEY_RIGHT, KEY_LEFT, 0, KEY_3);
   Player0->SetJoy(0, 0, 0, JOY_BUTTON1, JOY_RIGHT, JOY_LEFT, 0, 0);
   Dipswitch->SetBonus(6, 0, "30000 Points", "50000 Points");
   Dipswitch->SetCoins(2, 0, "1 Coin 1 Play", "1 Coin 2 Plays", "1 Coin 3 Plays", 
      "Not Used");

   // setup name and description
   strcpy(Name, "mcresta");
   strcpy(Descript, "Moon Cresta");

   // the parent class needs certain game specifics
   MemBase = 0x8000;
   MemSize = 0x2000;
   InterruptEnable = 0xB000;
   VideoAddress = 0x9000;
   AttributeAddress = 0x9800;
   BulletAddress = 0x9860;
   SpriteAddress = 0x9840;
   ROM1 = 0xE000;
   ROM2 = 0xF000;

   // setup generic switch pointers
   pBonusDSW = Dipswitch;
   pCoinsDSW = Dipswitch;
}

MCresta::~MCresta()
{
}   

void MCresta::Reset()
{
   // setup the display
   pDisplay = new Display(256, 256, 256, 256, 0, 0, 0, 0, scr256x256, 200);
   pColors = mcrestaColors;
   BuildText(0xE000, 0xE050, 0xE160, 0xE120);

   // reset memory
   Galax::Reset();
}

void MCresta::LoadScore()
{
   if (!ScoreLoaded && memcmp (pRAM + 0x8042, "\x00\x50\x00", 3) == 0 &&
      memcmp (pRAM + 0x83F9, "\x00\x50\x00", 3) == 0)
      {
      ReadScore(0x8042, 85);
      ScoreLoaded = 1;
      }
}

void MCresta::SaveScore()
{
   WriteScore(0x8042, 85);
}

void MCresta::Decode(void)
{
   for (int i=0; i<0x4000; i++)
      {
   	if (i & 1) 
	      pRAMSave[i] = mcrestaOddDecode[pRAM[i]];
   	else 
   	   pRAMSave[i] = mcrestaEvenDecode[pRAM[i]];
      }
}

BYTE MCrestaReadScores(WORD A)
{
   pMCresta->LoadScore();
   return pGame->RAM()[A];
}

int MCrestaROMSet(WORD A,  BYTE B)
{
	if (B) pMCresta->ROMSet |= (1 << (A-0xA000));
	else pMCresta->ROMSet &= ~(1 << (A-0xA000));
   pGame->RAM()[A] = B;
   return 0;
}




