#include <stdio.h>
#include <string.h>
#include "mcrestab.h"

MCrestaBoot * pMCrestaBoot;

BYTE mcrestabootColors[] = 
{
	0x00,0x7a,0x36,0x07,0x00,0xf0,0x38,0x1f,
	0x00,0xc7,0xf0,0x3f,0x00,0xdb,0xc6,0x38,
	0x00,0x36,0x07,0xf0,0x00,0x33,0x3f,0xdb,
	0x00,0x3f,0x57,0xc6,0x00,0xc6,0x3f,0xff
};

ROMS mcrestabootRoms[] = 
{
   { 0x0000,  "epr194", 2048, "code" },
   { 0x0800,  "epr195", 2048, "code" },
   { 0x1000,  "epr196", 2048, "code" },
   { 0x1800,  "epr197", 2048, "code" },
   { 0x2000,  "epr198", 2048, "code" },
   { 0x2800,  "epr199", 2048, "code" },
   { 0x3000,  "epr200", 2048, "code" },
   { 0x3800,  "epr201", 2048, "code" },
   { 0xE000,  "epr203", 2048, "graphics" },
   { 0xE800,  "epr172", 2048, "graphics" },
   { 0xF000,  "epr202", 2048, "graphics" },
   { 0xF800,  "epr171", 2048, "graphics" },
   { 0, NULL, 0, NULL }	
};

MemoryWrite MCrestaBootWrite[] = 
{
   { 0x9000, 0x93FF, GalaxOut },
   { 0x9800, 0x9880, GalaxOut },
   { 0xA000, 0xA002, MCrestaBootROMSet },
   { 0xA803, 0xA803, GalaxExplode },
   { 0xA805, 0xA805, GalaxShoot },
   { 0xB004, 0xB004, GalaxStarsEnable },
   { 0xB800, 0xB800, GalaxSound },
   { 0xFFFF, 0xFFFF, NULL }
};

MemoryRead MCrestaBootRead[] = 
{
   { 0x8042, 0x804E, MCrestaBootReadScores },
   { 0xA000, 0xA000, GalaxReadPlayer0 },
   { 0xA800, 0xA800, GalaxReadPlayer1 },
   { 0xB000, 0xB000, GalaxReadDipSwitch },
   { 0xFFFF, 0xFFFF, NULL }
};

MCrestaBoot::MCrestaBoot() : Galax (mcrestabootRoms, "mcresta")
{
   pMCrestaBoot = this;

   pProcZ80->SetMemoryRW(MCrestaBootWrite, MCrestaBootRead, pRWTable, GalaxInProc,
      GalaxOutProc, 30000, pRAM, 1);

   // input ports
   Player0->SetKey(0, 0, 0, KEY_CONTROL, KEY_RIGHT, KEY_LEFT, 0, KEY_3);
   Player0->SetJoy(0, 0, 0, JOY_BUTTON1, JOY_RIGHT, JOY_LEFT, 0, 0);
   Dipswitch->SetBonus(6, 0, "30000 Points", "50000 Points");
   Dipswitch->SetCoins(2, 0, "1 Coin 1 Play", "1 Coin 2 Plays", "1 Coin 3 Plays", 
      "Not Used");

   // setup name and description
   strcpy(Name, "mcrestaboot");
   strcpy(Descript, "Moon Cresta");

   // the parent class needs certain game specifics
   MemBase = 0x8000;
   MemSize = 0x2000;
   InterruptEnable = 0xB000;
   VideoAddress = 0x9000;
   AttributeAddress = 0x9800;
   BulletAddress = 0x9860;
   SpriteAddress = 0x9840;
   ROM1 = 0xE000;
   ROM2 = 0xF000;

   // setup generic switch pointers
   pBonusDSW = Dipswitch;
   pCoinsDSW = Dipswitch;
}

MCrestaBoot::~MCrestaBoot()
{
}   

void MCrestaBoot::Reset()
{
   // setup the display
   pDisplay = new Display(256, 256, 256, 256, 0, 0, 0, 0, scr256x256, 200);
   pColors = mcrestabootColors;
   BuildText(0xE000, 0xE050, 0xE160, 0xE120);

   // reset game
   Galax::Reset();
}

void MCrestaBoot::LoadScore()
{
   if (!ScoreLoaded && memcmp (pRAM + 0x8042, "\x00\x50\x00", 3) == 0 &&
      memcmp (pRAM + 0x83F9, "\x00\x50\x00", 3) == 0)
      {
      ReadScore(0x8042, 85);
      ScoreLoaded = 1;
      }
}

void MCrestaBoot::SaveScore()
{
   WriteScore(0x8042, 85);
}

BYTE MCrestaBootReadScores(WORD A)
{
   pMCrestaBoot->LoadScore();
   return pGame->RAM()[A];
}

int MCrestaBootROMSet(WORD A,  BYTE B)
{
	if (B) pMCrestaBoot->ROMSet |= (1 << (A-0xA000));
	else pMCrestaBoot->ROMSet &= ~(1 << (A-0xA000));
   pGame->RAM()[A] = B;
   return 0;
}




