#include <stdio.h>
#include "mtrap.h"

BYTE mtrapColors[] = 
{
   0x00, 0xC0, 0x38, 0xF8, 0x07, 0xC7, 0x3F, 0xFF,   
   0x00, 0xC0, 0x38, 0xF8, 0x07, 0xC7, 0x3F, 0xFF,   
   0x00, 0xC0, 0x38, 0xF8, 0x07, 0xC7, 0x3F, 0xFF,   
   0x00, 0xC0, 0x38, 0xF8, 0x07, 0xC7, 0x3F, 0xFF,   
   0x00, 0xC0, 0x38, 0xF8, 0x07, 0xC7, 0x3F, 0xFF   
};

ROMS mtrapRoms[] = 
{
   { 0xA000,  "mtl11a.bin", 4096, "" },
   { 0xB000,  "mtl10a.bin", 4096, "" },
   { 0xC000,  "mtl9a.bin",  4096, "" },
   { 0xD000,  "mtl8a.bin",  4096, "" },
   { 0xE000,  "mtl7a.bin",  4096, "" },
   { 0xF000,  "mtl6a.bin",  4096, "" },
   { 0x7000,  "mtl11d.bin", 2048, "graphics" },
   { 0, NULL, 0, NULL }	
};

ROMS mtrapSoundRoms[] = 
{
   { 0x6800, "mta5a.bin",   2048, "tables" },
   { 0x7000, "mta6a.bin",   2048, "tables" },
   { 0x7800, "mta7a.bin",   2048, "code" },
   { 0xF800, "mta7a.bin",   2048, "vectors" },
   { 0, NULL, 0, NULL }	
};

MemoryWrite MTrapWrite[] = 
{
   { 0x4000, 0x43FF, MTrapOut },
   { 0x4800, 0x4FFF, MTrapOut },
   { 0xFFFF, 0xFFFF, NULL }
};

MemoryRead MTrapRead[] = 
{
	{ 0x5100, 0x5101, ExidyReadPlayer },
	{ 0x5103, 0x5103, ExidyReadPlayer },
	{ 0x5200, 0x5203, ExidyReadPlayer },
	{ 0x5213, 0x5213, ExidyReadPlayer },
   { 0xFFFF, 0xFFFF, NULL }
};

MemoryWrite MTrapSoundWrite[] = 
{
   { 0xFFFF, 0xFFFF, NULL }
};

MemoryRead MTrapSoundRead[] = 
{
   { 0xFFFF, 0xFFFF, NULL }
};

MTrap * pMTrap;

MTrap::MTrap() : Exidy(mtrapRoms, mtrapSoundRoms, "mtrap")
{
   pMTrap = this;
   pProc6502->SetMemoryRW(MTrapWrite, MTrapRead, 10000, pRAM, 1);
   pProc6502->SetMemoryRW(MTrapSoundWrite, MTrapSoundRead, 10000, pAudioRAM, 2);

   strcpy(Name, "mtrap");
   strcpy(Descript, "Mouse Trap");

   Dipswitch->SetMen(5, 1, "5 Men", "4 Men", "3 Men", "Not Used");
}

MTrap::~MTrap()
{
}

void MTrap::Reset()
{
   pDisplay = new Display(256, 256, 256, 256, 0, 0, 0, 0, scr256x256, 200);
   pColors = mtrapColors;
   BuildText (0xA21E, 0xA2A6, 0xA20E, 0xA19E);

   Exidy::Reset();
}

void MTrap::Audio()
{
}

void MTrap::LoadScore()
{
}

void MTrap::SaveScore()
{
}

void MTrap::DetectCollision()
{
   // sprite collision
   if ((pGame->RAM()[0x5000] + 0x10 < pGame->RAM()[0x5080]) ||
      (pGame->RAM()[0x5000] > pGame->RAM()[0x5080] + 0x10) ||
      (pGame->RAM()[0x5040] + 0x10 < pGame->RAM()[0x50C0]) ||
      (pGame->RAM()[0x5040] > pGame->RAM()[0x50C0] + 0x10) ||
      (pGame->RAM()[0x5101]&0x40))
      pGame->RAM()[0x5103] &= 0xEF;
   else
      pGame->RAM()[0x5103] |= 0x10;

   // character collision
   if (pGame->RAM()[0x5000] == 0x78 && pGame->RAM()[0x5040] == 0x38)
      pGame->RAM()[0x5103] &= 0xFB;
   else
      pGame->RAM()[0x5103] |= 0x04;
}

int MTrapOut(WORD A,  BYTE B)
{
   if (A >= 0x4000 && A < 0x4400 && pGame->RAM()[A] != B)
      pExidy->Background()[A - 0x4000] = 1;
   else
      pExidy->Characters()[(A - 0x4800)>>3] = 1;

   pGame->RAM()[A] = B;
   return 0;
}

BYTE MTrapReadScores(WORD A)
{
   return 0;
}



