#ifndef __MAZE_H__
#define __MAZE_H__

/*
 *  MAZE (M)ulti (A)sm (Z)80 (E)ngine done by Ishmair (ishmair@vnet.es).
 *
 *  MAZE include file. Supplies necessary declarations to be able
 *  to use MAZE from a DJGPP environment.
 *
 *  created 19-03-1997.
 *  Allard van der Bas (avdbas@wi.leidenuniv.nl)
 *
 *  Visit http://valhalla.ph.tn.tudelft.nl/emul8 for the latest version of
 *  MAZE and for arcade emulation sources.
 */

#define byte	unsigned char
#define word	unsigned short

/* These functions are exported by MAZE */
#ifdef __cplusplus
extern "C" 
{
#endif

void MAZE();		/* Main routine */
void StdGetMem();	/* convenience function for a standard Read action */
void StdWriteMem();	/* convenience function for a standard Write action */
void StdDoNotWrite();	/* convenience function to protect ROM areas */
void StdForceNMI();	/* function to force an NMI */

/* The value returned by MAZE upon return */
extern int ErrorReport;

/* Two functions that can be used to specify reads and writes to remapped */
/* rom areas. (Don't know how to use them, see MAZE024.ASM for details.   */
void FixedGetMem();
void FixedWriteMem();

/* Structures for the variables maze expects the user to supply */
struct CPUtable {
		   void *ROMoffset;		/* Pointer to the CPU's rom base */
		   void *GetMemoffset;		/* Pointer to the CPU's Memory Read and Write Table */
		   int  Instructioncount;	/* Number of instructions to execute */
		   int  DebugMode;		/* Debug Mode, not implemented, so keep 0 */
		 };

struct CPUregisterset {
			word PC;
			word SP;
			word AF;
			word BC;
			word DE;
			word HL;
			word IX;
			word IY;
			word AFS;
			word BCS;
			word DES;
			word HLS;
			byte I;
			byte R;
			word ints;
			byte mode;
		};

/*
 *  NOTE : The following functions will have to be done is assembly.
 *  The Z80 engine calls these whenever an IN or OUT instruction is
 *  encountered. It does NOT save the CPU registers when calling these
 *  functions !
 */
void INPROCEDURE();
void OUTPROCEDURE();

/*
 *  The following procedure could be a hook for debugging purposes, the
 *  Z80 engine calls this one whenever it encounters a debug adress.
 *  CPU registers are NOT saved when it enters this routine !
 */
void Debug();

#ifdef __cplusplus
}
#endif

#endif
