#ifndef __PACGAMES_H__
#define __PACGAMES_H__

#include "game.h"
#include "procz80.h"

BYTE PacGamesTest(WORD A);
BYTE PacGamesReadPlayer0(WORD A);
BYTE PacGamesReadPlayer1(WORD A);
BYTE PacGamesReadDipSwitch(WORD A);
int PacGamesOut(WORD A,  BYTE B);

BYTE PacGamesInProc(WORD port);
void PacGamesOutProc(BYTE data, BYTE port);

class PacGames : public Game
{
private:
   BYTE BackBuffer[0x400];
   BYTE CharBuffer[0x100];
protected:
   ProcZ80 * pProcZ80;
   void * pRWTable[0x20000];
   virtual void Video();
   virtual void Audio();
   virtual void DrawCharacter(int c, int col, int row, BYTE color);
   virtual void DrawSprite (int c, int col, int row, BYTE color);
public:
   PacGames(ROMS *pR, char *path);
   virtual ~PacGames();
   virtual void Reset();
   virtual void Execute();
   virtual int  Interrupt();
   virtual void Load();
   virtual void Save();
   virtual void LoadScore();
   virtual void SaveScore();
   BYTE * Background() { return BackBuffer; };
   BYTE * Characters() { return CharBuffer; };
   IOPort * Player0;
   IOPort * Player1;
   DipSwitch * Dipswitch;
};

extern PacGames * pPacGames;

#endif

