#include <stdio.h>
#include <string.h>
#include "pisces.h"

Pisces * pPisces;

BYTE piscesColors[] = 
{
	0x00,0x00,0x00,0xF6,0x00,0x16,0xC0,0x3F,
	0x00,0xD8,0x07,0x3F,0x00,0xC0,0xC4,0x07,
	0x00,0xC0,0xA0,0x0C,0x00,0x00,0x00,0x07,
	0x00,0xF6,0x07,0xF0,0x00,0x76,0x07,0xC6
};

ROMS piscesRoms[] = 
{
   { 0x0000,  "pisces.a1", 0x0800, "code" },
   { 0x0800,  "pisces.a2", 0x0800, "code" },
   { 0x1000,  "pisces.b2", 0x0800, "code" },
   { 0x1800,  "pisces.c1", 0x0800, "code" },
   { 0x2000,  "pisces.d1", 0x0800, "code" },
   { 0x2800,  "pisces.e2", 0x0800, "code" },
   { 0xE000,  "pisces.1j", 0x1000, "graphics" },
   { 0xF000,  "pisces.1k", 0x1000, "graphics" },
   { 0, NULL, 0, NULL }	
};

MemoryWrite PiscesWrite[] = 
{
   { 0x5000, 0x53FF, GalaxOut },
   { 0x5800, 0x57FF, GalaxOut },
   { 0x6002, 0x6002, PiscesROMSet },
   { 0x6803, 0x6803, GalaxExplode },
   { 0x6805, 0x6805, GalaxShoot },
   { 0x7004, 0x7004, GalaxStarsEnable },
   { 0x7800, 0x7800, GalaxSound },
   { 0xFFFF, 0xFFFF, NULL }
};

MemoryRead PiscesRead[] = 
{
//   { 0x40A8, 0x40A8, GalaxianReadScores },
   { 0x6000, 0x6000, GalaxReadPlayer0 },
   { 0x6800, 0x6800, GalaxReadPlayer1 },
   { 0x7000, 0x7000, GalaxReadDipSwitch },
   { 0xFFFF, 0xFFFF, NULL }
};

Pisces::Pisces() : Galax (piscesRoms, "pisces")
{
   pPisces = this;

   pProcZ80->SetMemoryRW(PiscesWrite, PiscesRead, pRWTable, GalaxInProc,
      GalaxOutProc, 30000, pRAM, 1);

   // input ports
   Player0->SetKey(0, 0, 0, KEY_CONTROL, KEY_RIGHT, KEY_LEFT, KEY_3, KEY_4);
   Player0->SetJoy(0, 0, 0, JOY_BUTTON1, JOY_RIGHT, JOY_LEFT, 0, 0);
   Player1->SetMen(6, 0, "3 Ships", "4 Ships");
   pMenDSW = Player1;

   strcpy(Name, "pisces");
   strcpy(Descript, "Pisces");

   MemBase = 0x4000;
   MemSize = 0x3004;
   InterruptEnable = 0x7001;
   VideoAddress = 0x5000;
   AttributeAddress = 0x5800;
   BulletAddress = 0x5860;
   SpriteAddress = 0x5840;
   ROM1 = 0xE000;
   ROM2 = 0xF000;
}

Pisces::~Pisces()
{
}   

void Pisces::Reset()
{
   // setup the display
   pDisplay = new Display(256, 256, 256, 256, 0, 0, 0, 0, scr256x256, 200);
   pColors = piscesColors;
   BuildText(0xE000, 0xE088, 0xE080, 0xE080);

   // reset memory
   Galax::Reset();
   pProcZ80->EnableInterrupts(1, 0);
}

void Pisces::LoadScore()
{
   if (!ScoreLoaded && memcmp (pRAM + 0x8042, "\x00\x50\x00", 3) == 0 &&
      memcmp (pRAM + 0x83F9, "\x00\x50\x00", 3) == 0)
      {
      ReadScore(0x8042, 85);
      ScoreLoaded = 1;
      }
}

void Pisces::SaveScore()
{
   WriteScore(0x8042, 85);
}

int PiscesROMSet(WORD A,  BYTE B)
{
	pPisces->ROMSet = B & 1;
   pGame->RAM()[A] = B;
   return 0;
}


