#include <stdio.h>
#include "game.h"
#include "proc6502.h"

Proc6502::Proc6502(int count) : Processor(count)
{
   for (int i=0; i<count; i++)
      Context[i] = (CONTEXT *) malloc(m6502GetContextSize());
   CurrentCPU = 0;
}

void Proc6502::SetMemoryRW(MemoryWrite *pMW, MemoryRead *pMR, 
   int instructionCount, BYTE *pRam, int x)
{
   // setup emulation context
   Instructions[x-1] = instructionCount;
   Context[x-1]->m6502Base = pRam;
   Context[x-1]->m6502MemoryRead = pMR;
   Context[x-1]->m6502MemoryWrite = pMW;
   m6502SetContext(Context[x-1]);
   m6502reset();
   m6502GetContext(Context[x-1]);
}

Proc6502::~Proc6502()
{
   for (int i=0; i<Count; i++)
      free(Context[i]);
}

void Proc6502::Select(int x)
{
   if (CurrentCPU == x)
      return;

   if (CurrentCPU)
      Get(CurrentCPU);
   CurrentCPU = x;
   Set(CurrentCPU);
}

void Proc6502::Exec(int x)
{ 
   Select(x);
   m6502exec(Instructions[CurrentCPU-1]); 
}

void Proc6502::Load(FILE *fp)
{
   for (int i=0; i<Count; i++)
      {
      Select(i);
   	fread (&(Context[i]->m6502clockticks), 4, 1, fp);
	   fread (&(Context[i]->m6502pc), 4, 1, fp);
   	fread (&(Context[i]->m6502af), 4, 1, fp);
	   fread (&(Context[i]->m6502x), 4, 1, fp);
   	fread (&(Context[i]->m6502y), 4, 1, fp);
	   fread (&(Context[i]->m6502s), 4, 1, fp);
	   fread (&(Context[i]->syncCycle), 4, 1, fp);
      }
 	fread (&cyclesRemaining, 4, 1, fp);
}

void Proc6502::Save(FILE *fp)
{
   for (int i=0; i<Count; i++)
      {
      Select(i);
   	fwrite (&(Context[i]->m6502clockticks), 4, 1, fp);
	   fwrite (&(Context[i]->m6502pc), 4, 1, fp);
   	fwrite (&(Context[i]->m6502af), 4, 1, fp);
	   fwrite (&(Context[i]->m6502x), 4, 1, fp);
   	fwrite (&(Context[i]->m6502y), 4, 1, fp);
	   fwrite (&(Context[i]->m6502s), 4, 1, fp);
	   fwrite (&(Context[i]->syncCycle), 4, 1, fp);
      }
 	fwrite (&cyclesRemaining, 4, 1, fp);
}

