#ifndef __PROC6502_H__
#define __PROC6502_H__

#include "proc.h"

class Proc6502 : public Processor
{
private:
   CONTEXT * Context[3];
   int Instructions[3];
   int CurrentCPU;
protected:
   void Set(int x=1) { m6502SetContext(Context[x-1]); };
   void Get(int x=1) { m6502GetContext(Context[x-1]); };
public:
   Proc6502(int count=1);
   virtual ~Proc6502();
   void SetMemoryRW(MemoryWrite *pMW, MemoryRead *pMR, int instructionCount,
      BYTE *pRam, int x=1);
   CONTEXT * pContext(int x=1)
      { return Context[x-1]; };
   void NMI() { m6502nmi(); };
   void IRQ() { m6502int(); };
   void Exec(int x=1);
   void Reset(int x=1) { Set(x); m6502reset(); Get(x); };
   void Select(int x=1);
   DWORD Info() { return m6502GetInfo(); };
   void Load(FILE *fp);
   void Save(FILE *fp);
};

#endif

