#include <stdio.h>
#include "game.h"
#include "proc6809.h"

Proc6809::Proc6809(int count) : Processor(count)
{
   for (int i=0; i<count; i++)
      Context[i] = (CONTEXTM6809 *) malloc(m6809GetContextSize());
   CurrentCPU = 0;
}

void Proc6809::SetMemoryRW(MemoryWrite *pMW, MemoryRead *pMR, 
   int instructionCount, BYTE *pRam, int x)
{
   // setup emulation context
   Instructions[x-1] = instructionCount;
   Context[x-1]->m6809Base = pRam;
   Context[x-1]->m6809MemoryRead = (struct m6809MemoryRead *)pMR;
   Context[x-1]->m6809MemoryWrite = (struct m6809MemoryWrite *)pMW;
   m6809SetContext(Context[x-1]);
   m6809reset();
   m6809GetContext(Context[x-1]);
}

Proc6809::~Proc6809()
{
   for (int i=0; i<Count; i++)
      free(Context[i]);
}

void Proc6809::Select(int x)
{
   if (CurrentCPU == x)
      return;

   if (CurrentCPU)
      Get(CurrentCPU);
   CurrentCPU = x;
   Set(CurrentCPU);
}

void Proc6809::Exec(int x)
{ 
   Select(x);
   m6809exec(Instructions[CurrentCPU-1]); 
}

void Proc6809::Load(FILE *fp)
{
   for (int i=0; i<Count; i++)
      {
      Select(i);
   	fread (&(Context[i]->m6809clockticks), 4, 1, fp);
	   fread (&(Context[i]->m6809pc), 4, 1, fp);
   	fread (&(Context[i]->m6809u), 4, 1, fp);
	   fread (&(Context[i]->m6809x), 4, 1, fp);
   	fread (&(Context[i]->m6809y), 4, 1, fp);
	   fread (&(Context[i]->m6809s), 4, 1, fp);
   	fread (&(Context[i]->m6809b), 4, 1, fp);
   	fread (&(Context[i]->m6809a), 4, 1, fp);
   	fread (&(Context[i]->m6809cc), 4, 1, fp);
   	fread (&(Context[i]->m6809dp), 4, 1, fp);
	   fread (&(Context[i]->syncCycle), 4, 1, fp);
      }
 	fread (&m6809cyclesRemaining, 4, 1, fp);
}

void Proc6809::Save(FILE *fp)
{
   for (int i=0; i<Count; i++)
      {
      Select(i);
   	fwrite (&(Context[i]->m6809clockticks), 4, 1, fp);
	   fwrite (&(Context[i]->m6809pc), 4, 1, fp);
   	fwrite (&(Context[i]->m6809u), 4, 1, fp);
	   fwrite (&(Context[i]->m6809x), 4, 1, fp);
   	fwrite (&(Context[i]->m6809y), 4, 1, fp);
	   fwrite (&(Context[i]->m6809s), 4, 1, fp);
   	fwrite (&(Context[i]->m6809b), 4, 1, fp);
   	fwrite (&(Context[i]->m6809a), 4, 1, fp);
   	fwrite (&(Context[i]->m6809cc), 4, 1, fp);
   	fwrite (&(Context[i]->m6809dp), 4, 1, fp);
	   fwrite (&(Context[i]->syncCycle), 4, 1, fp);
      }
 	fwrite (&m6809cyclesRemaining, 4, 1, fp);
}

