#ifndef __PROC6809_H__
#define __PROC6809_H__

#include "m6809.h"
#include "proc.h"

class Proc6809 : public Processor
{
private:
   CONTEXTM6809 * Context[3];
   int Instructions[3];
   int CurrentCPU;
protected:
   void Set(int x=1) { m6809SetContext(Context[x-1]); };
   void Get(int x=1) { m6809GetContext(Context[x-1]); };
public:
   Proc6809(int count=1);
   virtual ~Proc6809();
   void SetMemoryRW(MemoryWrite *pMW, MemoryRead *pMR, int instructionCount,
      BYTE *pRam, int x=1);
   CONTEXTM6809 * pContext(int x=1)
      { return Context[x-1]; };
   void NMI() { m6809nmi(); };
   void IRQ() { m6809int(); };
   void Exec(int x=1);
   void Reset(int x=1) { Set(x); m6809reset(); Get(x); };
   void Select(int x=1);
   DWORD Info() { return m6809GetInfo(); };
   void Load(FILE *fp);
   void Save(FILE *fp);
};

#endif

