#include <stdio.h>
#include "game.h"
#include "procZ80.h"

CPUtable		   CPUSTABLE[4];		
CPUregisterset	CPUSREGISTERS[4];	
BYTE * ROM;


ProcZ80::ProcZ80(int count) : Processor(count)
{
   CurrentCPU = 0;
   for (int i=1; i<=count; i++)
      Reset(i);
}

ProcZ80::~ProcZ80()
{
}

void ProcZ80::Select(int x)
{
   // is this cpu current
   if (x == CurrentCPU)
      return;

   // save the current registers
   if (CurrentCPU)
      {
      memcpy(&(CPUSREGISTERS[CurrentCPU]), &(CPUSREGISTERS[0]), sizeof(CPUregisterset));
      memcpy(&(CPUSTABLE[CurrentCPU]), &(CPUSTABLE[0]), sizeof(CPUtable));
      }

   // load the new registers
   CurrentCPU = x;
   memcpy(&(CPUSREGISTERS[0]), &(CPUSREGISTERS[CurrentCPU]), sizeof(CPUregisterset));
   memcpy(&(CPUSTABLE[0]), &(CPUSTABLE[CurrentCPU]), sizeof(CPUtable));
}

void ProcZ80::SetMemoryRW(MemoryWrite *pMW, MemoryRead *pMR, 
   void **pReadWriteTable, BYTE (*In)(WORD), void (*Out)(BYTE, BYTE), 
   int instructionCount, BYTE *pRAM, int x)
{
   int i, j;

   for (i=0; i<0x10000; i++)
      {
      pReadWriteTable[i] = StdGetMem;
      pReadWriteTable[i+0x10000] = StdWriteMem;
      }

   while (pMR->memoryCall != NULL)
      {
      for (j=pMR->lowAddr; j<=pMR->highAddr; j++)
         pReadWriteTable[j] = pMR->memoryCall;
      pMR++;
      }
   while (pMW->memoryCall != NULL)
      {
      for (j=pMW->lowAddr; j<=pMW->highAddr; j++)
         pReadWriteTable[j+0x10000] = pMW->memoryCall;
      pMW++;
      }

	CPUSTABLE[x].ROMoffset = pRAM;
	CPUSTABLE[x].GetMemoffset = pReadWriteTable;
	CPUSTABLE[x].Instructioncount = instructionCount;
	CPUSTABLE[x].DebugMode = 0;      	
   CPUSTABLE[x].InProc = In;
   CPUSTABLE[x].OutProc = Out;
}

void ProcZ80::Reset(int x)
{
	CPUSREGISTERS[x].PC = 0;
	CPUSREGISTERS[x].SP = 0;
	CPUSREGISTERS[x].AF = 0;
	CPUSREGISTERS[x].BC = 0;
	CPUSREGISTERS[x].DE = 0;
	CPUSREGISTERS[x].HL = 0;
	CPUSREGISTERS[x].IX = 0;
	CPUSREGISTERS[x].IY = 0;
	CPUSREGISTERS[x].AFS = 0;
	CPUSREGISTERS[x].BCS = 0;
	CPUSREGISTERS[x].DES = 0;
	CPUSREGISTERS[x].HLS = 0;
	CPUSREGISTERS[x].I = 0;
	CPUSREGISTERS[x].R = 0;
	CPUSREGISTERS[x].ints = 0x0101; //All interrupts disabled
	CPUSREGISTERS[x].mode = 1;
}

WORD ProcZ80::PC()
{ 
   return CPUSREGISTERS[0].PC; 
}

void ProcZ80::SetInterruptMode(int x, int mode)
{
   CPUSREGISTERS[x].mode = mode;
   if (x == CurrentCPU)
      CPUSREGISTERS[0].mode = mode;
}

void ProcZ80::EnableInterrupts(int x, int on)
{
   CPUSREGISTERS[x].ints = (on?0x0101:0x0000);
   if (x == CurrentCPU)
      CPUSREGISTERS[0].ints = CPUSREGISTERS[x].ints;
}

void ProcZ80::Load(FILE *fp)
{
   fread(&CurrentCPU, 4, 1, fp);
   for (int i=0; i<=Count; i++)
      fread(&(CPUSREGISTERS[i]), sizeof(CPUregisterset), 1, fp);
}

void ProcZ80::Save(FILE *fp)
{
   fwrite(&CurrentCPU, 4, 1, fp);
   for (int i=0; i<=Count; i++)
      fwrite(&(CPUSREGISTERS[i]), sizeof(CPUregisterset), 1, fp);
}


