#ifndef __PROCZ80_H__
#define __PROCZ80_H__

#include "proc.h"

class ProcZ80 : public Processor
{
private:
protected:
   int CurrentCPU;
public:
   ProcZ80(int count=1);
   virtual ~ProcZ80();
   void SetMemoryRW(MemoryWrite *pMW, MemoryRead *pMR, 
      void **ReadWriteTable, BYTE (*In)(WORD), void (*Out)(BYTE, BYTE), 
      int instructionCount, BYTE *pRam, int x=1);
   void Reset(int x=1);
   void Select(int x=1);
   void Exec(int x=1) { Select(x); MAZE(); };
   void NMI() { StdForceNMI(); };
   void SetInterruptMode(int x, int mode=1);
   void EnableInterrupts(int x=1, int on=0);
   void Load(FILE *fp);
   void Save(FILE *fp);
   WORD PC();
};

#endif

