#include <stdio.h>
#include <string.h>
#include "qix.h"

Qix * pQix;

BYTE qixColors[] = 
{
   0x00, 0xC0, 0x07, 0xF6, 0x00, 0x17, 0x39, 0xF8,   
   0x00, 0x5E, 0xF6, 0x5C, 0x00, 0xC7, 0x39, 0x3F,   
   0x00, 0x3C, 0xF8, 0xD7, 0x00, 0x07, 0xF6, 0x39,   
   0x00, 0xC4, 0xC0, 0x07, 0x00, 0x07, 0x3F, 0xC4,   
   0x40, 0xC0, 0x07, 0xF6, 0x40, 0x17, 0x39, 0xF8,   
   0x40, 0x5E, 0xF6, 0x5C, 0x40, 0xC7, 0x39, 0x3F,   
   0x40, 0x3C, 0xF8, 0xD7, 0x40, 0x07, 0xF6, 0x39,   
   0x40, 0xC4, 0xC0, 0x07, 0x40, 0x07, 0x3F, 0xC4,   
};

ROMS qixRoms[] = 
{
   { 0xB000,  "u10", 0x0800, "graphics" },
   { 0xC000,  "u12", 0x0800, "code" },
   { 0xC800,  "u13", 0x0800, "code" },
   { 0xD000,  "u14", 0x0800, "code" },
   { 0xD800,  "u15", 0x0800, "code" },
   { 0xE000,  "u16", 0x0800, "code" },
   { 0xE800,  "u17", 0x0800, "code" },
   { 0xF000,  "u18", 0x0800, "code" },
   { 0xF800,  "u19", 0x0800, "code" },
   { 0, NULL, 0, NULL }	
};

ROMS qixVideoRoms[] = 
{
   { 0xC800,  "u4", 0x0800, "code" },
   { 0xD000,  "u5", 0x0800, "code" },
   { 0xD800,  "u6", 0x0800, "code" },
   { 0xE000,  "u7", 0x0800, "code" },
   { 0xE800,  "u8", 0x0800, "code" },
   { 0xF000,  "u9", 0x0800, "code" },
   { 0xF800,  "u10", 0x0800, "code" },
   { 0, NULL, 0, NULL }	
};

MemoryWrite QixWrite[] = 
{
//   { 0x8C00, 0x8C00, QixWriteVideoIrq },
   { 0xFFFF, 0xFFFF, NULL }
};

MemoryRead QixRead[] = 
{
//   { 0x9400, 0x9400, QixReadPlayer0 },
//   { 0x9402, 0x9402, QixReadPlayer1 },
   { 0xFFFF, 0xFFFF, NULL }
};

MemoryWrite QixVideoWrite[] = 
{
   { 0x0000, 0x7FFF, QixWriteVideo },
   { 0x8000, 0x83FF, QixWriteSharedMem },
   { 0x8800, 0x8800, QixWriteColor },
   { 0x8C00, 0x8C00, QixWriteDataIrq },
   { 0x9400, 0x9400, QixWriteLatch },
   { 0xFFFF, 0xFFFF, NULL }
};

MemoryRead QixVideoRead[] = 
{
   { 0x0000, 0x7FFF, QixReadVideo },
   { 0x8000, 0x83FF, QixReadSharedMem },
   { 0x86A9, 0x86A9, QixReadScores },
   { 0x9400, 0x9400, QixReadLatch },
   { 0x9800, 0x9800, QixReadScanLine },
   { 0xFFFF, 0xFFFF, NULL }
};

Qix::Qix() : Game (qixRoms, 0x10000, "qix")
{
   pQix = this;
   pProc6809 = new Proc6809(2);
   pProcessor = (Processor *) pProc6809;

   // setup audio hardware
   LoadAudio(qixVideoRoms, 0x10000);

   pProc6809->SetMemoryRW(QixWrite, QixRead, 30000, pRAM, 1);
   pProc6809->SetMemoryRW(QixVideoWrite, QixVideoRead, 30000, pAudioRAM, 2);

   strcpy(Name, "qix");
   strcpy(Descript, "Qix");

   // input ports
   Player0 = new IOPort(0x9400, 0xFF);
   Player0->SetKey(KEY_CONTROL, KEY_1, KEY_2, KEY_ALT, KEY_LEFT, KEY_DOWN, KEY_RIGHT, KEY_UP);
   Player0->SetJoy(JOY_BUTTON1, JOY_BUTTON3, JOY_BUTTON4, JOY_BUTTON2, 
      JOY_LEFT, JOY_DOWN, JOY_RIGHT, JOY_UP);
   Player1 = new DipSwitch(0x9402, 0xFF);
   Player1->SetKey(0, 0, KEY_4, KEY_3, 0, 0, 0, 0);

   pDisplay = 0;
}

Qix::~Qix()
{
   delete Player0;
   delete Player1;
   delete pProc6809;
   deleteDisplay(&pDisplay);
}   

void Qix::Reset()
{
   // reset memory
   Game::Reset();

   // setup the display
   pDisplay = new Display(256, 256, 256, 256, 0, 0, 0, 0, scr256x256, 200);
   pColors = qixColors;
   BuildText(0xB800, 0xB888, 0xB880, 0xB880);
   memset(Buffer, 0, 0x10000);

   // setup sound
   if (bSound)
      {
      }

   // reset the processors
   pProc6809->Reset(1);
   pProc6809->Reset(2);
}

void Qix::Execute()
{
   int rtn = INT_IRQ;

   // main execution loop
   while (rtn != INT_QUIT)
      {
      // main processor
      pProc6809->Exec(1);
      rtn = Interrupt();
      if (rtn == INT_IRQ)
         {
//         pProc6809->IRQ();
         }


      if(rtn != INT_QUIT)
         {
         // audio processor
//         pProc6809->Exec(2);
//         pProc6809->IRQ();
         }
      }

   // save the high score
   SaveScore();

   // close the display and audio
   deleteDisplay(&pDisplay);
}

int Qix::Interrupt()
{
   int rtn = INT_IRQ;

//   Video();
   if (bSound)
      Audio();

   if (Game::Interrupt() == INT_QUIT)
      rtn = INT_QUIT;

   pDisplay->Draw(); 

   return rtn;
}

void Qix::Video()
{
   pDisplay->Blit(pDisplay->Background(), pDisplay->Picture(), 0,0, 0,0, 
      pDisplay->gameWidth(), pDisplay->gameHeight());
}

void Qix::Audio()                     
{
}

void Qix::Load()                     
{
   char file[80];
   FILE *fp;
   sprintf (file, "%s\\%s.sav", Path, Name);
   fp = fopen (file, "rb");
   if (fp)
      {
      fread(pRAM+0x8000, 0x2000, 1, fp);
      fread(pAudioRAM+0x8000, 0x1000, 1, fp);
      pProc6809->Load(fp);
      fclose(fp);
      }
}

void Qix::Save()                     
{
   char file[80];
   FILE *fp;
   sprintf (file, "%s\\%s.sav", Path, Name);
   fp = fopen (file, "wb");
   if (fp)
      {
      fwrite(pRAM+0x8000, 0x2000, 1, fp);
      fwrite(pAudioRAM+0x8000, 0x1000, 1, fp);
      pProc6809->Save(fp);
      fclose(fp);
      }
}

void Qix::LoadScore()
{
   if (!ScoreLoaded && memcmp (pAudioRAM + 0x86A9, "\x55", 1) == 0)
      {
      ReadScore(0x8400, 0x400, 1);
      ScoreLoaded = 1;
      }
}

void Qix::SaveScore()
{
   WriteScore(0x8400, 0x400, 1);
}

BYTE QixReadPlayer0(WORD A)
{
   return pQix->Player0->Get();
}

BYTE QixReadPlayer1(WORD A)
{
   return pQix->Player1->Get();
}

BYTE QixReadScores(WORD A)
{
   pQix->LoadScore();
   return pGame->RAM()[A];
}

int QixWriteVideoIrq(WORD A, BYTE B)
{
   return 0;   
}

BYTE QixReadVideo(WORD A)
{
	if( pQix->pAudioRAM[0x9402] & 0x80 ) A += 0x8000;
	return pQix->Buffer[A];
}

BYTE QixReadSharedMem(WORD A)
{
   return pQix->pRAM[A];
}

BYTE QixReadLatch(WORD A)
{
	A = pQix->pAudioRAM[0x9402] << 8 | pQix->pAudioRAM[0x9403];
	return pQix->Buffer[A];
}

BYTE QixReadScanLine(WORD A)
{
	static BYTE temp = 0x00;
	
   temp = (!temp?0xFF:0);
	return temp;
}

int QixWriteVideo(WORD A,  BYTE B)
{
	if(pQix->pAudioRAM[0x9402] & 0x80) 
	   A += 0x8000;
	
	// bitmap is rotated -90 deg.
	int col = A >> 8;
	int row = A & 0xFF; row = ~row;

	pQix->pDisplay->SetPixel(row, col, pQix->pColors[B], pQix->pDisplay->Background());
	pQix->Buffer[A] = B;
   return 0;   
}

int QixWriteSharedMem(WORD A,  BYTE B)
{
   pQix->pRAM[A] = B;
   return 0;   
}

int QixWriteColor(WORD A,  BYTE B)
{
   return 0;
}

int QixWriteDataIrq(WORD A,  BYTE B)
{
   return 0;   
}

int QixWriteLatch(WORD A,  BYTE B)
{
	A = pQix->pAudioRAM[0x9402] << 8 | pQix->pAudioRAM[0x9403];
	
	// bitmap is rotated -90 deg. 
	int col = pQix->pAudioRAM[0x9402];
	int row = ~pQix->pAudioRAM[0x9403];

	pQix->pDisplay->SetPixel(row, col, pQix->pColors[B], pQix->pDisplay->Background());
	pQix->Buffer[A] = B;
   return 0;   
}





