#ifndef __QIX_H__
#define __QIX_H__

#include "game.h"
#include "proc6809.h"
#include "psg.h"

BYTE QixReadPlayer0(WORD A);
BYTE QixReadPlayer1(WORD A);
BYTE QixReadScores(WORD A);
int QixWriteVideoIrq(WORD A, BYTE B);

BYTE QixReadVideo(WORD A);
BYTE QixReadSharedMem(WORD A);
BYTE QixReadLatch(WORD A);
BYTE QixReadScanLine(WORD A);
int QixWriteVideo(WORD A,  BYTE B);
int QixWriteSharedMem(WORD A,  BYTE B);
int QixWriteColor(WORD A,  BYTE B);
int QixWriteDataIrq(WORD A,  BYTE B);
int QixWriteLatch(WORD A,  BYTE B);

class Qix : public Game
{
private:
protected:
   Proc6809 * pProc6809;
   BYTE Buffer[0x10000];
   virtual void Video();
   virtual void Audio();
   virtual void Load();
   virtual void Save();
   virtual void LoadScore();
   virtual void SaveScore();
public:
   Qix();
   virtual ~Qix();
   virtual void Reset();
   virtual void Execute();
   virtual int  Interrupt();
   IOPort * Player0;
   IOPort * Player1;

   // friend functions
   friend BYTE QixReadPlayer0(WORD A);
   friend BYTE QixReadPlayer1(WORD A);
   friend BYTE QixReadScores(WORD A);
   friend int QixWriteVideoIrq(WORD A, BYTE B);

   friend BYTE QixReadVideo(WORD A);
   friend BYTE QixReadSharedMem(WORD A);
   friend BYTE QixReadLatch(WORD A);
   friend BYTE QixReadScanLine(WORD A);
   friend int QixWriteVideo(WORD A,  BYTE B);
   friend int QixWriteSharedMem(WORD A,  BYTE B);
   friend int QixWriteColor(WORD A,  BYTE B);
   friend int QixWriteDataIrq(WORD A,  BYTE B);
   friend int QixWriteLatch(WORD A,  BYTE B);
};

extern Qix * pQix;

#endif

