#ifndef __ROCKOLA_H__
#define __ROCKOLA_H__

#include "game.h"
#include "audiodev.h"
#include "proc6502.h"

BYTE RockOlaReadPlayer(WORD A);
int RockOlaSpeechOut(WORD A, BYTE B);
void RockOlaAudioHandler(...);

class RockOla : public Game
{
private:
   Timer aTimer;
protected:
   WORD Coin;
   AudioDev *pAudioDev;
   Proc6502 *pProc6502;
   virtual void Video();
   virtual void DrawCharacter (int c, int col, int row, BYTE color);
   virtual void DrawSprite (int c, int col, int row, BYTE color);
   int ROM1, ROM2;
   int HScroll, VScroll;
   int LastPort[4];
   int ExplosionWave, Fire1Wave, Fire2Wave;
   int SoundOff;
   int NoSound[3];
   int Sound[3];
   int SoundBase[3];
   int oSoundBase[3];
public:
   RockOla(ROMS *pR, char *path);
   virtual ~RockOla();
   virtual void Reset();
   virtual void Execute();
   virtual int  Interrupt();
   virtual void Audio();
   virtual void Load();
   virtual void Save();
   int & PortValue(int x) { return LastPort[x]; };
   void CheckSoundReset(int voice);
   void CheckWave(BYTE data, BYTE bit, int port, int voice, int vol, int stopFlag);
   IOPort *Player0;
   IOPort *Player1;
   IOPort *CoinSlot;
   DipSwitch *Dipswitch;
};

extern RockOla * pRockOla;

#endif

