#ifndef __ROCKULTR_H__
#define __ROCKULTR_H__

#include <allegro.h>
#include <audio.h>
#include "display.h"
#include "keyboard.h"
#include "joystick.h"
#include "ioport.h"
#include "game.h"
#include "gui.h"

class VanguardButton : public Button
{
public:
   VanguardButton(int id, int x, int y, int w, int h, int color=7, int hcolor=15,
      int lcolor=8, GUIObject *parent=NULL);
   virtual ~VanguardButton() {};
   virtual void ClickHandler();
};

class FantasyButton : public Button
{
public:
   FantasyButton(int id, int x, int y, int w, int h, int color=7, int hcolor=15,
      int lcolor=8, GUIObject *parent=NULL);
   virtual ~FantasyButton() {};
   virtual void ClickHandler();
};

class NibblerButton : public Button
{
public:
   NibblerButton(int id, int x, int y, int w, int h, int color=7, int hcolor=15,
      int lcolor=8, GUIObject *parent=NULL);
   virtual ~NibblerButton() {};
   virtual void ClickHandler();
};

class FroggerButton : public Button
{
public:
   FroggerButton(int id, int x, int y, int w, int h, int color=7, int hcolor=15,
      int lcolor=8, GUIObject *parent=NULL);
   virtual ~FroggerButton() {};
   virtual void ClickHandler();
};

class VentureButton : public Button
{
public:
   VentureButton(int id, int x, int y, int w, int h, int color=7, int hcolor=15,
      int lcolor=8, GUIObject *parent=NULL);
   virtual ~VentureButton() {};
   virtual void ClickHandler();
};

class Pepper2Button : public Button
{
public:
   Pepper2Button(int id, int x, int y, int w, int h, int color=7, int hcolor=15,
      int lcolor=8, GUIObject *parent=NULL);
   virtual ~Pepper2Button() {};
   virtual void ClickHandler();
};

class MTrapButton : public Button
{
public:
   MTrapButton(int id, int x, int y, int w, int h, int color=7, int hcolor=15,
      int lcolor=8, GUIObject *parent=NULL);
   virtual ~MTrapButton() {};
   virtual void ClickHandler();
};

class GalaxianButton : public Button
{
public:
   GalaxianButton(int id, int x, int y, int w, int h, int color=7, int hcolor=15,
      int lcolor=8, GUIObject *parent=NULL);
   virtual ~GalaxianButton() {};
   virtual void ClickHandler();
};

class SuperGalButton : public Button
{
public:
   SuperGalButton(int id, int x, int y, int w, int h, int color=7, int hcolor=15,
      int lcolor=8, GUIObject *parent=NULL);
   virtual ~SuperGalButton() {};
   virtual void ClickHandler();
};

class MCrestaButton : public Button
{
public:
   MCrestaButton(int id, int x, int y, int w, int h, int color=7, int hcolor=15,
      int lcolor=8, GUIObject *parent=NULL);
   virtual ~MCrestaButton() {};
   virtual void ClickHandler();
};

class MCrestaBButton : public Button
{
public:
   MCrestaBButton(int id, int x, int y, int w, int h, int color=7, int hcolor=15,
      int lcolor=8, GUIObject *parent=NULL);
   virtual ~MCrestaBButton() {};
   virtual void ClickHandler();
};

class PiscesButton : public Button
{
public:
   PiscesButton(int id, int x, int y, int w, int h, int color=7, int hcolor=15,
      int lcolor=8, GUIObject *parent=NULL);
   virtual ~PiscesButton() {};
   virtual void ClickHandler();
};

class ScrambleButton : public Button
{
public:
   ScrambleButton(int id, int x, int y, int w, int h, int color=7, int hcolor=15,
      int lcolor=8, GUIObject *parent=NULL);
   virtual ~ScrambleButton() {};
   virtual void ClickHandler();
};

class SCobraButton : public Button
{
public:
   SCobraButton(int id, int x, int y, int w, int h, int color=7, int hcolor=15,
      int lcolor=8, GUIObject *parent=NULL);
   virtual ~SCobraButton() {};
   virtual void ClickHandler();
};

class TheEndButton : public Button
{
public:
   TheEndButton(int id, int x, int y, int w, int h, int color=7, int hcolor=15,
      int lcolor=8, GUIObject *parent=NULL);
   virtual ~TheEndButton() {};
   virtual void ClickHandler();
};

class StartButton : public Button
{
public:
   StartButton(int id, int x, int y, int w, int h, int color=7, int hcolor=15,
      int lcolor=8, GUIObject *parent=NULL);
   virtual ~StartButton() {};
   virtual void ClickHandler();
};

class CancelButton : public Button
{
public:
   CancelButton(int id, int x, int y, int w, int h, int color=7, int hcolor=15,
      int lcolor=8, GUIObject *parent=NULL);
   virtual ~CancelButton() {};
   virtual void ClickHandler();
};

class Desktop : public Box
{
   VanguardButton btnVanguard;
   FantasyButton  btnFantasy;
   NibblerButton  btnNibbler;
   VentureButton  btnVenture;
   Pepper2Button  btnPepper2;
   MTrapButton    btnMTrap;
   GalaxianButton btnGalaxian;
   SuperGalButton btnSuperGal;
   FroggerButton  btnFrogger;
   MCrestaButton  btnMCresta;
   MCrestaBButton btnMCrestaB;
   PiscesButton   btnPisces;
   ScrambleButton btnScramble;
   SCobraButton   btnSCobra;
   TheEndButton   btnTheEnd;
public:
   Desktop(int id, int x, int y, int w, int h, int color);
   virtual ~Desktop() {};
   void SetOptions(char *desc=NULL);
};

class MainWindow : public Window
{
   GroupBox    soundGrp;
   RadioButton btnAutoSound;
   RadioButton btnSB;
   RadioButton btnNoSound;
   GroupBox    menGrp;
   RadioButton btnMen1;
   RadioButton btnMen2;
   RadioButton btnMen3;
   RadioButton btnMen4;
   GroupBox    bonusGrp;
   RadioButton btnBonus1;
   RadioButton btnBonus2;
   RadioButton btnBonus3;
   RadioButton btnBonus4;
   GroupBox    coinsGrp;
   RadioButton btnCoins1;
   RadioButton btnCoins2;
   RadioButton btnCoins3;
   RadioButton btnCoins4;
   GroupBox    levelGrp;
   RadioButton btnLevel1;
   RadioButton btnLevel2;
   RadioButton btnLevel3;
   RadioButton btnLevel4;
   GroupBox    extraGrp;
   RadioButton btnExtra1;
   RadioButton btnExtra2;
   RadioButton btnExtra3;
   RadioButton btnExtra4;
   CheckBox    btnJoy;
   CheckBox    btnThrottle;
   StartButton btnStart;
   CancelButton btnCancel;
public:
   MainWindow(int id, int x, int y, int w, int h);
   virtual ~MainWindow() {};
   void SetOptions();
   void SelectOptions();
   void Update();
   int ExitFlag;
};

#endif



                 
