#ifndef __SAMPLE_H__
#define __SAMPLE_H__

#include "game.h"
#include "ioport.h"
#include "procz80.h"
#include "audiodev.h"

// declare any callback functions - assembly functions don't like calling
// back to class member functions :(
BYTE SampleGameReadPlayer0(WORD A);
BYTE SampleGameReadPlayer1(WORD A);
BYTE SampleGameReadDipSwitch(WORD A);
BYTE SampleGameReadScores(WORD A);
int SampleGameVideoOut(WORD A,  BYTE B);
BYTE SampleGameInProc(WORD port);
void SampleGameOutProc(BYTE data, BYTE port);

// a sample game class
class SampleGame
{
private:
   IOPort *    Player0;    // an i/o port
   IOPort *    Player1;    // an i/o port
   DipSwitch * Dipswitch;  // a dipswitch
   ProcZ80 *   pProcZ80;   // sample uses a Z80 processor
   AudioDev *  pAudioDev;  // sample uses generic audio
   BYTE BackBuffer[0x400]; // video ram invalidation buffer
protected:
   void Video();           // all member functions here must be defined
   void Audio();           // (you can add any others you like)
   void Load();
   void Save();
public:
   SampleGame();
   virtual ~SampleGame();
   void Reset();
   void Execute();
   void LoadScore();
   void SaveScore();
   int  Interrupt();

   // declare any friend functions
   friend BYTE SampleGameReadPlayer0(WORD A);
   friend BYTE SampleGameReadPlayer1(WORD A);
   friend BYTE SampleGameReadDipSwitch(WORD A);
   friend BYTE SampleGameReadScores(WORD A);
   friend int SampleGameVideoOut(WORD A,  BYTE B);
   friend BYTE SampleGameInProc(WORD port);
   friend void SampleGameOutProc(BYTE data, BYTE port);
};

extern SampleGame * pSampleGame;

#endif
