#ifndef __SCRAMBASE_H__
#define __SCRAMBASE_H__

#include "game.h"
#include "procz80.h"
#include "psg.h"

BYTE ScrambleTest(WORD A);
BYTE ScrambleReadPlayer0(WORD A);
BYTE ScrambleReadPlayer1(WORD A);
BYTE ScrambleReadDipSwitch(WORD A);
BYTE ScrambleReadScores(WORD A);
BYTE ScrambleSecurity(WORD A);
int ScrambleOut(WORD A,  BYTE B);
int ScrambleIntEnable(WORD A,  BYTE B);
int ScrambleSoundCommand(WORD A,  BYTE B);
int ScrambleStars(WORD A,  BYTE B);

BYTE ScrambleInProc(WORD port);
void ScrambleOutProc(BYTE data, BYTE port);
BYTE ScrambleAudioInProc(WORD port);
void ScrambleAudioOutProc(BYTE data, BYTE port);

const int SCRAMBLE_MAX_STARS = 250;

class ScramBase : public Game
{
private:
protected:
   int bStars;
   int StarCount;
   int StarsBlink;
	int BlinkCount;
   int ShotDir;
   WORD SaveRAMStart;
   WORD SaveRAMSize;
   WORD VideoAddress;
   WORD SpriteAddress;
   WORD IntEnableAddress;
   BYTE StarX[SCRAMBLE_MAX_STARS];
   BYTE StarY[SCRAMBLE_MAX_STARS];
   BYTE StarColor[SCRAMBLE_MAX_STARS];
   BYTE StarCode[SCRAMBLE_MAX_STARS];
   BYTE BackBuffer[0x400];
   BYTE CharBuffer[0x100];
   ProcZ80 * pProcZ80;
   void * pRWTable[0x20000];
   void * pAudioRWTable[0x20000];
   AYPSG * pAYPSG;
   virtual void Video();
   virtual void Audio();
   virtual void DrawCharacter(int c, int col, int row, BYTE color);
   virtual void DrawSprite (WORD off);
   void SetupStars(void);
public:
   ScramBase(ROMS *roms, ROMS *audioRoms, char *path);
   virtual ~ScramBase();
   virtual void Reset();
   virtual void Execute();
   virtual int  Interrupt();
   virtual void Load();
   virtual void Save();
   virtual void LoadScore();
   virtual void SaveScore();
   BYTE * Background() { return BackBuffer; };
   BYTE * Characters() { return CharBuffer; };
   IOPort * Player0;
   DipSwitch * Player1;
   DipSwitch * Dipswitch;
   friend int ScrambleOut(WORD A,  BYTE B);
   friend int ScrambleStars(WORD A,  BYTE B);
   friend int ScrambleIntEnable(WORD A,  BYTE B);
   friend BYTE ScrambleReadDipSwitch(WORD A);
};

extern ScramBase * pScramble;

class Scramble : public ScramBase
{
public:
   Scramble();
   ~Scramble() {};
};

class Atlantis : public ScramBase
{
public:
   Atlantis();
   ~Atlantis() {};
};

class TheEnd : public ScramBase
{
public:
   TheEnd();
   ~TheEnd() {};
};

class SCobra : public ScramBase
{
public:
   SCobra();
   ~SCobra() {};
};

#endif

