#include <stdio.h>
#include <string.h>
#include "supergal.h"

SuperGalaxian * pSuperGalaxian;

BYTE superGalaxianColors[] = 
{
	0x00,0x00,0x00,0xF6,0x00,0x16,0xC0,0x3F,
	0x00,0xD8,0x07,0x3F,0x00,0xC0,0xC4,0x07,
	0x00,0xC0,0xA0,0x0C,0x00,0x00,0x00,0x07,
	0x00,0xF6,0x07,0xF0,0x00,0x76,0x07,0xC6
};

ROMS superGalaxianRoms[] = 
{
   { 0x0000,  "galaxian.u", 0x0800, "code" },
   { 0x0800,  "galaxian.v", 0x0800, "code" },
   { 0x1000,  "galaxian.w", 0x0800, "code" },
   { 0x1800,  "galaxian.y", 0x0800, "code" },
   { 0x2000,  "galaxian.z", 0x0800, "code" },
   { 0xE000,  "galaxian.1h", 0x0800, "graphics" },
   { 0xE800,  "galaxian.1k", 0x0800, "graphics" },
   { 0, NULL, 0, NULL }	
};

MemoryWrite SuperGalaxianWrite[] = 
{
   { 0x5000, 0x53FF, GalaxOut },
   { 0x5800, 0x57FF, GalaxOut },
   { 0x6803, 0x6803, GalaxExplode },
   { 0x6805, 0x6805, GalaxShoot },
   { 0x7004, 0x7004, GalaxStarsEnable },
   { 0x7800, 0x7800, GalaxSound },
   { 0xFFFF, 0xFFFF, NULL }
};

MemoryRead SuperGalaxianRead[] = 
{
//   { 0x40A8, 0x40A8, GalaxianReadScores },
   { 0x6000, 0x6000, GalaxReadPlayer0 },
   { 0x6800, 0x6800, GalaxReadPlayer1 },
   { 0x7000, 0x7000, GalaxReadDipSwitch },
   { 0xFFFF, 0xFFFF, NULL }
};

SuperGalaxian::SuperGalaxian() : Galax (superGalaxianRoms, "supergal")
{
   pSuperGalaxian = this;

   pProcZ80->SetMemoryRW(SuperGalaxianWrite, SuperGalaxianRead, pRWTable, GalaxInProc,
      GalaxOutProc, 30000, pRAM, 1);

   // input ports
   Player0->SetKey(0, 0, 0, KEY_CONTROL, KEY_RIGHT, KEY_LEFT, KEY_3, KEY_4);
   Player0->SetJoy(0, 0, 0, JOY_BUTTON1, JOY_RIGHT, JOY_LEFT, 0, 0);
   Dipswitch->SetBonus(0, 0, "7000 Points", "10000 Points", "12000 Points", "20000 Points");
   Dipswitch->SetMen(2, 0, "3 Ships", "5 Ships");

   strcpy(Name, "supergal");
   strcpy(Descript, "Super Galaxian");

   MemBase = 0x4000;
   MemSize = 0x3004;
   InterruptEnable = 0x7001;
   VideoAddress = 0x5000;
   AttributeAddress = 0x5800;
   BulletAddress = 0x5860;
   SpriteAddress = 0x5840;
   ROM1 = 0xE000;
   ROM2 = 0xE800;

   pBonusDSW = Dipswitch;
   pMenDSW = Dipswitch;
}

SuperGalaxian::~SuperGalaxian()
{
}   

void SuperGalaxian::Reset()
{
   // setup the display
   pDisplay = new Display(256, 256, 256, 256, 0, 0, 0, 0, scr256x256, 200);
   pColors = superGalaxianColors;
   BuildText(0xE000, 0xE088, 0xE080, 0xE080);

   // reset memory
   Galax::Reset();
}

void SuperGalaxian::LoadScore()
{
   if (!ScoreLoaded && memcmp (pRAM + 0x8042, "\x00\x50\x00", 3) == 0 &&
      memcmp (pRAM + 0x83F9, "\x00\x50\x00", 3) == 0)
      {
      ReadScore(0x8042, 85);
      ScoreLoaded = 1;
      }
}

void SuperGalaxian::SaveScore()
{
   WriteScore(0x8042, 85);
}


