#include <stdio.h>
#include "vanguard.h"

BYTE vanguardColors[] = 
{
   0x00, 0x80, 0x3F, 0xC6, 0xEF, 0xC6, 0x2F, 0xF8, 
   0xFE, 0xC6, 0xE7, 0xC0, 0xFF, 0x2F, 0x38, 0xC6, 
   0x00, 0x07, 0x80, 0x2F, 0xEF, 0x07, 0xF8, 0xFF, 
   0xFE, 0xFF, 0xF8, 0xC0, 0xFF, 0xE7, 0xC6, 0xF4, 
   0x00, 0x2F, 0xF4, 0xFF, 0xEF, 0xF8, 0xFF, 0x07, 
   0xFE, 0xC0, 0x07, 0x3F, 0xFF, 0x3F, 0xC6, 0xC0, 
   0x00, 0x38, 0xE7, 0x07, 0xEF, 0xC0, 0xF4, 0xFF, 
   0xFE, 0xFF, 0xF8, 0xC0, 0xFF, 0xC6, 0xE7, 0xC0
};

ROMS vanguardRoms[] = 
{
   { 0x2000, "sk5_ic50.bin", 2048, "background character graphics - plane 1" },
   { 0x2800, "sk5_ic51.bin", 2048, "background character graphics - plane 2" },
   { 0x4000, "sk4_ic07.bin", 4096, "code" },
   { 0x5000, "sk4_ic08.bin", 4096, "code" },
   { 0x6000, "sk4_ic09.bin", 4096, "code" },
   { 0x7000, "sk4_ic10.bin", 4096, "code, sprite graphics, tables" },
   { 0x8000, "sk4_ic13.bin", 4096, "foreground character graphics" },
   { 0x9000, "sk4_ic14.bin", 4096, "tables (sound?)" },
   { 0xA000, "sk4_ic15.bin", 4096, "more tables?" },
   { 0xB000, "sk4_ic16.bin", 4096, "data (1K), code" },
   { 0xC000, "sk4_ic51.bin", 2048, "sound - part 1" },
   { 0xC800, "sk4_ic52.bin", 2048, "sound - part 2" },
   { 0xF000, "sk4_ic13.bin", 4096, "vectors" },
   { 0, NULL, 0, NULL }	                    
};

MemoryWrite VanguardWrite[] = 
{
   { 0x3100, 0x3103, VanguardOut }, 
   { 0x3400, 0x3400, RockOlaSpeechOut }, 
   { 0xFFFF, 0xFFFF, NULL }
};

MemoryRead VanguardRead[] = 
{
   { 0x3104, 0x3107, RockOlaReadPlayer },
   { 0x0220, 0x0220, VanguardReadScores },
   { 0xFFFF, 0xFFFF, NULL }
};

Vanguard * pVanguard;

Vanguard::Vanguard() : RockOla(vanguardRoms, "vanguard")
{
   pVanguard = this;
   pProc6502->SetMemoryRW(VanguardWrite, VanguardRead, 12000, pRAM);

   strcpy(Name, "vanguard");
   strcpy(Descript, "Vanguard");

   Sound[0] = SoundBase[0] = oSoundBase[0] = 0xC000;
   Sound[1] = SoundBase[1] = oSoundBase[1] = 0xC800;
   Coin = 0x3107;
   Dipswitch->SetMen(4, 1, "3 Ships", "4 Ships", "5 Ships", "Not Used");

   ROM1 = 0x2000;
   ROM2 = 0x2800;
   VScroll = 0x3200;
   HScroll = 0x3300;
}

Vanguard::~Vanguard()
{
}

void Vanguard::Reset()
{
   // reset the display
   pDisplay = new Display(224, 256, 224, 256, 32, 0, 0, 0, scr224x256, 200);
   pColors = vanguardColors;
   BuildText (0x8000, 0x8050, 0x8130, 0x8180);

   RockOla::Reset();
}

void Vanguard::LoadScore()
{
   if (!ScoreLoaded && memcmp (pRAM + 0x22B, "\x00\x10\x00", 3) == 0 &&
      memcmp (pRAM + 0x25, "\x00\x10\x00", 3) == 0)
      {
      ReadScore(0x220, 0x70);
      ScoreLoaded = 1;
      }
}

void Vanguard::SaveScore()
{
   WriteScore(0x220, 0x70);
}

int VanguardOut(WORD A, BYTE B)
{
   switch (A & 0x03)
      {
      // port 0
      case 0:
         if (pGame->Sound())                                                
            {
            pVanguard->SoundBase[0] = ((B & 0x07) << 8) + 0xC000;
            pVanguard->CheckSoundReset(0);
            pVanguard->CheckWave(B, 0x20, 0, pVanguard->Fire1Wave, 64, TRUE);
            pVanguard->CheckWave(B, 0x40, 0, pVanguard->Fire2Wave, 64, TRUE);
            pVanguard->CheckWave(B, 0x80, 0, pVanguard->ExplosionWave, 64, FALSE);
      
            if (B & 0x10)
               pVanguard->NoSound[0] = FALSE;

            if (B & 0x08)
               pVanguard->NoSound[0] = TRUE;
            }

         pVanguard->LastPort[0] = B;
         break;

      // port 1
      case 1:
         if (pGame->Sound())                                                
            {
            pVanguard->SoundBase[1] = ((B & 0x07) << 8) + 0xC800;
            pVanguard->CheckSoundReset(1);
            
            if (B & 0x08)
               pVanguard->NoSound[1] = FALSE;
            else
               pVanguard->NoSound[1] = TRUE;
            }

         pVanguard->LastPort[1] = B;
         break;

      // port 2
      case 2:
         pVanguard->LastPort[2] = B;
         break;

      // port 3
      case 3:
       	pVanguard->LastPort[3] = B;
         break;
      }

   pGame->RAM()[A] = B;
   return 0;
}

BYTE VanguardReadScores(WORD A)
{
   pVanguard->LoadScore();
   return pGame->RAM()[A];
}


