/*
C-callable:
void xblast(BITMAP *source, int, width, int x);
void xblit(BITMAP *source, BITMAP *dest, int source_x, int source_y, 
	   int dest_x, int dest_y, int width, int height, int topline); 
*/

   .extern _core_select;

   .globl _xblast
   .align 4
_xblast:
   pushl %ebp
   movl  %esp, %ebp
   pushl  %esi
   pushl  %edi
   pushl  %ebx
   pushw  %es
   
   movw _core_select,%bx	
   movw %bx,%es
   movl 16(%ebp), %eax 
   movl $0xa0000, %eax
   movl %eax, %edi         /* dest in es:edi */

   movl 12(%ebp), %edx
   shrl $2, %edx

   movl $0, %ebx
   movl 8(%ebp), %esi      /* source in ds:esi */
   movl 56(%esi, %ebx, 4), %esi
   mov  $256, %ebx

BlastLoop:
   addl 16(%ebp), %esi     
   movl %edx, %ecx
   rep
   movsl

   addl 16(%ebp), %edi 
   decl %ebx
   jnz  BlastLoop

   popw %es
   popl %ebx
   popl %edi
   popl %esi
   movl %ebp, %esp
   popl %ebp
   ret

.globl _xblit
   .align 4
_xblit:
   pushl %ebp 
   movl %esp, %ebp 
   subl $12, %esp                /* temp storage for height, source_y and dest_y */

   pushl %ebx
   pushl %esi
   pushl %edi
   pushw %es

   movl $0x3C4, %edx             /* load port address into edx */
   movl 12(%ebp), %eax
   movw 52(%eax), %es            /* load segment selector */
   cld

   movl 36(%ebp), %ecx           /* store height */
   movl %ecx, -4(%ebp)           
   movl 20(%ebp), %ecx           /* store source_y */
   movl %ecx, -8(%ebp)           
   movl 28(%ebp), %ecx           /* store dest_y */  
   movl %ecx, -12(%ebp)          

   movl 24(%ebp), %eax           /* divide dest_x by number of planes */
   shrl $2, %eax
   movl %eax, 24(%ebp)
   movl 32(%ebp), %eax           /* divide width by number of planes */
   shrl $4, %eax
   movl %eax, 32(%ebp)

   movl $0x1102, %eax
   xorl %ebx, %ebx               /* ebx = plane counter */ 

   .align 4, 0x90
x_blit_from_mem_plane_loop:      /* for each plane... */

   outw %ax, %dx                 /* select the write plane */

x_blit_from_mem_y_loop:          /* for each line... */

   movl 12(%ebp), %esi 
   movl 28(%ebp), %ecx
   movl 56(%esi, %ecx, 4), %ecx
   addl 24(%ebp), %ecx
   movl %ecx, %edi               /* dest line data in es:edi */

   movl 8(%ebp), %esi 
   movl 20(%ebp), %ecx
   movl 56(%esi, %ecx, 4), %ecx
   movl %ecx, %esi               
   movl %ebx, %ecx
   shll $6, %ecx
   addl %ecx, %esi
   movl 16(%ebp), %ecx
   shrl $2, %ecx
   addl %ecx, %esi               /* source line data in ds:esi */

   movl 32(%ebp), %ecx           /* copy pixels per row per plane */
   rep
   movsl

   incl 20(%ebp)                 
   incl 28(%ebp)
   decl 36(%ebp)
   jg x_blit_from_mem_y_loop     /* loop if more rows to blit*/

   movl -12(%ebp), %ecx          /* restore dest_y, source_y and height */
   movl %ecx, 28(%ebp)
   movl -8(%ebp), %ecx
   movl %ecx, 20(%ebp)
   movl -4(%ebp), %ecx
   movl %ecx, 36(%ebp) 
   rolb $1, %ah                  /* advance the plane position */
   incl %ebx                     /* next plane */
   cmpl $4, %ebx
   jl x_blit_from_mem_plane_loop

   movl 40(%ebp), %eax           /* now display at top line */
   movl 12(%ebp), %esi 
   movl 56(%esi, %eax, 4), %eax
   movb $0x0D, %bl
   movb %al, %bh                       
   movb $0x0C, %cl
   movb %ah, %ch
/* Set the start offset in display memory of the page to display. */
   movw $0x3D4, %dx
   movw %bx, %ax
   outw %ax, %dx
   movw %cx, %ax
   outw %ax, %dx
/* Now poll vertical sync */
   movw $0x3DA, %dx
   inb  %dx, %al

   popw %es
   popl %edi
   popl %esi
   popl %ebx
   movl %ebp, %esp
   popl %ebp 
   ret                           /* end of _xblit() */


