/* (C)2013 Gabor Lenart LGB http://ep.lgb.hu/jsep/
 * Low-featured Dave emulation for the JavaScript Enterprise-128 emulator.
 * Keyboard is not handled here but in keyboard.js
 * Preliminary sound with DA mode only, without buffer under/overflow check :(
 * Dave "ticks" is 250KHz frequency used by Dave counters (or /1.5 if
 * it is set with bit 1 of port 0xBF). The emulation is
 * not accurate (by design): counters etc are only checked after executing
 * enough opcodes to fit (or cross) the time boundary of a nick slot.
 */

"use strict";

var TG_INT_NOT_SUPPORTED = false;

var daveInterruptR, daveInterruptW;
var dave50HZCounter, dave1HZCounter, dave1KHZCounter, daveTG0Counter, daveTG1Counter, daveTG2Counter, dave31KHZCounter;

var SOUND_BUFFER_SIZE = 4096; // for easier usage, must be power of two!

var NICK_SLOTS_PER_DAVE_TICK_LO, NICK_SLOTS_PER_DAVE_TICK_HI;

var NICK_SLOTS_PER_AUDIO_SAMPLE;

//var daveInterruptR = 0;// reading port B4 will give this. Main emulator loop will check all the latches and raise Z80 interrupt when any is set (mask: 0xAA) in enterprise.js
//var daveInterruptW = 0; // writing port B4 should write this (not directly please, via daveConfigureInterrupts() as resetting latches in daveInterruptR is needed too!)


function daveReset() {
	pageBases[0] = 0; pageBases[1] = 0; pageBases[2] = 0; pageBases[3] = 0;
	port[0xB0] = 0; port[0xB1] = 0; port[0xB2] = 0; port[0xB3] = 0;
	daveInterruptR = 0; // reading port B4 will give this. Main emulator loop will check all the latches and raise Z80 interrupt when any is set (mask: 0xAA) in enterprise.js
	daveInterruptW = 0; // writing port B4 should write this (not directly please, via daveConfigureInterrupts() as resetting latches in daveInterruptR is needed too!)
	dave1HZCounter = 0;
	dave50HZCounter = 0;
	dave1KHZCounter = 0;
	daveTG0Counter = 0;
	daveTG1Counter = 0;
	daveTG2Counter = 0;
	dave31KHZCounter = 0;
	NICK_SLOTS_PER_DAVE_TICK_HI = NICK_SLOTS_PER_SEC / 250000;
	NICK_SLOTS_PER_DAVE_TICK_LO = NICK_SLOTS_PER_DAVE_TICK_HI * 1.5;
	NICK_SLOTS_PER_DAVE_TICK = NICK_SLOTS_PER_DAVE_TICK_HI;
	debug("Dave got reset; nick slots per dave tick = " + NICK_SLOTS_PER_DAVE_TICK_HI);
}


/* this must be used for writing port B4! */
function daveConfigureInterrupts(n) {
	if (TG_INT_NOT_SUPPORTED && (n & 1) && (!(daveInterruptW & 1)))
		enterpriseEmergencyReset("TG/1KHz/50Hz interrupt is to be enabled, but it is not implemented yet!");
	daveInterruptW = n;
	// TODO/FIXME: disabling an interrupt casues latch to be cleared without clear latch too????
	daveInterruptR &= (0x55 | ((~n) & 0xAA)); // this "nice" stuff resets desired latches
	daveInterruptR &= (0x55 | ((n << 1) & 0xAA)); // this is the TODO/FIXME probably ...
}


/* Edge triggered input from Nick's VINT. This is called from nick.js
 * Note: it seems we have a surprise: This interrupt source (with the
 * unused INT2 too btw) is falling edge triggered!!!! [thanks to IstvanV] */
function daveSetINT1(active) {
	if (active) {
		daveInterruptR |= 16; // set level
	} else {
		// the truth is here, if previous level was set (falling edge), and int1 is enabled, then set latch!
		if ((daveInterruptR & 16) && (daveInterruptW & 16))
			daveInterruptR |= 32; // set latch
		daveInterruptR &= 239; // reset level
	}
}



/*function daveCounter2Ticks(bport) {
	return (((port[bport] | ((port[bport + 1] & 15) << 8)) + 1) * NICK_SLOTS_PER_SEC) / 250000.0;
}*/


/* this is called by daveTick() based on the selected counter */
function daveTGInterrupt() {
	if (daveInterruptW & 1)
		daveInterruptR |= 2; // set latch if TG int is enabled
	daveInterruptR ^= 1; // negate level
}


var daveAudioBufferL1 = new Float32Array(SOUND_BUFFER_SIZE);
var daveAudioBufferR1 = new Float32Array(SOUND_BUFFER_SIZE);
var daveAudioBufferL2 = new Float32Array(SOUND_BUFFER_SIZE);
var daveAudioBufferR2 = new Float32Array(SOUND_BUFFER_SIZE);
var daveAudioBufferLPlay = daveAudioBufferL1;
var daveAudioBufferRPlay = daveAudioBufferR1;
var daveAudioBufferLRec = daveAudioBufferL2;
var daveAudioBufferRRec = daveAudioBufferR2;
var daveAudioBufferWPos = 0;
var daveAudioBufferRPos = 0;
var SOUND_BUFFER_SIZE_MASK = SOUND_BUFFER_SIZE - 1;
var daveTG0State = 0, daveTG1State = 0, daveTG2State = 0;

function daveTick() {
	/* besides the name, it's 31.25KHz - NOTE, currently it is not used and maybe double freq is needed, anyway! I will examine this later, this
	 * code fragment is just a reminder for myself. */
	if ((--dave31KHZCounter) < 0) {
		dave31KHZCounter = 8 - 1;
	}
	/* 50Hz counter */
	if ((--dave50HZCounter) < 0) {
		dave50HZCounter = 5000 - 1;
		if (port[0xA7] & 96 == 32) daveTGInterrupt();
	}
	/* 1KHz counter */
	if ((--dave1KHZCounter) < 0) {
		dave1KHZCounter = 250 - 1;
		if (port[0xA7] & 96 ==  0) daveTGInterrupt();
	}
	/* counter for tone channel #0 */
	if (port[0xA7] & 1) { // sync mode?
		daveTG0Counter = port[0xA0] | ((port[0xA1] & 15) << 8);
		daveTG0State = 0;
	} else if ((--daveTG0Counter) < 0) {
		daveTG0Counter = port[0xA0] | ((port[0xA1] & 15) << 8);
		daveTG0State ^= 1;
		if (port[0xA7] & 96 == 64) daveTGInterrupt();
	}
	/* counter for tone channel #1 */
	if (port[0xA7] & 2) { // sync mode?
		daveTG1Counter = port[0xA2] | ((port[0xA3] & 15) << 8);
		daveTG1State = 0;
	} else if ((--daveTG1Counter) < 0) {
		daveTG1Counter = port[0xA2] | ((port[0xA3] & 15) << 8);
		daveTG1State ^= 1;
		if (port[0xA7] & 96 == 96) daveTGInterrupt();
	}
	/* counter for tone channel #2 */
	if (port[0xA7] & 4) { // sync mode?
		daveTG2Counter = port[0xA4] | ((port[0xA5] & 15) << 8);
		daveTG2State = 0;
	} else if ((--daveTG2Counter) < 0) {
		daveTG2Counter = port[0xA4] | ((port[0xA5] & 15) << 8);
		daveTG2State ^= 1;
	}
	/* handling the 1Hz interrupt */
	if ((--dave1HZCounter) < 0) {
		//debug("1HZ int @ " + Date.now());
		dave1HZCounter = 250000 - 1;
		if (daveInterruptW & 4)
			daveInterruptR |= 8; // set latch, if 1Hz int source is enabled
		daveInterruptR ^= 4; // negate 1Hz interrupt level bit
	}
}

function daveRenderAudioSample() {
	var left, right;
	/* TODO: missing noise channel, polynom counters/ops, modulation, etc */
	if (port[0xA7] &  8)
		left  = (port[0xA8] & 63) << 2; // left ch is in D/A mode
	else {					// left ch is in "normal" mode
		left  = daveTG0State * (port[0xA8] & 63) +
			daveTG1State * (port[0xA9] & 63) +
			daveTG2State * (port[0xAA] & 63);
	}
	if (port[0xA7] & 16)
		right = (port[0xAC] & 63) << 2; // right ch is in D/A mode
	else {					// right ch is in "normal" mode
		right = daveTG0State * (port[0xAC] & 63) +
			daveTG1State * (port[0xAD] & 63) +
			daveTG2State * (port[0xAE] & 63);
	}
	/* store sample now! */
	daveAudioBufferLRec[daveAudioBufferWPos] = left  / 126 - 1;
	daveAudioBufferRRec[daveAudioBufferWPos] = right / 126 - 1;
	daveAudioBufferWPos = (daveAudioBufferWPos + 1) & SOUND_BUFFER_SIZE_MASK;
}

var fakeSine = 0;

function processAudioJavaScriptCallBack(e) {
	var a;
	var dataL = e.outputBuffer.getChannelData(0);
	var dataR = e.outputBuffer.getChannelData(1);
	//debug(daveAudioBufferL);
	//debug(daveAudioBufferR);
	daveAudioBufferRPos = 0;
	for (a = 0; a < SOUND_BUFFER_SIZE; a++) {
		dataL[a] = daveAudioBufferLPlay[daveAudioBufferRPos];
		dataR[a] = daveAudioBufferRPlay[daveAudioBufferRPos];
		daveAudioBufferRPos = (daveAudioBufferRPos + 1) & SOUND_BUFFER_SIZE_MASK;
		//dataL[a] = Math.sin(fakeSine);
		//dataR[a] = Math.sin(fakeSine);
		//fakeSine++;
	}
	daveAudioBufferWPos = 0;
	daveAudioBufferRPos = daveAudioBufferWPos;
	daveAudioBufferLRec  = (daveAudioBufferLRec  == daveAudioBufferL1) ? daveAudioBufferL2 : daveAudioBufferL1;
	daveAudioBufferRRec  = (daveAudioBufferRRec  == daveAudioBufferR1) ? daveAudioBufferR2 : daveAudioBufferR1;
	daveAudioBufferLPlay = (daveAudioBufferLPlay == daveAudioBufferL1) ? daveAudioBufferL2 : daveAudioBufferL1;
	daveAudioBufferRPlay = (daveAudioBufferRPlay == daveAudioBufferR1) ? daveAudioBufferR2 : daveAudioBufferR1;
	//debug("Audio processing: " + e.toString() + " buffer size = " + dataR.length + " type = " + dataR.toString());
}
