; CUSTOM EXOS extension for the JSep emulator http://ep.lgb.hu/jsep/
; (C)2013 LGB Gábor Lénárt
; Requires newer SJasm's to assemble
; Documentation to understand extensions (at least it helped me to be able to code this,
; even if it is not the best quality maybe):
; http://ep.homeserver.hu/Dokumentacio/Konyvek/EXOS_2.1_technikal_information/exos/kernel/Ch9.html
; http://www.ep128.hu/Ep_Konyv/Exos.htm

	ORG 0xC000
	DB "EXOS_ROM"
	;DW device_chain.xx_size - 0x8000 ; addr is on Z80 page1 relative!
	DW 0
	JP rom_entry

	OUT (0x90), A ; dummy write, just triggers JSep emulation code
	OR	A
	RET	Z
	; if A is not zero (set by JSep) use EXOS block write to present information on the default channel
	PUSH	BC
	PUSH	DE
	; JSep stores data to be write in the ROM :)
	LD	DE, 0x3001 | 0xC000
	LD	BC, (0x3000 | 0xC000)
	LD	A, 0xFF
	EXOS	8
	POP	DE
	POP	BC
	RET ; return to the sender.


	port 0x90 is used for ROM actions
	port 0x91 is used for device driver actions


SYSRAM  = 64  ; bytes needed in sys seg
VERSION_MAJOR = 0
VERSION_MINOR = 1


info:
.copyright:
	DB "NL    version "
	DB VERSION_MAJOR + "0", ".", VERSION_MINOR + "0"
	DB "  (JSep NetLink/LGB)",13,10
.copyright_length = $ - .copyright
	DB "It is not so easy to understand, dude!",13,10
.all_length = $ - .copyright


MACRO COMMAND name, handler, help
	DB .cp1 - .cp0 ; length of the command
.cp0:	DB name		; name of the command
.cp1:	DW handler ; IX will point here if command is found!
	DB .cp3 - .cp2 ; length of the help string byte (IX+2)
.cp2:	DB help ; the help string itself (IX+3)
.cp3:
ENDMACRO

MACRO EXOSSTR str
	DB .eos - $
	DB str
.eos = $
ENDMACRO


command_tab:
.num = 3
.names_offs = 0
.helps_offs = .names + (.num * 2)
.handlers_offs = .names + (.num * 4)
.names:
	DW .nl_name
	DW .ndir_name
	DW .ncd_name
.helps:
	DW .nl_help
	DW .ndir_help
	DW .ncd_help
.handlers:
	DW 0
	DW 0
	DW 0
.nl_name:	EXOSSTR "NL"
.ndir_name:	EXOSSTR "NDIR"
.ncd_name:	EXOSSTR "NCD"
.nl_help:	EXOSSTR "Help for NL"
.ndir_help:	EXOSSTR "Help for NDIR"
.ncd_help:	EXOSSTR "Help for NCD"

.names:
	DB "NL NDIR NCD"
.names_end:
	DB 0 ; trailing zero
.names_string_size = .names_end - .names


DB "NL NDIR NCD ",0 ; commands, space separated entity, the last must be closed by a space THEN a zero byte


strcpy:
	LD	A, (IX)
	CP	(IY)
	JR	NZ, ....
	INC	IX
	INC	IY
	DJNZ


	JR	ide
....




search_command:
	LD	A, (ctab)
	CP	32
	JR	Z,








command_tab:
	COMMAND "NL", 0, "NetLinkFS blah-blah"
	COMMAND "NDIR", 0, "NetLinkFS Directory listing"
	COMMAND "NCD", 0, "NetLinkFS Change Directory"
	DB 0 ; this signals the end of our table, do not forget it ...


; EXOS call macro
MACRO EXOS n
	RST	0x30
	DB	n
ENDMACRO

; Search for command by name.
; Input:  IY = pointer to the uppercased command name
;	  B  = length of the command name
; Output: Zflag=1 -> not found
;	  Zflag=0 FOUND, then:
;	  IX = pointer to handler, IX + 2 -> help string
; Affected registers:
;	   A, DE, IY, C
search_command:
	LD	IX, command_tab
.bloop:
	LD	A, (IX) ; length of the actual command to test
	OR	A
	RET	Z	; if length byte of actual command to test is zero, it means the end of the command table
	CP	B	; check if searched command length is the same as the one we wanna test now
	JR	Z, .test
	; Sizes are not the same, let's seek to the next entry
.notthesame:
	ADD	2
	LD	E, A
	LD	D, 0
	ADD	IX, DE
	LD	E, (IX+4)
	ADD	IX, DE
	JR	.bloop ; continue with the next one heh.
	; do char-vs-char test, sizes are the same!
.test:
	LD	C, B
	LD	D, B
	PUSH	IY
	PUSH	IX
.tloop:
	LD	A, (IX+1)
	CP	(IY)
	DEC	C
	INC	IX
	INC	IY
	JR	NZ, .tloop
	POP	IY
	; end of loop so this IS it, baby :)
	; TODO: set zero flag as 0!
	POP	IY ; not a mistake! it is IX, we just ignore it
	POP	IY ; and this is the real IY pop!
	RET
.nottheone:
	POP	IX
	POP	IY
	JR	.notthesame


	PUSH	IX
	PUSH	IY

	LD	A, (IX)
	OR	A
	JR	Z, .this_is_not
	CP	(IY)
.this_is_not:
.eot:



; This is the ROM entry
rom_entry:
	; Preparation point.



	LD	A, C
	CP	A, 2 ; some action, baby :)
	JR	Z, .f02_action
	CP	A, 3 ; help string?
	JR	Z, .f03_help
	IF SYSRAM > 0
	CP	A, 7 ; RAM allocation?
	JR	Z, .f07_ram_alloc
	ENDIF
	RET	; not handled action codes will return, C is preserved, etc
.f02_action:
	RET
.f03_help:
	LD	A, B
	CP	A, 0
	JR	Z, .genhelp
	CP	A, 2 ; candidate for NL
	CP	A, 3 ; candidate for NCD
	CP	A, 4 ; candidate for NDIR


	PUSH	DE
	POP	IX
	LD	A, "N"
	CP	(IX+1)

	; debug: print the requested string
	LD	C, B
	LD	B, 0
	LD	A, 0xFF
	INC	DE
	EXOS	8
	LD	A, 0xFF
	LD	B, 10
	EXOS	7
	LD	A, 0xFF
	LD	B, 13
	EXOS	7
	LD	C,0
	RET
.genhelp:
	PUSH	BC
	PUSH	DE
	LD	DE, info.copyright
	LD	BC, info.copyright_length
	LD	A, 0xFF ; default channel
	EXOS	8 ; write block
	POP	DE
	POP	BC
	RET
	IF SYSRAM > 0
.f07_ram_alloc:
	LD	BC, 0x0100 ; C=0, B=1 (page2 RAM is needed eg sys)
	LD	DE, SYSRAM ; needed amount of bytes
	ENDIF
	RET


; This is our "nice" device chain pseudo header
device_chain:
	DW 0	; XX_NEXT: next pseudo header's xx_size data, 0 if no more
	DW 0xFFFE	; XX_RAM: device ram in sys seg, -2 (FFFE) = no ram: we don't need ram as we have that with action code 7 on rom entry
.xx_size_start:
	DB 0		; DD_TYPE [???, it seems to have to be zero]
	DB 0		; DD_IRQFLAG (0 = no IRQ handlers in this ROM)
	DB 0		; DD_FLAGS (something with the channel ram alloc, hopefully 0 is OK)
	DW .entries - 0x8000		; DD_TAB, but with addr on Z80 page1!
	DB 0		; DB_TAG_SEG (can have any val, EXOS will fill in RAM for linking)
	DB 0		; DD_UNIT_COUNT [>0, multiple devices are allowed with this name]
.devname:
	DB 2, "NL"	; device name length byte + device name
.xx_size:
	DB $ - .xx_size_start
	; Now the entry points
.entries:
	DW 0 ; not need to be valid, if DD_IRQFLAG is zero! And it is.

; fill the rest of the ROM with zero bytes to have 16K image exactly
[0x10000 - $] DB 0
