/* (C)2013 Gábor Lénárt LGB http://ep.lgb.hu/jsep/
 * RTC emulation for the JavaScript Enterprise-128 emulator.
 * NOTE: this emulation is strictly about emulating features barely
 * enough for the Enterprise-128 with ZT, nothing more! It's very
 * far from being full software implementation of the hardware!!
 * Some dox which can help to understand an "RTC":
 * http://datasheets.maximintegrated.com/en/ds/DS12885-DS12C887A.pdf
 */

"use strict";


var DEBUG_RTC = false;
var RESET_RTC_INDEX = false;


var rtcRegister;


function rtcReset() {
	rtcRegister = 0xD;
	cmosRam[0xA] = 32;
	cmosRam[0xB] = 2; // 2 | 4;
	cmosRam[0xC] = 0;
	cmosRam[0xD] = 128;
	rtcDoUpdate();
	debug("RTC got reset.");
}


function rtcSetReg(val) {
	rtcRegister = val;
	//rtcRegister = val & 0x7F;
}


function rtcSet(val) {
	if (DEBUG_RTC) debug("RTC: write reg 0x" + rtcRegister.toString(16) + " with data 0x" + val.toString(16));
	if (rtcRegister == 0xC || rtcRegister == 0xD) return;
	if (rtcRegister == 0xA) val &= 127;
	cmosRam[rtcRegister] = val;
	if (RESET_RTC_INDEX) rtcRegister = 0xD;
}


function rtcConv(bin, is_hour) {
	var b7=0;
	if (is_hour && (!(cmosRam[0xB] & 2))) { // AM/PM
		if (bin == 0) {
			bin = 12;
		} else if (bin == 12) {
			b7 = 128;
		} else if (bin > 12) {
			bin -= 12;
			b7 = 128;
		}
	}
	if (!(cmosRam[0xB] & 4)) { // do bin->bcd
		bin = ((bin / 10) << 4) | (bin % 10);
	}
	return bin | b7;
}


function rtcDoUpdate() {
	var date = new Date();
	cmosRam[0] = rtcConv(date.getSeconds(), false);
	cmosRam[2] = rtcConv(date.getMinutes(), false);
	cmosRam[4] = rtcConv(date.getHours(), true);
	cmosRam[6] = rtcConv(date.getDay(), false);
	cmosRam[7] = rtcConv(date.getDate(), false);
	cmosRam[8] = rtcConv(date.getMonth() + 1, false);
	cmosRam[9] = rtcConv((date.getFullYear() % 100) + 20, false);
	cmosRam[0x32] = rtcConv(21, false);
}


function rtcGet() {
	var i = rtcRegister;
	if (RESET_RTC_INDEX) rtcRegister = 0xD;
	if (i > 63) return 0xFF;
	if (cmosRam[0xB] & 128) {
		if (DEBUG_RTC) debug("RTC: read (do not update!) reg 0x" + i.toString(16) + " result is 0x" + cmosRam[i].toString(16));
		return cmosRam[i]; // SET bit == 1, do not update
	}
	if (i in [0, 2, 4, 6, 7, 8, 9, 0x32]) rtcDoUpdate();
	if (DEBUG_RTC) debug("RTC: read reg 0x" + i.toString(16) + " result is 0x" + cmosRam[i].toString(16));
	return cmosRam[i];
}
