/* (C)2013 Gabor Lenart LGB http://ep.lgb.hu/jsep/
 * Loads EP128EMU2 snapshot file into the JavaScript based Enterprise 128 emulator.
 * Warning: this is a quite bad implementation because internal state of
 * ep128emu2 (which is stored in the snapshot file) works differently
 * than JSep's, not so easy to map that.
 * Thanks to IstvanV for the snapshot format document (and for noting a nasty typo).
 */

"use strict";

var DEBUG_SNAPSHOT = false;


function getSnapDword(stream, pos) {
	return (stream[pos] << 24) | (stream[pos + 1] << 16) | (stream[pos + 2] << 8) | stream[pos + 3];
}

function getSnapWord(stream, pos) {
	return (stream[pos] << 8) | stream[pos + 1];
}


function loadSnapshot(fileName) {
	var snap = installBinary(fileName, 98304, 3145728, false, 0); // TODO: better limits ...
	if (snap == false) {
		window.alert("Cannot fetch snapshot file, reverting to the default emulation mode without snapshot loading!");
		return false;
	}
	var NEED = [0x5D, 0x12, 0xE4, 0xF4, 0xC9, 0xDA, 0xB6, 0x42, 0x01, 0x33, 0xDE, 0x07, 0xD2, 0x34, 0xF2, 0x22];
	var a;
	for (a = 0; a < NEED.length; a++)
		if (NEED[a] != snap[a]) {
			window.alert("This snapshot file is not valid (invalid identifier) or not a snapshot file at all");
			return false;
		}
	var pos = 16;
	var out = {};
	var TYPE_BASE = 0x45508000;
	NEED = {
		1: { desc: "Z80 state",  name: "z80",  ver: 0x1000002 },
		2: { desc: "mem state",  name: "mem",  ver: 0x1000000 },
		3: { desc: "I/O state",  name: "io" ,  ver: 0x1000000 },
		4: { desc: "Dave state", name: "dave", ver: 0x1000000 },
		5: { desc: "Nick state", name: "nick", ver: 0x4000000 },
		9: { desc: "Mach state", name: "", ver: -1 }
	};
	for (;;) {
		if (pos + 8 >= snap.length) {
			window.alert("Invalid snapshot file: truncated (during block header)");
			return false;
		}
		var bType = getSnapDword(snap, pos);
		if (bType == 0)
			break;
		var bSize = getSnapDword(snap, pos + 4);
		pos += 8;
		if (pos + bSize + 4 >= snap.length) {
			window.alert("Invalid snapshot file: truncated (during block data)");
			return false;
		}
		var block = NEED[bType - TYPE_BASE];
		if (block == null) {
			window.alert("Invalid snapshot file, unknown block found: 0x" + bType.toString(16));
			return false;
		}
		if (DEBUG_SNAPSHOT)
			debug("Snapshot: block found, 0x" + bType.toString(16) + " [" + block["desc"] + "], size is 0x" + bSize.toString(16));
		if (block["ver"] != -1) {
			var bVer = getSnapDword(snap, pos);
			if (bVer != block["ver"]) {
				window.alert("Invalid snapshot file, bad version number (for 0x" + bType.toString(16) + " [" + block["desc"] + "]), got 0x" + bVer.toString(16) + ", we need 0x" + block["ver"].toString(16));
				return false;
			}
			pos += 4;
			bSize -= 4;
		}
		if (block["name"] != "") {
			if (block["name"] in out) {
				window.alert("Invalid snapshot file, block " + block["name"] + " is duplicated!");
				return false;
			}
			out[block["name"]] = snap.subarray(pos, pos + bSize);
		}
		pos += bSize + 4; 
	}
	NEED = ["z80", "mem", "io", "dave", "nick"];
	for (a in NEED) {
		if (!(NEED[a] in out)) {
			window.alert("Invalid snapshot file, missing block: " + NEED[a]);
			return false;
		}
	}
	if ((out["mem"].length - 4) % 16386) {
		window.alert("Invalid memory state: bad size");
		return false;
	}
	pos = 4;
	out["PAGE_REGS"] = out["mem"].subarray(0, 4);
	out["RAM_SIZE"] = 0;
	while (pos < out["mem"].length) {
		if (DEBUG_SNAPSHOT)
			debug("Snapshot: memory page " + (out["mem"][pos + 1] ? "ROM" : "RAM") + " at segment 0x" + out["mem"][pos].toString(16));
		for (a = 0; a < 0x4000; a++)
			memory[(out["mem"][pos] << 14) | a] = out["mem"][pos + a + 2];
		if (out["mem"][pos + 1] == 0) {
			a = (256 - out["mem"][pos]) << 4;
			if (a > out["RAM_SIZE"]) out["RAM_SIZE"] = a;
		}
		pos += 16386;
	}
	out["mem"] = true;
	if (RAM_SIZE < 64 || RAM_SIZE > 1024) {
		window.alert("Invalid snapshot file, RAM SIZE is calculated as " + RAM_SIZE + "K.");
		return false;
	}
	return out;
}


function initFromSnapshot(snap) {
	var a;
	/* port values */
	for (a = 0; a < 256; a++)
		port[a] = snap["io"][a];
	for (a = 0xA0; a <= 0xBF; a++)
		writeport(a, port[a]);
	for (a = 0; a < 4; a++)
		writeport(0xB0 | a, snap["PAGE_REGS"][a]);
	/* Initialize Z80 registers */
	a = snap["z80"];
	z80.pc = getSnapWord(a, 0);
	z80.a = a[2]; z80.f = a[3];
	z80.b = a[4]; z80.c = a[5];
	z80.d = a[6]; z80.e = a[7];
	z80.h = a[8]; z80.l = a[9];
	z80.sp = getSnapWord(a, 10);
	z80.ixh = a[12]; z80.ixl = a[13];
	z80.iyh = a[14]; z80.iyl = a[15];
	z80.a_ = a[16]; z80.f_ = a[17];
	z80.b_ = a[18]; z80.c_ = a[19];
	z80.d_ = a[20]; z80.e_ = a[21];
	z80.h_ = a[22]; z80.l_ = a[23];
	z80.i = a[24];
	z80.r = a[25] & 127;
	// 26 27 28 29 -> internal reg
	z80.iff1 = a[30] & 1;
	z80.iff2 = a[31] & 1;
	z80.r7 = a[32] & 128;
	z80.im = a[33];
	/* Nick state: TODO! */
	setLPT(true);
	setBIAS(port[0x80]);
	setBORDER(port[0x81]);
	/* Dave state: TODO! */
	/* Keyboard state: TODO! */
}
