/* (C)2013 Gábor Lénárt LGB http://ep.lgb.hu/jsep/
 * JavaScript based Enterprise-128 emulator.
 * OSD (On-Screen-Display) functionality */

"use strict";

JSep OSD menu

Continue/start emulation
Reset                      >
Show debug messages        >
Turbo speed                [ ]
FPS info                   [ ]
	

var imageDataBeforeOSD;


function osdWriteChar
function osd


function osdRefresh() {
	ctx.putImageData(imageData, 0, 0);
}

function osdStop() {
	imageData = imageDataBeforeOSD;
	imageDataBeforeOSD = null;
	imageDataData = imageData.data;
	osdRefresh();
	displayBeforeOSD = null;
}
	
	
function osdSwapDisplayBuffers() {
	for (var a = 0; a < WIDTH * HEIGHT * 4; a += 4) {
		imageDataData[a] >>= 1;
		imageDataData[a | 1] >>= 1;
		imageDataData[a | 2] >>= 1;
	}
}	
	
function osdStart() {
	displayBeforeOSD = new Uint8Array(WIDTH * HEIGHT * 3);
	for (var a = 0; a < WIDTH * HEIGHT; a++) {
		displayBeforeOSD[a * 3] = imageDataData[a * 4];
		displayBeforeOSD[a * 3 + 1] = imageDataData
	}
	
	osdSwapDisplayBuffers();
	
	imageDataBeforeOSD = ctx.getImageData(0, 0, WIDTH, HEIGHT);
	imageDataData = imageDataBeforeOSD.data;
	
	
	ctx = canvas.getContext("2d");
	ctx.fillStyle = "black";
	ctx.fillRect(0, 0, WIDTH, HEIGHT); /* set alpha to opaque */
	if (ctx.getImageData) {
		imageData = ctx.getImageData(0, 0, WIDTH, HEIGHT);
		imageDataData = imageData.data;
		debug("Canvas data type is " + imageDataData.toString());
	} else {
		window.alert("This browser does not support getImageData/putImageData. Emulator won't work. Try a decent, standard compliant (let's say latest versions of firefox, chrome or such) browser!");
		browserIsGood = false;
	}
	/* finally EP reset */
	enterpriseReset();
	nickPowerOn(); // Nick won't reset for real on reset, it just have "some" values even at power-up.
	/* snapshot related! 
	 * If snapshot was read, then we override some settings according to the snapshot */
	if (snapshot) {
		debug("SNAPSHOT: Overriding HW state from the snapshot now!");
		initFromSnapshot(snapshot);
		snapshot = true; // let's free the used memory by the snapshot! [well, garbage collector will do it]
	}
	/* audio setup */
	if (SOUND) {
		window.AudioContext = window.AudioContext || window.webkitAudioContext;
		if (typeof AudioContext == "undefined") {
			debug("AUDIO: Your browser does not support Audio API!");
			window.alert("Audio was requested but your browser does not support Audio API! Switching audio off.");
			SOUND = false;
		} else {
			debug("AUDIO: API is OK (" + (
				(typeof webkitAudioContext == "undefined") ? "W3C" : "webkit"
			) + "): " + AudioContext.toString());
		}
	} else {
		debug("AUDIO: was not requested");
	}
	if (SOUND) {
		window.alert("Your browser supports Web Audio API :) It is good, but the support in JSep is not ready yet :-(");
	}
	/* and set JS kbd events */
	document.onkeydown = keyDown;
	document.onkeyup = keyUp;
	document.onkeypress = keyDown;
}


function contend_memory(addr) {
	return 0; /* TODO: implement. Comment from JSspeccy */
}
function contend_port(addr) {
	return 0; /* TODO: implement. Comment from JSspeccy */
}


function readbyte_internal(addr) {
	return memory[pageBases[addr >> 14] | (addr & 0x3FFF)];
}
var readbyte = readbyte_internal;


function writebyte_internal(addr, val) {
	addr = pageBases[addr >> 14] | (addr & 0x3FFF);
	if (addr >= firstRamByte)
		memory[addr] = val;
}
var writebyte = writebyte_internal;


function readport(addr) {
	addr &= 0xFF;
	if (addr >= 0xB0 && addr <= 0xB3) {
		return port[addr];
	} else if (addr == 0xB4) {
		return daveInterruptR;
	} else if (addr == 0xB5) {
		return (keySel == -1) ? 0xFF : keyStates[keySel];
	} else if ((addr & 0xF0) == 0x10) {
		return exdosPortRead(addr);
	} else if (addr == 0x7F) {
		return rtcGet();
	} else {
		if (DEBUG_PORT)
			debug("Reading undecoded port 0x" + addr.toString(16));
		return 0xFF; // unused port, or not defined for reading
	}
}


function writeport(addr, val) {
	addr &= ((addr & 0xF0) == 0x80) ? 0xF3 : 0xFF;
	port[addr] = val;
	if (addr == 0xB0)
		pageBases[0] = val << 14;
	else if (addr == 0xB1)
		pageBases[1] = val << 14;
	else if (addr == 0xB2)
		pageBases[2] = val << 14;
	else if (addr == 0xB3)
		pageBases[3] = val << 14;
	else if (addr == 0xB4)
		daveConfigureInterrupts(val);
	else if (addr == 0xB5) {
		keySel = ((val & 15) < 10) ? (val & 15) : -1;
	} else if (addr == 0x80) {
		setBIAS(val);
	} else if (addr == 0x81) {
		setBORDER(val);
	} else if (addr == 0x82) {
		//setLPT(false);
		setLPT(!(port[0x83] & 128));
	} else if (addr == 0x83) {
		setLPT(!(val & 128));
	} else if ((addr & 0xF0) == 0x10) {
		exdosPortWrite(addr, val);
	} else if (addr == 0x7E) {
		rtcSetReg(val);
	} else if (addr == 0x7F) {
		rtcSet(val);
	} else {
		if (DEBUG_PORT && (addr < 0xA0 || addr > 0xBF))
			debug("Writing undecoded port 0x" + addr.toString(16) + " with value 0x" + val.toString(16));
	}
}



function emulatorIteration() {
	if (!running) return;
	tstates = 0;
	refresh = false;
	event_next_event = 0;
	while (!refresh) {
		nickDoSlot();
		daveTick();
		event_next_event += CPU_STATES_PER_NICK_SLOT;
		if (UGLY_TRACE && tstates < event_next_event) uglyTrace += z80.pc.toString(16) + "\n";
		z80_do_opcodes();
		if (daveInterruptR & 0xAA) { // if any of the dave interrupt latches is set, activate Z80 interrupt
			if (UGLY_TRACE) uglyTrace += "INT\n";
			z80_interrupt();
		}
	}
	return tstates;
}


var statCounter = 0;


function emulatorStat(fps, timeout_set, timeout_all) {
	if (!statCounter) {
		document.getElementById("timeout").innerHTML = timeout_set + "/" + timeout_all;
		document.getElementById("fps").innerHTML = fps;
		diskStat();
		statCounter = 5;
	} else
		statCounter--;
}


function emulator() {
	if (!running) return;
	var t = Date.now();
	frameSkip = true;
	var cycs = emulatorIteration();
	frameSkip = false;
	cycs += emulatorIteration();
	//if (pixAddr >= PIXADDR_HARD_LIMIT) pixAddr = PIXADDR_INITIAL;
	var td = Date.now() - t;
	t = ((cycs / CPU_CLOCK_1000) - td);
	if (t < 1 || TURBO_SPEED) t = 1;
	emulatorStat((1000 / td) | 0, t | 0, (cycs / CPU_CLOCK_1000) | 0);
	//document.getElementById("timeout").innerHTML = t + "/" + ((cycs / 4000) | 0);
	//document.getElementById("fps").innerHTML = (1000 / td) | 0;
	if (running) setTimeout(emulator, t);
}
