; CUSTOM EXOS extension for the JSep emulator http://ep.lgb.hu/jsep/
; (C)2013 LGB Gábor Lénárt
; Requires newer SJasm's to assemble
; Note, that it's highly JSep specific code, DO NOT TRY this on
; a real EP, or in another emulator. It depends on large code
; base written in JavaScript, implemented by JSep only. It will
; surely crash/hang on other emu/machine than JSep.


; Do NOT modify anything within this block unless you know what you are doing
; Eg callback table and the byte before it must be at fixed position,
; JSep emulator code uses it!
	ORG	0xC000
	DB	"EXOS_ROM"
	DW	0
	JP	rom_entry
	; Warning the byte then words here are VERY important not to be altered, their offset is used to reference from the emulator code!
	DB	(callbacks.end - callbacks) >> 1 ; this byte stores the number of callback entries for JSep to be able to read
callbacks:
	DW	rom_command_nl
	DW	rom_monitor_test1
	DW	rom_monitor_test2
.end = $

MACRO EXOS n
	RST	0x30
	DB	n
ENDMACRO


rom_entry:
	XOR	A
	OUT	(0x90), A 	; This triggers the ROM entry routine in JSep [A=0]
	OR	A
	JR	NZ, .rom_cmd	; A is modified to be non-zero by JSep if special ROM code needs to be run other than the "standard stuff" also HL to jump to!
	PUSH	BC
	PUSH	DE
.wait:
	LD	A, (0xBFF2)	; check flag_stop_irq
	CP	0x20		; STOP?
	JR	Z, .stop_key
	LD	A, 1		; query status + get buffer OP -> JSep will modify register A on the request after the OUT op
	OUT	(0x90), A
	OR	A
	JR	Z, .wait
	JP	P, .ret		; if bit7 == 0 then return, otherwise there is something in the buffer to print!
	LD	DE, 0xFC00	; this is the ugliest idea compo winner prize :) JSep write data into the end of the ROM, and we use information from there!
	LD	BC, (0xFBFE)
	LD	A, 0xFF		; default channel to write data to
	EXOS	8
	JR	.wait
.ret:
	POP	DE
	POP	BC
	LD	A, 2		; get op result status (regs will be modified by JSep, in our case A and C)
	OUT	(0x90), A
	RET
.rom_cmd:			; Special commands which are implemented by this ROM mainly and not in JSep!
	JP	(HL)		; HL is filled by JSep (with the help of fixed position jump table near to the beginning of the ROM), so it's OK!
.stop_key:
	POP	DE		; if STOP key is pressed ...
	POP	BC
	LD	A, 0xE5
	LD	C, 0
	RET






rom_monitor_test1:
	LD	DE, .msg
	LD	BC, .msg_size
	LD	A, 0xFF
	EXOS	8
	XOR	A
	LD	C, A
	RET
.msg:	DB "This text is from ROM, unlike the others which is produced by the emulator code. This does not make sense currently though, ignore this command! :)\r\n"
.msg_size = $ - .msg


rom_monitor_test2:
	LD	DE, .msg
	LD	BC, .msg_size
	LD	A, 0xFF
	EXOS	8
	XOR	A
	LD	C, A
	RET
.msg:	DB "Ez egy masik buta teszt\r\n"
.msg_size = $ - .msg

; Unfinished code, warning! NL: can be used to make netlinkfs as the default exos device?
rom_command_nl:
	LD	DE, device_chain.devname
	LD	C, 1
	EXOS	19
	XOR	A
	LD	C, A
	RET




; This will be our device driver some time ...
; Currently the rest of the file is not used! [the last line is important though]
device_chain:
	DW 0    ; XX_NEXT: next pseudo header's xx_size data, 0 if no more
	DW 0xFFFE       ; XX_RAM: device ram in sys seg, -2 (FFFE) = no ram: we don't need ram
.xx_size_start:
	DB 0            ; DD_TYPE [???, it seems to have to be zero]
	DB 0            ; DD_IRQFLAG (0 = no IRQ handlers in this ROM)
	DB 0            ; DD_FLAGS (something with the channel ram alloc, hopefully 0 is OK)
	DW dd_entries - 0x8000            ; DD_TAB, but with addr on Z80 page1!
	DB 0            ; DB_TAG_SEG (can have any val, EXOS will fill in RAM for linking???)
	DB 0            ; DD_UNIT_COUNT [>0, multiple devices are allowed with this name]
.devname:
	DB 2, "NL"      ; device name length byte + device name
.xx_size:
	DB $ - .xx_size_start


dd_entries:
	;DW 0 ; no need to be valid, if DD_IRQFLAG is zero! And it is.
	;DW dd_open_channel
	;DW dd_create_channel
	;DW dd_close_channel
	;DW dd_destroy_channel
	;DW dd_read_char
	;DW dd_read_block
	;DW dd_write_char
	;DW dd_write_block
	;DW dd_chan_read_status
	;DW dd_chan_set_status
	;DW dd_spec_func
	;initdev?
	;buffermoved?
	;invfunc?
	;invfunc?

; fill the rest of the ROM with zero bytes to have 16K image exactly
[0x10000 - $] DB 0
