/* Heavily modified JSspeccy's spectrum.js with rewritten parts for Enterprise specific things
   by LGB */

var browserIsGood = true;


if(typeof Uint8Array == "undefined") {
	window.alert("Uint8Array() cannot be used. You should consider to use a better browser (or newer version at least). In case of IE, the minimum is said to be IE 10.");
	browserIsGood = false;
}



var POST_SCALE = false;

var running = false;

var FIRST_LINE_TO_SHOW = 26;

var EXOS_ROM = "exos21.rom";
var BASIC_ROM = "basic21.rom";
var RAM_SIZE = 128; /* in Kbytes */
//var EXOS_ROM="EXOS24UK.ROM";
//var BASIC_ROM="nope";
var lpt_base;
var render = new Uint8Array(672);



function debug(msg) {
	document.getElementById("debug").innerHTML += msg + "\n";
}


function resetKeyboard() {
	for (var i = 0; i < 10; i++) {
		keyStates[i] = 0xFF;
	}
}

function ep_reset() {
	for (var i = 0; i < 0x100; i++) {
		port[i] = 0xff;
	}
	z80_reset();
	writeport(0xb0, 0);
	writeport(0xb1, 0);
	writeport(0xb2, 0);
	writeport(0xb3, 0);
	resetKeyboard();
	keySel = 0;
	line = 0;
	debug("EP+Z80 reset");
}

function install_rom(name, segment) {
	if (!(name in roms)) {
		debug("ROM image '" + name + "' cannot be found.");
		return false;
	}
	debug("Installing ROM image '" + name + "' at segment " + segment + " (" + roms[name].length + " bytes)");
	segment <<= 14; // convert to bytes
	for(var i = 0; i < roms[name].length; i++) {
		memory[i + segment] = roms[name].charCodeAt(i);
	}
	return true;
}




function ep_init() {
	var i;
	var memoryBuffer = new ArrayBuffer(0x400000);
	memory = new Uint8Array(memoryBuffer); // export memory as bytes
	vram = new Uint8Array(memoryBuffer, 0x3F0000); // export video ram as bytes
	if (RAM_SIZE < 64)
		RAM_SIZE = 64;
	else if (RAM_SIZE > 2048)
		RAM_SIZE = 2048;
	else
		RAM_SIZE &= 0xFF0;
	debug("Total RAM size: " + RAM_SIZE + "K.");
	i = "Enterprise " + RAM_SIZE + "K";
	document.title = i;
	document.getElementById('h1name').innerHTML = i;
	firstRamByte = 0x400000 - (RAM_SIZE << 10); // export first memory byte
	pageBases = [];
	port = new Uint8Array(256);
	for (i = 0; i < 0x400000; i++)
		memory[i] = 0xFF;
	install_rom(EXOS_ROM, 0);
	install_rom(BASIC_ROM, 4);
	//install_rom("EXOS24UK.ROM", 0);
	/* reset EP */
	keyStates = new Uint8Array(10);
	ep_reset();
	/* generate EP palette in RGB colour space */
	palR = new Uint8Array(256);
	palG = new Uint8Array(256);
	palB = new Uint8Array(256);
	for(i = 0; i < 256; i++) {
		palR[i] = (((i << 2) & 4) | ((i >> 2) & 2) | ((i >> 6) & 1)) * 255 / 7;
		palG[i] = (((i << 1) & 4) | ((i >> 3) & 2) | ((i >> 7) & 1)) * 255 / 7;
		palB[i] = (                 ((i >> 1) & 2) | ((i >> 5) & 1)) * 255 / 3;
	}
	/* browser specific stuffs */
	canvas = document.getElementById('screen');
	ctx = canvas.getContext('2d');
	ctx.fillStyle = 'black';
	ctx.fillRect(0,0,672,512); /* set alpha to opaque */
	if (ctx.getImageData) {
		imageData = ctx.getImageData(0,0,672,512);
		imageDataData = imageData.data;
		debug("Canvas data type is " + imageDataData.toString());
	} else {
		window.alert("This browser does not support getImageData/putImageData. Emulator won't work. Try a decent, standard compliant (let's say latest versions of firefox, chrome or such) browser!");
		browserIsGood = false;
	}
	document.onkeydown = keyDown;
	document.onkeyup = keyUp;
}

var keyCodes = {
	 49: {row: 3, mask: 0x02}, /* 1 */
	 50: {row: 3, mask: 0x40}, /* 2 */
	 51: {row: 3, mask: 0x20}, /* 3 */
	 52: {row: 3, mask: 0x08}, /* 4 */
	 53: {row: 3, mask: 0x10}, /* 5 */
	 54: {row: 3, mask: 0x04}, /* 6 */
	 55: {row: 3, mask: 0x01}, /* 7 */
	 56: {row: 5, mask: 0x01}, /* 8 */
	 57: {row: 5, mask: 0x04}, /* 9 */
	 48: {row: 5, mask: 0x10}, /* 0 */

	 81: {row: 2, mask: 0x02}, /* Q */
	 87: {row: 2, mask: 0x40}, /* W */
	 69: {row: 2, mask: 0x20}, /* E */
	 82: {row: 2, mask: 0x08}, /* R */
	 84: {row: 2, mask: 0x10}, /* T */
	 89: {row: 2, mask: 0x04}, /* Y */
	 85: {row: 2, mask: 0x01}, /* U */
	 73: {row: 9, mask: 0x01}, /* I */
	 79: {row: 9, mask: 0x04}, /* O */
	 80: {row: 9, mask: 0x10}, /* P */

	 65: {row: 1, mask: 0x40}, /* A */
	 83: {row: 1, mask: 0x20}, /* S */
	 68: {row: 1, mask: 0x08}, /* D */
	 70: {row: 1, mask: 0x10}, /* F */
	 71: {row: 1, mask: 0x04}, /* G */
	 72: {row: 1, mask: 0x01}, /* H */
	 74: {row: 6, mask: 0x01}, /* J */
	 75: {row: 6, mask: 0x04}, /* K */
	 76: {row: 6, mask: 0x10}, /* L */
	 13: {row: 7, mask: 0x40}, /* enter */

	 16: {row: 0, mask: 0x80}, /* Shift */
	192: {row: 0, mask: 0x01}, /* TODO backtick as caps - because firefox screws up a load of key codes when pressing shift */
	 90: {row: 0, mask: 0x40}, /* Z */
	 88: {row: 0, mask: 0x20}, /* X */
	 67: {row: 0, mask: 0x08}, /* C */
 	 86: {row: 0, mask: 0x10}, /* V */
	 66: {row: 0, mask: 0x04}, /* B */
	 78: {row: 0, mask: 0x01}, /* N */
	 77: {row: 8, mask: 0x01}, /* M */
	 17: {row: 1, mask: 0x80}, /* [CTRL] TODO sym - gah, firefox screws up ctrl+key too */
	 32: {row: 8, mask: 0x40}, /* space */

	186: {row: 6, mask: 0x08}, /* ; hmm on chrome I get this key */
	 59: {row: 6, mask: 0x08}, /* ; hmm on firefox I get this key */
	219: {row: 9, mask: 0x20}, /* [ */
	221: {row: 6, mask: 0x40}, /* ] */
	222: {row: 6, mask: 0x20}, /* ' for real, but we map EP : here */
	189: {row: 5, mask: 0x08}, /* - */
	220: {row: 0, mask: 0x02}, /* \ */
	  9: {row: 2, mask: 0x80}, /* TAB */
	 27: {row: 3, mask: 0x80}, /* ESC */
	 45: {row: 8, mask: 0x80}, /* INS */
	  8: {row: 5, mask: 0x40}, /* ERASE */
	 46: {row: 8, mask: 0x02}, /* DEL */
	 37: {row: 7, mask: 0x20}, /* LEFT */
	 39: {row: 7, mask: 0x04}, /* RIGHT */
	 38: {row: 7, mask: 0x08}, /* UP */
	 40: {row: 7, mask: 0x02}, /* DOWN */
	191: {row: 8, mask: 0x08}, /* / */
	190: {row: 8, mask: 0x10}, /* . */
	188: {row: 8, mask: 0x04}, /* , */
};




function keyDown(evt) {
	if (!running) return;
	/*if (evt.keyCode == 0) {
		resetKeyboard();
		kbdinfo("KEY 0 GOT, resetting kbd!");
		return;
	}*/
	var keyCode = keyCodes[evt.keyCode];
	if (keyCode == null) {
		kbdinfo("KEY v [" + evt.keyCode + "] UNKNOWN TO MAP");
		return;
	}
	keyStates[keyCode.row] &= ~(keyCode.mask);
	kbdinfo("KEY v [" + evt.keyCode + "] row=" + keyCode.row + " mask=" + keyCode.mask);
	return false; // false is needed here not to pass controll to the browser!
}
function keyUp(evt) {
	if (!running) return;
	if (evt.keyCode == 0) {
		/* that's ugly, but it seems, shift stucks on Chrome without this hack [interestingly only on ONE machine of mine, not the other with same broser/OS!] :( */
		resetKeyboard();
		kbdinfo("KEY 0 GOT, resetting kbd!");
		return;
	}
	var keyCode = keyCodes[evt.keyCode];
	if (keyCode == null) {
		kbdinfo("KEY ^ [" + evt.keyCode + "] UNKNOWN TO MAP");
		return;
	}
	keyStates[keyCode.row] |= keyCode.mask;
	kbdinfo("KEY ^ [" + evt.keyCode + "] row=" + keyCode.row + " mask=" + keyCode.mask);
}

function contend_memory(addr) {
	return 0; /* TODO: implement */
}
function contend_port(addr) {
	return 0; /* TODO: implement */
}

function readbyte_internal(addr) {
	return memory[pageBases[addr >> 14] | (addr & 0x3FFF)];
}
readbyte = readbyte_internal;

function readport(addr) {
	addr = addr & 0xff;
	if (addr == 0xb4) {
		if (vint) {
			return 32 + 16;
		} else {
			return 0;
		}
	} else if (addr == 0xb5) {
		//debug("KEYREAD for sel: " + keySel);
		return keyStates[keySel];
	} else {
		/*if (addr < 0xB0 || addr > 0xB3) {
			debug("PORT READ: " + addr);
		}*/
		return port[addr];
	}
}

function lpt_reload() {
	lpt_base = ((port[0x83] & 0xf) << 12) | (port[0x82] << 4);
}

function writeport(addr, val) {
	addr = addr & 0xff;
	port[addr] = val;
	if ((addr & 0xfc) == 0xb0) {
		/*debug("IO: Mempage " + (addr & 3) + " is set to " + val);*/
		pageBases[addr & 3] = val << 14;
	} else if (addr == 0xb5) {
		//debug("B5 is written!");
		if ((val & 0xf) < 10) {
			keySel = val & 0xf;
			//debug("KEYSEL set to " + keySel);
		}
	} else if (addr == 0x81) {
		//debug("IO: Nick border is set to " + val);
		canvas.style.borderColor = "rgb(" + palR[val] + "," + palG[val] + "," + palB[val] + ")";
	} else if (addr == 0x83) {
		if ((val & 128) == 0) {
			debug("IO: forced LPT reload");
			lpt_reload();
		}
		line = 0;
	} else if (addr != 0x81 && addr != 0x82) {
		//debug("Writing unemulated port " + addr);
	}
}


function writebyte_internal(addr, val) {
	addr = pageBases[addr >> 14] | (addr & 0x3FFF);
	if (addr >= firstRamByte)
		memory[addr] = val;
}
writebyte = writebyte_internal;


function nickbyte(o) {
	return vram[o & 0xffff];
}




var vint = 0; /* signals video interrupt */
var lpb = [];
var ld1 = 0;
var ld2 = 0;
var lpt = 0;


function load_ld1() {
	ld1 = lpb[4] | (lpb[5] << 8);
}
function load_ld2() {
	ld2 = lpb[6] | (lpb[7] << 8);
}
function load_lpb() {
	var i;
	for(i = 0; i < 16; i++) {
		lpb[i] = nickbyte(lpt + i);
	}
	if (lpb[0] & 128) {
		vint = 1;
	}
	load_ld1();
	load_ld2();
}



/* used to emulate a single nick line */
function nickScanLine() {
	if (nickSC == 256) {
		lpt = (vram[lpt] & 128) ? lpt_base : (lpt + 0x10) & 0xFFFF;
		var vint_new = vram[lpt + 1] & 128;
		if (!vint && vint_new) { /* video interrupt if raising edge on vint detected */
		}
		vint = vint_new;

		if (nickLastLPB) {
		} else
			lpt = (lpt_base + 0x10) & 0xFFFF;
		nickSC = 256;
		nickVM = (vram[lpt + 1] >> 1) & 7;
		nickSC = vram[lpt];
	}
	if (nickVM) {
		line++;
	} else {
		line=0;

	}
	nickSC++;
}




function paintScreen() {
	var lpbnum = 0;
	var wasvsync = false;
	lpt = ((port[0x83] & 0xf) << 12) | (port[0x82] << 4);
	load_lpb();
	vint = 0;
	while (lpbnum < 300) {
		var vm = ((lpb[1] >> 1) & 7);
		var marg1 = lpb[2] & 63;
		var marg2 = lpb[3] & 63;
		/*for(var i=0; i<672; i++) {
			render[i] = port[0x81];
		}*/
		/*if (wasvsync && vm) {
			wasvsync = false;
			line = 0;
		}*/
		if (!wasvsync && !vm) {
			// TODO: clear rest of the screen before vsync if any!
			ctx.putImageData(imageData, 0, 0);
		}
		if (vm == 0) {
			wasvsync = true;
			//line = 0;
			//lpb[0] = 255; /* force next LPB load */
			line = 0;
		} else if (vm == 3 || vm == 4 || vm == 5) {
			wasvsync = false;
			//var pixelAddress = (y << 10) | (x << 5);
			//var pixelAddress = line * 256 * 4 + (marg1 - 8) * 8 * 4;
			var chs = 64 << (5 - vm);
			//if (marg2>30) marg2=30;
			var pp = (marg1 - 10) << 4;
			var col,x,cc,data,b;
			for(x = marg1 ; x < marg2 ; x++) {
				cc = nickbyte(ld1++);
				data = nickbyte(ld2 * chs + (cc & (chs - 1)));
				for(b = 0; b < 8; b++) {
					if (data & 128) {
						if (lpb[3] & 64 && cc & 128)
							col = lpb[11];
						else
							col = lpb[9];
					} else {
						if (lpb[3] & 64 && cc & 128)
							col = lpb[10];
						else
							col = lpb[8];
					}
					if (x >= 10 && x <= 52) {
						render[pp] = col;
						render[pp + 1] = col;
					}
					pp += 2;
					data <<= 1;
				}
			}
			load_ld1();
			ld2++;
			line++;
		} else if (vm == 1) {
			wasvsync = false;
			var pp = (marg1 - 10) << 4;
			var x, data1, data2, i;
			for(x = marg1; x< marg2; x++) {
				data1 = nickbyte(ld1++);
				data2 = nickbyte(ld1++);
				if (x >=10 && x<=52) {
					for(i=0;i<8;i++) {
						render[pp++] = data1;
					}
					for(i=0;i<8;i++) {
						render[pp++] = data2;
					}
				}
			}
			if (!(lpb[1] & 16)) {
				load_ld1(); // if VRES is not set, reload LD1
			}
			line++;
		} else {
			wasvsync = false;
			line++; // wtf?
		}
		/* render 256 colour EP palette result into RGB space inside the canvas */
		if (vm && line >= FIRST_LINE_TO_SHOW && line < 256 + FIRST_LINE_TO_SHOW) {
			var pixaddr = (line - FIRST_LINE_TO_SHOW) * 672 * 8;
			var i,j;
			for(i=0; i<672; i++) {
				j = render[i];
				/* dot */
				imageDataData[pixaddr + 0] = palR[j];
				imageDataData[pixaddr + 1] = palG[j];
				imageDataData[pixaddr + 2] = palB[j];
				/* imageDataData[pixaddr + 3] = 255;  alpha */
				/* dot */
				if (!POST_SCALE) {
					imageDataData[pixaddr + 672 * 4 + 0] = palR[j];
					imageDataData[pixaddr + 672 * 4 + 1] = palG[j];
					imageDataData[pixaddr + 672 * 4 + 2] = palB[j];
				}
				/* imageDataData[pixaddr + 672 * 4 + 3] = 255; alpha */
				pixaddr += 4;
			}
		}
		lpb[0]++;
		if (lpb[0] == 256) {
			if (lpb[1] & 1) break; /* end of LPT */
			lpt += 16;
			load_lpb();
		} /*else {
			lpb[0]++;
		}*/
		lpbnum++;
	}
}

function paintFullScreen() {
	/* dunno, why ... */
	paintScreen();
}
