/* (C)2013 Gábor Lénárt LGB http://ep.lgb.hu/jsep/
 * The method to emulate kbd matrix and the base skeleton of the JS event
 * handler is from JSspeccy, but with reimplementation for the Enterprise and
 * to fix some issues. */

"use strict";


var KBD_RESET_ON_UNKNOWN = "yes";

function keyboardReset() {
	for (var i = 0; i < 10; i++)
		keyStates[i] = 0xFF;
}


/* KBD event translation table for Enterprise.
 * Note: the original design is from JSspeccy directly,
 * I mapped existing keys from there (and also many new ones)
 * for the EP's matrix position. Some of the comments
 * are from JSspeccy still. */
var keyCodes = {
	 49: {row: 3, mask: 0x02}, /* 1 */
	 50: {row: 3, mask: 0x40}, /* 2 */
	 51: {row: 3, mask: 0x20}, /* 3 */
	 52: {row: 3, mask: 0x08}, /* 4 */
	 53: {row: 3, mask: 0x10}, /* 5 */
	 54: {row: 3, mask: 0x04}, /* 6 */
	 55: {row: 3, mask: 0x01}, /* 7 */
	 56: {row: 5, mask: 0x01}, /* 8 */
	 57: {row: 5, mask: 0x04}, /* 9 */
	 48: {row: 5, mask: 0x10}, /* 0 */

	 81: {row: 2, mask: 0x02}, /* Q */
	 87: {row: 2, mask: 0x40}, /* W */
	 69: {row: 2, mask: 0x20}, /* E */
	 82: {row: 2, mask: 0x08}, /* R */
	 84: {row: 2, mask: 0x10}, /* T */
	 89: {row: 2, mask: 0x04}, /* Y */
	 85: {row: 2, mask: 0x01}, /* U */
	 73: {row: 9, mask: 0x01}, /* I */
	 79: {row: 9, mask: 0x04}, /* O */
	 80: {row: 9, mask: 0x10}, /* P */

	 65: {row: 1, mask: 0x40}, /* A */
	 83: {row: 1, mask: 0x20}, /* S */
	 68: {row: 1, mask: 0x08}, /* D */
	 70: {row: 1, mask: 0x10}, /* F */
	 71: {row: 1, mask: 0x04}, /* G */
	 72: {row: 1, mask: 0x01}, /* H */
	 74: {row: 6, mask: 0x01}, /* J */
	 75: {row: 6, mask: 0x04}, /* K */
	 76: {row: 6, mask: 0x10}, /* L */
	 13: {row: 7, mask: 0x40}, /* enter */

	 16: {row: 0, mask: 0x80}, /* Shift */
	192: {row: 0, mask: 0x01}, /* TODO backtick as caps - because firefox screws up a load of key codes when pressing shift */
	 90: {row: 0, mask: 0x40}, /* Z */
	 88: {row: 0, mask: 0x20}, /* X */
	 67: {row: 0, mask: 0x08}, /* C */
 	 86: {row: 0, mask: 0x10}, /* V */
	 66: {row: 0, mask: 0x04}, /* B */
	 78: {row: 0, mask: 0x01}, /* N */
	 77: {row: 8, mask: 0x01}, /* M */
	 17: {row: 1, mask: 0x80}, /* [CTRL] TODO sym - gah, firefox screws up ctrl+key too */
	 32: {row: 8, mask: 0x40}, /* space */

	186: {row: 6, mask: 0x08}, /* ; hmm on chrome I get this key */
	/* 59: {row: 6, mask: 0x08},  ; hmm on firefox I get this key */
	219: {row: 9, mask: 0x20}, /* [ */
	221: {row: 6, mask: 0x40}, /* ] */
	222: {row: 6, mask: 0x20}, /* ' for real, but we map EP : here */
	189: {row: 5, mask: 0x08}, /* - */
	220: {row: 0, mask: 0x02}, /* \ */
	  9: {row: 2, mask: 0x80}, /* TAB */
	 27: {row: 3, mask: 0x80}, /* ESC */
	 45: {row: 8, mask: 0x80}, /* INS */
	  8: {row: 5, mask: 0x40}, /* ERASE */
	 46: {row: 8, mask: 0x02}, /* DEL */
	 37: {row: 7, mask: 0x20}, /* LEFT */
	 39: {row: 7, mask: 0x04}, /* RIGHT */
	 38: {row: 7, mask: 0x08}, /* UP */
	 40: {row: 7, mask: 0x02}, /* DOWN */
	191: {row: 8, mask: 0x08}, /* / */
	190: {row: 8, mask: 0x10}, /* . */
	188: {row: 8, mask: 0x04}, /* , */
	187: {row: 9, mask: 0x08}, /* =, but we map as @ */

	112: {row: 4, mask: 0x80}, /* F1 */
	113: {row: 4, mask: 0x40}, /* F2 */
	114: {row: 4, mask: 0x04}, /* F3 */
	115: {row: 4, mask: 0x01}, /* F4 */
	116: {row: 4, mask: 0x10}, /* F5 */
	117: {row: 4, mask: 0x08}, /* F6 */
	118: {row: 4, mask: 0x20}, /* F7 */
	119: {row: 4, mask: 0x02}, /* F8 */

	 36: {row: 7, mask: 0x10},  /* home, we map this as HOLD */
	 35: {row: 7, mask: 0x01},  /* end, we map this as STOP */
};


/* This is an ugly hack, currently to work around Hungarian keyboard and some browser related differences, etc ... */
function keyPreTrans(evt) {
	var kc = evt.keyCode;
	if (kc == 0) {
		kc = evt.charCode;
		if (kc == 233) return 186; // Hungarian é to ;
		if (kc == 225) return 222; // Hungarian á is used for :
		return 0; // not found by charCode, return zero
	}
	// firefox does some things totally different way than rest of the browsers:
	if (kc ==  59) return 186; // firefox workaround
	if (kc == 107) return 187; // firefox workaround
	if (kc == 109) return 189; // firefox workaround
	return kc;
}


function keyDown(evt) {
	if (!running) return;
	/*if (evt.keyCode == 0) {
		keyboardReset();
		kbdinfo("KEY 0 GOT, resetting kbd!");
		return;
	}*/
	var keyCode = keyCodes[keyPreTrans(evt)];
	var kid = evt.keyCode + "/" + evt.charCode + "/" + evt.which;
	if (keyCode == null) {
		kbdinfo("KEY v [" + kid + "] UNKNOWN TO MAP");
		return false; // well anyway ...
	}
	keyStates[keyCode.row] &= ~(keyCode.mask);
	kbdinfo("KEY v [" + kid + "] row=" + keyCode.row + " mask=" + keyCode.mask);
	return false; // false is needed here not to pass controll to the browser!
}


function keyPress(evt) {
	if (!running) return;
	var keyCode = keyCodes[keyPreTrans(evt)];
	var kid = evt.keyCode + "/" + evt.charCode + "/" + evt.which;
	if (keyCode == null) {
		kbdinfo("KEY # [" + kid + "] UNKNOWN TO MAP");
		return false; // well anyway ...
	}
	keyStates[keyCode.row] &= ~(keyCode.mask);
	kbdinfo("KEY # [" + kid + "] row=" + keyCode.row + " mask=" + keyCode.mask);
	return false; // false is needed here not to pass controll to the browser!
}


function keyUp(evt) {
	if (!running) return;
	var keyCode = keyPreTrans(evt);
	var kid = evt.keyCode + "/" + evt.charCode + "/" + evt.which;
	if (keyCode == 0 && KBD_RESET_ON_UNKNOWN == "yes") {
		/* that's ugly, but it seems, shift stucks on Chrome without this hack [interestingly only on ONE of my machines, not the other with same browser/OS!] :( */
		keyboardReset();
		kbdinfo("KEY 0 GOT [" + kid + "], resetting kbd!");
		return false;
	}
	keyCode = keyCodes[keyCode];
	if (keyCode == null) {
		kbdinfo("KEY ^ [" + kid + "] UNKNOWN TO MAP");
		return false;
	}
	keyStates[keyCode.row] |= keyCode.mask;
	kbdinfo("KEY ^ [" + kid + "] row=" + keyCode.row + " mask=" + keyCode.mask);
	return false;
}
