/* (C)2013 Gábor Lénárt LGB http://ep.lgb.hu/jsep/
 * Nick chip emulation for the JavaScript Enterprise-128 emulator.
 * It is not perfect and some code-refactoring is needed later.
 * Currently eg colour modes in pixel and character modes handled
 * separately which does not make sense, but it was better to test
 * the code at the beginning ... And so on.
 * Not so useful things (well, usefullness is defined by me ...)
 * are not emulated, like non-2-colour mode attrinute gfx,
 * etc. */

"use strict";

var FIRST_LINE_TO_SHOW = 40;
var WIDTH = 736;
var HEIGHT = 256;
var HARD_LIMIT_LINE = 330;

/*var FIRST_LINE_TO_SHOW = 20; // TV vertical overscan, the first scanline which can be seen (original guess: 36)
var HARD_LIMIT_LINE = 340;
var WIDTH = 736; // horizontal resolution in pixels, currently it must be for all valid nick slots, one slot is 16 pixel, so 46*16 = 736
var HEIGHT = 288; // vertical resolution in pixels, currently only non-interlaced (emulator will show the screen however ZOOMED by factor of two vertically!!!!)
*/

var WIDTH_SCALING = 1.0;
var HEIGHT_SCALING = 2.0;
var PIXADDR_INITIAL	= - FIRST_LINE_TO_SHOW * 4 * WIDTH;
var PIXADDR_LIMIT	= 4 * WIDTH * HEIGHT; // address for the first non-visible (TV vertical overscan) byte
var PIXADDR_HARD_LIMIT	= 4 * WIDTH * (HARD_LIMIT_LINE - FIRST_LINE_TO_SHOW); // "hard" limit, if it's got (VSYNC should be earlier normally) it's surely out-of-sync PAL signal

// var NICK_SLOTS_PER_SEC = 50 * 312.5 * 57; //890625
var NICK_SLOTS_PER_SEC = 889846; // more accurate :) from IstvanV

var DEBUG_NICK = false;
var DEBUG_NICK_SET_LPT = true;
var DEBUG_SYNC_PROBLEM = true;

var lptBase, nickSlot, oldBIAS, oldBORDER, nickSetBorder;
var nickBorderR, nickBorderG, nickBorderB;
var frameSkip, pixAddr, lpt, syncOk;
var lpbVM, lpbCM, lpbCHM, lpbLM, lpbRM, lpbLD1, lpbLD2, lpbOldLD1;
var lpbCHP, lpbPBS, nickRenderFunc, nickInvisibleLine;


if (FIRST_LINE_TO_SHOW + HEIGHT >= 312)
	window.alert("Bad configuration in nick.js: FIRST_LINE_TO_SHOW + HEIGHT must be less than 312 but it is: " + (FIRST_LINE_TO_SHOW + HEIGHT));
if (HARD_LIMIT_LINE <= 312 || HARD_LIMIT_LINE >= 360)
	window.alert("Bad configuration in nick.js: HARD_LIMIT_LINE must be greater than 312 and less than 340 but it is: " + HARD_LIMIT_LINE);


function setBORDER(n) {
	nickSetBorder = true;
	nickBorderR = palR[n];
	nickBorderG = palG[n];
	nickBorderB = palB[n];
	if (n != oldBORDER) {
		if (DEBUG_NICK) debug("NICK border: set to new value: " + n);
		oldBORDER = n;
	}
}


function setBIAS(n) {
	n = (n & 31) << 3;
	if (n == oldBIAS) return;
	if (DEBUG_NICK) debug("NICK bias: set to new value: " + n);
	oldBIAS = n;
	for (var i = 8; i < 16; i++ ) {
		lpbR[i] = palR[n];
		lpbG[i] = palG[n];
		lpbB[i] = palB[n++];
	}
}


function setLPT(reload) {
	lptBase = ((port[0x83] & 0xF) << 12) | (port[0x82] << 4);
	if (reload) {
		lpb[0] = 0; // emulate end of scanlines in current mode line
		lpb[1] |= 1; // emulate end of LPT (set the reload bit)
		nickSlot = 0; // slot 0 is set
		// these are needed to fool Nick emulation to reload LPT pointer
	}
	if (DEBUG_NICK_SET_LPT)
		debug("Nick LPT is set to 0x" + lptBase.toString(16) + " CLK=" + ((port[0x83] & 64) ? "yes" : "no") + " FORCE=" + (reload ? "yes" : "no"));
}



function nickPowerOn() {
	debug("Nick slots per second: " + NICK_SLOTS_PER_SEC);
	port[0x82] = Math.floor(Math.random() * 256);
	port[0x83] = Math.floor(Math.random() * 256) | 0xF0;
	refresh = false;
	debug("Initialize Nick with some random values.");
	setLPT(true);
	oldBIAS = -1;
	oldBORDER = -1;
	writeport(0x80, Math.floor(Math.random() * 256));
	writeport(0x81, Math.floor(Math.random() * 256));
	frameSkip = false;
	pixAddr = PIXADDR_INITIAL;
	//doScreenUpdate();
	debug("Nick power-on random defaults are set.");
}



function renderBorderSlot() {
	if (nickInvisibleLine) {
	//if (pixAddr < 0 || pixAddr >= PIXADDR_LIMIT || frameSkip) {
		pixAddr += 64;
		return;
	}
	for (var i = 0; i < 16; i++) {
		imageDataData[pixAddr++] = nickBorderR;
		imageDataData[pixAddr++] = nickBorderG;
		imageDataData[pixAddr++] = nickBorderB;
		pixAddr++;
	}
}

function renderBlackSlot() {
	if (nickInvisibleLine) {
		pixAddr += 64;
		return;
	}
	for (var i = 0; i < 16; i++) {
		imageDataData[pixAddr++] = 0;
		imageDataData[pixAddr++] = 0;
		imageDataData[pixAddr++] = 0;
		pixAddr++;
	}
}

function renderCharacterSlot() {
	if (nickInvisibleLine) {
		pixAddr += 64;
		lpbLD1++;
		return;
	}
	var i, col, data = vram[lpbLD1];
	var colmask = ((lpb[3] &  64) && (data & 128)) ? 2 : 0; // ALTIND1
	if ((lpb[3] & 128) && (data &  64)) colmask |= 4; // ALTIND0
	data  = vram[lpbLD2 | (data & lpbCHM)];
	switch (lpbCM) {
		case 0: // 2 colour mode (the default "official" character mode)
			// it is the normal version with loop
			for (i = 7; i >= 0; i--) {
				col = colmask | ((data >> i) & 1);
				imageDataData[pixAddr++] = lpbR[col]; imageDataData[pixAddr++] = lpbG[col]; imageDataData[pixAddr++] = lpbB[col]; pixAddr++;
				imageDataData[pixAddr++] = lpbR[col]; imageDataData[pixAddr++] = lpbG[col]; imageDataData[pixAddr++] = lpbB[col]; pixAddr++;
			}
			// let's try the unrolled-loop version too!
			/*col = colmask | ((data >> 7) & 1);
			imageDataData[pixAddr++] = lpbR[col]; imageDataData[pixAddr++] = lpbG[col]; imageDataData[pixAddr++] = lpbB[col]; pixAddr++;
			imageDataData[pixAddr++] = lpbR[col]; imageDataData[pixAddr++] = lpbG[col]; imageDataData[pixAddr++] = lpbB[col]; pixAddr++;
			col = colmask | ((data >> 6) & 1);
			imageDataData[pixAddr++] = lpbR[col]; imageDataData[pixAddr++] = lpbG[col]; imageDataData[pixAddr++] = lpbB[col]; pixAddr++;
			imageDataData[pixAddr++] = lpbR[col]; imageDataData[pixAddr++] = lpbG[col]; imageDataData[pixAddr++] = lpbB[col]; pixAddr++;
			col = colmask | ((data >> 5) & 1);
			imageDataData[pixAddr++] = lpbR[col]; imageDataData[pixAddr++] = lpbG[col]; imageDataData[pixAddr++] = lpbB[col]; pixAddr++;
			imageDataData[pixAddr++] = lpbR[col]; imageDataData[pixAddr++] = lpbG[col]; imageDataData[pixAddr++] = lpbB[col]; pixAddr++;
			col = colmask | ((data >> 4) & 1);
			imageDataData[pixAddr++] = lpbR[col]; imageDataData[pixAddr++] = lpbG[col]; imageDataData[pixAddr++] = lpbB[col]; pixAddr++;
			imageDataData[pixAddr++] = lpbR[col]; imageDataData[pixAddr++] = lpbG[col]; imageDataData[pixAddr++] = lpbB[col]; pixAddr++;
			col = colmask | ((data >> 3) & 1);
			imageDataData[pixAddr++] = lpbR[col]; imageDataData[pixAddr++] = lpbG[col]; imageDataData[pixAddr++] = lpbB[col]; pixAddr++;
			imageDataData[pixAddr++] = lpbR[col]; imageDataData[pixAddr++] = lpbG[col]; imageDataData[pixAddr++] = lpbB[col]; pixAddr++;
			col = colmask | ((data >> 2) & 1);
			imageDataData[pixAddr++] = lpbR[col]; imageDataData[pixAddr++] = lpbG[col]; imageDataData[pixAddr++] = lpbB[col]; pixAddr++;
			imageDataData[pixAddr++] = lpbR[col]; imageDataData[pixAddr++] = lpbG[col]; imageDataData[pixAddr++] = lpbB[col]; pixAddr++;
			col = colmask | ((data >> 1) & 1);
			imageDataData[pixAddr++] = lpbR[col]; imageDataData[pixAddr++] = lpbG[col]; imageDataData[pixAddr++] = lpbB[col]; pixAddr++;
			imageDataData[pixAddr++] = lpbR[col]; imageDataData[pixAddr++] = lpbG[col]; imageDataData[pixAddr++] = lpbB[col]; pixAddr++;
			col = colmask | (data & 1);
			imageDataData[pixAddr++] = lpbR[col]; imageDataData[pixAddr++] = lpbG[col]; imageDataData[pixAddr++] = lpbB[col]; pixAddr++;
			imageDataData[pixAddr++] = lpbR[col]; imageDataData[pixAddr++] = lpbG[col]; imageDataData[pixAddr++] = lpbB[col]; pixAddr++;*/
			break;
		case 1: // 4 colour mode
			data <<= 2;
			for (i = 0; i < 4; i++) {
				col = colmask | col4Trans[data | i];
				imageDataData[pixAddr++] = lpbR[col]; imageDataData[pixAddr++] = lpbG[col]; imageDataData[pixAddr++] = lpbB[col]; pixAddr++;
				imageDataData[pixAddr++] = lpbR[col]; imageDataData[pixAddr++] = lpbG[col]; imageDataData[pixAddr++] = lpbB[col]; pixAddr++;
				imageDataData[pixAddr++] = lpbR[col]; imageDataData[pixAddr++] = lpbG[col]; imageDataData[pixAddr++] = lpbB[col]; pixAddr++;
				imageDataData[pixAddr++] = lpbR[col]; imageDataData[pixAddr++] = lpbG[col]; imageDataData[pixAddr++] = lpbB[col]; pixAddr++;
			}
			break;
		case 2: // 16 colour mode
			data <<= 1;
			for (i = 0; i < 2; i++) {
				col = colmask | col16Trans[data | i];
				imageDataData[pixAddr++] = lpbR[col]; imageDataData[pixAddr++] = lpbG[col]; imageDataData[pixAddr++] = lpbB[col]; pixAddr++;
				imageDataData[pixAddr++] = lpbR[col]; imageDataData[pixAddr++] = lpbG[col]; imageDataData[pixAddr++] = lpbB[col]; pixAddr++;
				imageDataData[pixAddr++] = lpbR[col]; imageDataData[pixAddr++] = lpbG[col]; imageDataData[pixAddr++] = lpbB[col]; pixAddr++;
				imageDataData[pixAddr++] = lpbR[col]; imageDataData[pixAddr++] = lpbG[col]; imageDataData[pixAddr++] = lpbB[col]; pixAddr++;
				imageDataData[pixAddr++] = lpbR[col]; imageDataData[pixAddr++] = lpbG[col]; imageDataData[pixAddr++] = lpbB[col]; pixAddr++;
				imageDataData[pixAddr++] = lpbR[col]; imageDataData[pixAddr++] = lpbG[col]; imageDataData[pixAddr++] = lpbB[col]; pixAddr++;
				imageDataData[pixAddr++] = lpbR[col]; imageDataData[pixAddr++] = lpbG[col]; imageDataData[pixAddr++] = lpbB[col]; pixAddr++;
				imageDataData[pixAddr++] = lpbR[col]; imageDataData[pixAddr++] = lpbG[col]; imageDataData[pixAddr++] = lpbB[col]; pixAddr++;
			}
			break;
		case 3: // 256 colour mode (not using palette!)
			for (i = 0; i < 16; i++) {
				imageDataData[pixAddr++] = palR[data];
				imageDataData[pixAddr++] = palG[data];
				imageDataData[pixAddr++] = palB[data];
				pixAddr++;
			}
			break;
	}
	lpbLD1++;
}


/* This handles pixel and lpixel modes too, lpbPBS should be 2
 * (two bytes per slot) for PIXEL, and 1 (one byte per slot) for LPIXEL
 * mode. */
function renderPixelSlot() {
	if (nickInvisibleLine) {
		pixAddr += 64;
		lpbLD1 = (lpbLD1 + lpbPBS) & 0xFFFF;
		return;
	}
	var col, i, j, data, colmask;
	switch (lpbCM) {
		case 0: // 2 colour mode
			for (j = 0; j < lpbPBS; j++) {
				data = vram[lpbLD1++];
				lpbLD1 &= 0xFFFF;
				if ((lpb[2] & 128) && (data & 128)) { // MSBALT
					data &= 127;
					colmask = 2;
				} else
					colmask = 0;
				if ((lpb[2] & 64) && (data & 1)) { // LSBALT
					data &= 254;
					colmask |= 4;
				}
				for (i = 128; i > 0; i >>= 1) {
					col = ((data & i) ? 1 : 0) | colmask;
					imageDataData[pixAddr++] = lpbR[col]; imageDataData[pixAddr++] = lpbG[col]; imageDataData[pixAddr++] = lpbB[col];
					pixAddr++;
					if (lpbPBS == 1) {
						imageDataData[pixAddr++] = lpbR[col]; imageDataData[pixAddr++] = lpbG[col]; imageDataData[pixAddr++] = lpbB[col];
						pixAddr++;
					}
				}
			}
			break;
		case 1: // 4 colour mode
			for (j = 0; j < lpbPBS; j++) {
				data = vram[lpbLD1++] << 2;
				lpbLD1 &= 0xFFFF;
				for (i = 0; i < 4; i++) {
					col = col4Trans[data | i];
					imageDataData[pixAddr++] = lpbR[col]; imageDataData[pixAddr++] = lpbG[col]; imageDataData[pixAddr++] = lpbB[col];
					pixAddr++;
					imageDataData[pixAddr++] = lpbR[col]; imageDataData[pixAddr++] = lpbG[col]; imageDataData[pixAddr++] = lpbB[col];
					pixAddr++;
					if (lpbPBS == 1) {
						imageDataData[pixAddr++] = lpbR[col]; imageDataData[pixAddr++] = lpbG[col]; imageDataData[pixAddr++] = lpbB[col];
						pixAddr++;
						imageDataData[pixAddr++] = lpbR[col]; imageDataData[pixAddr++] = lpbG[col]; imageDataData[pixAddr++] = lpbB[col];
						pixAddr++;
					}
				}
			}
			break;
		case 2: // 16 colour mode
			for (j = 0; j < lpbPBS; j++) {
				data = vram[lpbLD1++] << 1;
				lpbLD1 &= 0xFFFF;
				for (i = 0; i < 2; i++) {
					col = col16Trans[data | i];
					imageDataData[pixAddr++] = lpbR[col]; imageDataData[pixAddr++] = lpbG[col]; imageDataData[pixAddr++] = lpbB[col];
					pixAddr++;
					imageDataData[pixAddr++] = lpbR[col]; imageDataData[pixAddr++] = lpbG[col]; imageDataData[pixAddr++] = lpbB[col];
					pixAddr++;
					imageDataData[pixAddr++] = lpbR[col]; imageDataData[pixAddr++] = lpbG[col]; imageDataData[pixAddr++] = lpbB[col];
					pixAddr++;
					imageDataData[pixAddr++] = lpbR[col]; imageDataData[pixAddr++] = lpbG[col]; imageDataData[pixAddr++] = lpbB[col];
					pixAddr++;
					if (lpbPBS == 1) {
						imageDataData[pixAddr++] = lpbR[col]; imageDataData[pixAddr++] = lpbG[col]; imageDataData[pixAddr++] = lpbB[col];
						pixAddr++;
						imageDataData[pixAddr++] = lpbR[col]; imageDataData[pixAddr++] = lpbG[col]; imageDataData[pixAddr++] = lpbB[col];
						pixAddr++;
						imageDataData[pixAddr++] = lpbR[col]; imageDataData[pixAddr++] = lpbG[col]; imageDataData[pixAddr++] = lpbB[col];
						pixAddr++;
						imageDataData[pixAddr++] = lpbR[col]; imageDataData[pixAddr++] = lpbG[col]; imageDataData[pixAddr++] = lpbB[col];
						pixAddr++;
					}
				}
			}
			break;
		case 3: // 256 colour mode: it directly outputs colours, so use palX arraies instead of lpbX ones!
			for (j = 0; j < lpbPBS; j++) {
				data = vram[lpbLD1++];
				lpbLD1 &= 0xFFFF;
				for (i = 0; i < 8; i++) {
					imageDataData[pixAddr++] = palR[data]; imageDataData[pixAddr++] = palG[data]; imageDataData[pixAddr++] = palB[data];
					pixAddr++;
					if (lpbPBS == 1) {
						imageDataData[pixAddr++] = palR[data]; imageDataData[pixAddr++] = palG[data]; imageDataData[pixAddr++] = palB[data];
						pixAddr++;
					}
				}
			}
			break;
	}
}

function renderAttributeSlot() {
	if (nickInvisibleLine) {
		pixAddr += 64;
		lpbLD1++;
		lpbLD2++;
		return;
	}
	var fg = vram[lpbLD1] & 15;
	var bg = vram[lpbLD1] >> 4;
	var data = vram[lpbLD2];
	var i, col;
	// TODO: what happens if non-2-colour mode is used with attribute mode?
	// TODO: are msbalt/lsbalt/altind0/altind1 valid for attribute mode? [answer: YES, but not so useful]
	for (i = 128; i; i >>= 1) {
		col = (data & i) ? fg : bg;
		imageDataData[pixAddr++] = lpbR[col];
		imageDataData[pixAddr++] = lpbG[col];
		imageDataData[pixAddr++] = lpbB[col];
		pixAddr++;
		imageDataData[pixAddr++] = lpbR[col];
		imageDataData[pixAddr++] = lpbG[col];
		imageDataData[pixAddr++] = lpbB[col];
		pixAddr++;
	}
	lpbLD1++;
	lpbLD2++;
}



function showVsyncStatus(st) {
	if (st == syncOk) return;
	syncOk = st;
	document.getElementById("status").style.background = (syncOk ? "#FFFFFF" : "#FFA0A0");
}



function doScreenUpdate() {
	if (pixAddr < PIXADDR_LIMIT) {
		if (DEBUG_SYNC_PROBLEM)
			debug("SYNC: too short frame: =" + (
			pixAddr / (4 * WIDTH) + FIRST_LINE_TO_SHOW
			));
		showVsyncStatus(false);
		return; // hack: do not "accept" VSYNC if it's before the last visible scanline within the frame
	}
	showVsyncStatus(pixAddr < PIXADDR_HARD_LIMIT);
	if (DEBUG_SYNC_PROBLEM && pixAddr >= PIXADDR_HARD_LIMIT)
		debug("SYNC: too long frame: >=" + (
			pixAddr / (4 * WIDTH) + FIRST_LINE_TO_SHOW
		));
	refresh = true;
	if (!frameSkip) {
		/* stupid thing: fill the remain non-updated screen with RED colour to signal SYNC problem */
		// THIS IS NOT NEEDED ANYMORE, SEE THE FIRST 'if' IN THIS FUNCTION!
		/*if (pixAddr < 0) pixAddr = 0;
		while (pixAddr < PIXADDR_LIMIT) {
			imageDataData[pixAddr++] = 255;
			imageDataData[pixAddr++] = 0;
			imageDataData[pixAddr++] = 0;
			pixAddr++;
		}*/
		//ctx.textBaseline = "top";
		//ctx.font = "bold 12px sans-serif";
		//ctx.fillText("LGB", 0, 0);
		/* send data to the browser! */
		ctx.putImageData(imageData, 0, 0);
		//ctx.fillText("LGb", 0, 0);
		/* if nick border has changed, let's modify the style info of the border */
		if (nickSetBorder) {
			canvas.style.borderColor = "rgb(" + nickBorderR + "," + nickBorderG + "," + nickBorderB + ")";
			nickSetBorder = false;
		}
	}
	pixAddr = PIXADDR_INITIAL;
}







/* used to emulate a single nick slot */
function nickDoSlot() {
	var i, j;
	if (nickSlot == 0) {
		if (lpb[0] == 0) { // end of modeline?
			if (port[0x83] & 64) { // bit 6 is set: allows clocking LPT (normal operation)
				if (lpb[1] & 1) // bit 0 is set: this was the last LPB
					lpt = lptBase;
				else
					lpt &= 0xFFFF; // next LPB is OK, but watch out for address wrapping-around!
			} else
				lpt = (lpt - 0x10) & 0xFFFF; // LPT clocking is disabled, re-positioning for the previous LPB, handle address wrapping
			// load the first byte of LPB (scanlines in this modeline)
			// (note: lpt is 16 byte aligned, so we don't need to worry about vram overflow in address during the lpt read at least!)
			lpb[0] = vram[lpt++] + 1; // actually we store +1, as the condition for next modeline is == 0
			// load the second byte of LPB
			i = vram[lpt++];
			lpbVM = (i >> 1) & 7;
			lpbCM = (i >> 5) & 3;
			// VSYNC mode! hacky stuff currently only non-vsync -> vsync modeline change is used
			if ((!lpbVM) && (lpb[1] & 14)) doScreenUpdate();
			daveSetINT1(i & 128); // This is the video interrupt, see comments in dave.js
			lpb[1] = i; // now we can store the second byte of LPB
			// load the rest of 6 bytes of LPB before the palette information
			lpb[2] = vram[lpt++]; lpb[3] = vram[lpt++]; lpb[4] = vram[lpt++];
			lpb[5] = vram[lpt++]; lpb[6] = vram[lpt++]; lpb[7] = vram[lpt++];
			// create some internal variables
			lpbLM = lpb[2] & 63;
			lpbRM = lpb[3] & 63;
			lpbLD1 = lpb[4] | (lpb[5] << 8);
			lpbLD2 = lpb[6] | (lpb[7] << 8);
			lpbOldLD1 = lpbLD1;
			// setup video mode dependent things
			/*
			if (lpbRM < lpbLM) {
				nickRenderFunc = renderBorderSlot;
				lpbCHP = 0;
			} else */ switch (lpbVM) {
				case 0: // VSYNC mode
					lpbCHP = 0;
					nickRenderFunc = renderBlackSlot;
					break;
				case 1: // PIXEL mode
					lpbCHP = 0;
					lpbPBS = 2; // two bytes per slot
					nickRenderFunc = renderPixelSlot;
					break;
				case 2: // ATTRIBUTE mode
					lpbCHP = 0;
					nickRenderFunc = renderAttributeSlot;
					break;
				case 3: // CH256 mode
					lpbCHP = 256;
					lpbLD2 = (lpbLD2 << 8) & 0xFFFF;
					nickRenderFunc = renderCharacterSlot;
					break;
				case 4: // CH128 mode
					lpbCHP = 128;
					lpbLD2 = (lpbLD2 << 7) & 0xFFFF;
					nickRenderFunc = renderCharacterSlot;
					break;
				case 5: // CH64 mode
					lpbCHP =  64;
					lpbLD2 = (lpbLD2 << 6) & 0xFFFF;
					nickRenderFunc = renderCharacterSlot;
					break;
				case 6: // UNUSED!
					lpbCHP = 0;
					nickRenderFunc = renderBlackSlot;
					break;
				case 7: // LPIXEL mode
					lpbCHP = 0;
					lpbPBS = 1; // one byte per slot
					nickRenderFunc = renderPixelSlot;
					break;
			}
			lpbCHM = lpbCHP - 1;
			// load 8 palette colors from LPB, decode as RGB values to speed up rendering later
			// note: the second 8 colours are in these arraies too, but that is altered with the writeport() if nick BIAS is modified only!
			for (i = 0; i < 8; i++) {
				j = vram[lpt++];
				lpbR[i] = palR[j];
				lpbG[i] = palG[j];
				lpbB[i] = palB[j];
			}
		} else { // not end of mode-line!
			lpb[0]++; // advance scanline counter
			if (!(lpb[1] & 16)) // the VRES bit, if it's clear, LD1 should be reloaded
				lpbLD1 = lpbOldLD1;
			lpbLD2 += lpbCHP; // this only means something for character modes (otherwise lpbCHP is zero, so it won't hurt)
		}
		if (pixAddr >= PIXADDR_HARD_LIMIT) doScreenUpdate(); // emergency update (missing VSYNC, too "long" frame)
		nickSlot = 1;
		nickInvisibleLine = (pixAddr < 0 || pixAddr >= PIXADDR_LIMIT || frameSkip);
		return;
	}
	if (nickSlot == 56) {
		nickSlot = 0;
		return;
	}
	if (nickSlot < 8 || nickSlot > 53) {
		nickSlot++;
		return;
	}
	/*if (nickSlot < 8 || nickSlot > 53) {
		nickSlot = ((nickSlot == 56) ? 0 : (nickSlot + 1)); // advance slot counter, or reset to zero if it was the last one
		return;
	}*/
	if (nickSlot < lpbLM || nickSlot >= lpbRM) {
		renderBorderSlot();
		nickSlot++;
		return;
	}
	// other "normal" slots. We normalize LD1/LD2 just in case if vram address overflow occurs
	lpbLD1 &= 0xFFFF;
	lpbLD2 &= 0xFFFF;
	nickRenderFunc(); // call the slot render callback
	nickSlot++;
}
